/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockFlattener;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.UncheckedStackArrayAllocator;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.operator.repartition.PartitionedOutputOperator;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class OptimizedPartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Function<Page, Page> pagePreprocessor;
    private final PagePartitioner pagePartitioner;
    private final LocalMemoryContext systemMemoryContext;
    private boolean finished;

    public OptimizedPartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.pagePartitioner = new PagePartitioner(partitionFunction, partitionChannels, partitionConstants, replicatesAnyRow, nullChannel, outputBuffer, serdeFactory, sourceTypes, maxMemory, operatorContext.getDriverContext().getLifespan());
        operatorContext.setInfoSupplier(this::getInfo);
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(PartitionedOutputOperator.class.getSimpleName());
        this.systemMemoryContext.setBytes(this.pagePartitioner.getRetainedSizeInBytes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public PartitionedOutputInfo getInfo() {
        return this.pagePartitioner.getInfo();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.pagePartitioner.flush();
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.pagePartitioner.isFull();
        return blocked.isDone() ? NOT_BLOCKED : blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.pagePartitioner.partitionPage(page);
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
        this.systemMemoryContext.setBytes(this.pagePartitioner.getRetainedSizeInBytes());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @VisibleForTesting
    static DecodedBlockNode decodeBlock(BlockFlattener flattener, Closer blockLeaseCloser, Block block) {
        BlockLease lease = flattener.flatten(block);
        blockLeaseCloser.register(() -> ((BlockLease)lease).close());
        Block decodedBlock = (Block)lease.get();
        long estimatedSizeInBytes = decodedBlock.getLogicalSizeInBytes();
        if (decodedBlock instanceof ArrayBlock) {
            ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)decodedBlock);
            Block childBlock = columnarArray.getElementsBlock();
            return new DecodedBlockNode(columnarArray, (List<DecodedBlockNode>)ImmutableList.of((Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, childBlock)), columnarArray.getRetainedSizeInBytes(), estimatedSizeInBytes);
        }
        if (decodedBlock instanceof MapBlock) {
            ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)decodedBlock);
            Block keyBlock = columnarMap.getKeysBlock();
            Block valueBlock = columnarMap.getValuesBlock();
            return new DecodedBlockNode(columnarMap, (List<DecodedBlockNode>)ImmutableList.of((Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, keyBlock), (Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, valueBlock)), columnarMap.getRetainedSizeInBytes(), estimatedSizeInBytes);
        }
        if (decodedBlock instanceof RowBlock) {
            ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)decodedBlock);
            ImmutableList.Builder children = ImmutableList.builder();
            for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
                Block childBlock = columnarRow.getField(i);
                children.add((Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, childBlock));
            }
            return new DecodedBlockNode(columnarRow, (List<DecodedBlockNode>)children.build(), columnarRow.getRetainedSizeInBytes(), estimatedSizeInBytes);
        }
        if (decodedBlock instanceof DictionaryBlock) {
            Block dictionary = ((DictionaryBlock)decodedBlock).getDictionary();
            return new DecodedBlockNode(decodedBlock, (List<DecodedBlockNode>)ImmutableList.of((Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, dictionary)), decodedBlock.getRetainedSizeInBytes(), estimatedSizeInBytes);
        }
        if (decodedBlock instanceof RunLengthEncodedBlock) {
            Block childBlock = ((RunLengthEncodedBlock)decodedBlock).getValue();
            return new DecodedBlockNode(decodedBlock, (List<DecodedBlockNode>)ImmutableList.of((Object)OptimizedPartitionedOutputOperator.decodeBlock(flattener, blockLeaseCloser, childBlock)), decodedBlock.getRetainedSizeInBytes(), estimatedSizeInBytes);
        }
        return new DecodedBlockNode(decodedBlock, (List<DecodedBlockNode>)ImmutableList.of(), block.getRetainedSizeInBytes(), estimatedSizeInBytes);
    }

    private static class PartitionBuffer {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(PartitionBuffer.class).instanceSize();
        private final int partition;
        private final AtomicLong rowsAdded;
        private final AtomicLong pagesAdded;
        private final PagesSerde serde;
        private final Lifespan lifespan;
        private final int capacity;
        private final int channelCount;
        private final ArrayAllocator bufferAllocator;
        private int[] positions;
        private int positionCount;
        private BlockEncodingBuffer[] blockEncodingBuffers;
        private int bufferedRowCount;
        private boolean bufferFull;

        PartitionBuffer(int partition, int channelCount, int capacity, AtomicLong pagesAdded, AtomicLong rowsAdded, PagesSerde serde, Lifespan lifespan, ArrayAllocator bufferAllocator) {
            this.partition = partition;
            this.channelCount = channelCount;
            this.capacity = capacity;
            this.pagesAdded = Objects.requireNonNull(pagesAdded, "pagesAdded is null");
            this.rowsAdded = Objects.requireNonNull(rowsAdded, "rowsAdded is null");
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
            this.bufferAllocator = Objects.requireNonNull(bufferAllocator, "bufferAllocator is null");
        }

        private void resetPositions(int estimatedPositionCount) {
            this.positions = Arrays.ensureCapacity((int[])this.positions, (int)estimatedPositionCount);
            this.positionCount = 0;
        }

        private void addPosition(int position) {
            this.positions = Arrays.ensureCapacity((int[])this.positions, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.MEDIUM, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
            this.positions[this.positionCount++] = position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendData(DecodedBlockNode[] decodedBlocks, long estimatedSerializedPageSize, int fixedWidthRowSize, List<Integer> variableWidthChannels, OutputBuffer outputBuffer) {
            if (decodedBlocks.length != this.channelCount) {
                throw new IllegalArgumentException(String.format("Unexpected number of decoded blocks %d. It should be %d.", decodedBlocks.length, this.channelCount));
            }
            if (this.positionCount == 0) {
                return;
            }
            if (this.channelCount == 0) {
                this.bufferedRowCount += this.positionCount;
                return;
            }
            this.initializeBlockEncodingBuffers(decodedBlocks);
            for (int i = 0; i < this.channelCount; ++i) {
                this.blockEncodingBuffers[i].setupDecodedBlocksAndPositions(decodedBlocks[i], this.positions, this.positionCount, this.capacity, estimatedSerializedPageSize);
            }
            int[] serializedRowSizes = Arrays.ensureCapacity(null, (int)this.positionCount, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.INITIALIZE, (ArrayAllocator)this.bufferAllocator);
            try {
                this.populateSerializedRowSizes(fixedWidthRowSize, variableWidthChannels, serializedRowSizes);
                int offset = 0;
                do {
                    this.bufferFull = false;
                    int batchSize = this.calculateNextBatchSize(fixedWidthRowSize, variableWidthChannels, offset, serializedRowSizes);
                    for (int i = 0; i < this.channelCount; ++i) {
                        this.blockEncodingBuffers[i].setNextBatch(offset, batchSize);
                        this.blockEncodingBuffers[i].appendDataInBatch();
                    }
                    this.bufferedRowCount += batchSize;
                    offset += batchSize;
                    if (!this.bufferFull) continue;
                    this.flush(outputBuffer);
                } while (offset < this.positionCount);
            }
            finally {
                this.bufferAllocator.returnArray(serializedRowSizes);
                for (int i = this.channelCount - 1; i >= 0; --i) {
                    this.blockEncodingBuffers[i].noMoreBatches();
                }
            }
        }

        private void initializeBlockEncodingBuffers(DecodedBlockNode[] decodedBlocks) {
            if (this.blockEncodingBuffers == null) {
                BlockEncodingBuffer[] buffers = new BlockEncodingBuffer[this.channelCount];
                for (int i = 0; i < this.channelCount; ++i) {
                    buffers[i] = AbstractBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlocks[i], this.bufferAllocator, false);
                }
                this.blockEncodingBuffers = buffers;
            }
        }

        private void populateSerializedRowSizes(int fixedWidthRowSize, List<Integer> variableWidthChannels, int[] serializedRowSizes) {
            if (variableWidthChannels.isEmpty()) {
                return;
            }
            for (int i : variableWidthChannels) {
                this.blockEncodingBuffers[i].accumulateSerializedRowSizes(serializedRowSizes);
            }
            int i = 0;
            while (i < this.positionCount) {
                int n = i++;
                serializedRowSizes[n] = serializedRowSizes[n] + fixedWidthRowSize;
            }
        }

        private int calculateNextBatchSize(int fixedWidthRowSize, List<Integer> variableWidthChannels, int startPosition, int[] serializedRowSizes) {
            int bytesRemaining = this.capacity - this.getSerializedBuffersSizeInBytes();
            if (variableWidthChannels.isEmpty()) {
                int maxPositionsFit = Math.max(bytesRemaining / fixedWidthRowSize, 1);
                if (maxPositionsFit <= this.positionCount - startPosition) {
                    this.bufferFull = true;
                    return maxPositionsFit;
                }
                return this.positionCount - startPosition;
            }
            Verify.verify((serializedRowSizes != null ? 1 : 0) != 0);
            for (int i = startPosition; i < this.positionCount; ++i) {
                if ((bytesRemaining -= serializedRowSizes[i]) > 0) continue;
                this.bufferFull = true;
                return Math.max(i - startPosition, 1);
            }
            return this.positionCount - startPosition;
        }

        private void flush(OutputBuffer outputBuffer) {
            if (this.bufferedRowCount == 0) {
                return;
            }
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(this.getSerializedBuffersSizeInBytes()));
            output.writeInt(this.channelCount);
            for (int i = 0; i < this.channelCount; ++i) {
                this.blockEncodingBuffers[i].serializeTo((SliceOutput)output);
                this.blockEncodingBuffers[i].resetBuffers();
            }
            SerializedPage serializedPage = this.serde.serialize(output.slice(), this.bufferedRowCount);
            outputBuffer.enqueue(this.lifespan, this.partition, (List<SerializedPage>)ImmutableList.of((Object)serializedPage));
            this.pagesAdded.incrementAndGet();
            this.rowsAdded.addAndGet(this.bufferedRowCount);
            this.bufferedRowCount = 0;
        }

        private long getRetainedSizeInBytes() {
            long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.positions);
            if (this.blockEncodingBuffers != null) {
                for (int i = 0; i < this.channelCount; ++i) {
                    size += this.blockEncodingBuffers[i].getRetainedSizeInBytes();
                }
            }
            return size;
        }

        private int getSerializedBuffersSizeInBytes() {
            int size = 0;
            for (int i = 0; i < this.channelCount; ++i) {
                size = (int)((long)size + this.blockEncodingBuffers[i].getSerializedSizeInBytes());
            }
            return 4 + size;
        }
    }

    private static class PagePartitioner {
        private final OutputBuffer outputBuffer;
        private final PartitionFunction partitionFunction;
        private final int[] partitionChannels;
        @Nullable
        private final Block[] partitionConstantBlocks;
        private final PagesSerde serde;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final AtomicLong rowsAdded = new AtomicLong();
        private final AtomicLong pagesAdded = new AtomicLong();
        private final ArrayAllocator blockDecodingAllocator = new UncheckedStackArrayAllocator(500);
        private final BlockFlattener flattener = new BlockFlattener(this.blockDecodingAllocator);
        private final Closer blockLeaseCloser = Closer.create();
        private final ArrayAllocator bufferAllocator = new UncheckedStackArrayAllocator(2000);
        private final PartitionBuffer[] partitionBuffers;
        private final List<Type> sourceTypes;
        private final List<Integer> variableWidthChannels;
        private final int fixedWidthRowSize;
        private final DecodedBlockNode[] decodedBlocks;
        private boolean hasAnyRowBeenReplicated;

        public PagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, List<Type> sourceTypes, DataSize maxMemory, Lifespan lifespan) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "pagePartitioner is null");
            this.partitionChannels = Ints.toArray((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            Block[] partitionConstantBlocks = (Block[])Objects.requireNonNull(partitionConstants, "partitionConstants is null").stream().map(constant -> constant.map(ConstantExpression::getValueBlock).orElse(null)).toArray(Block[]::new);
            this.partitionConstantBlocks = java.util.Arrays.stream(partitionConstantBlocks).anyMatch(Objects::nonNull) ? partitionConstantBlocks : null;
            for (int i = 0; i < this.partitionChannels.length; ++i) {
                if (this.partitionChannels[i] >= 0) continue;
                Preconditions.checkArgument((this.partitionConstantBlocks != null && this.partitionConstantBlocks[i] != null ? 1 : 0) != 0, (String)"Expected constant for partitioning channel %s, but none was found", (int)i);
            }
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serde = Objects.requireNonNull(serdeFactory, "serdeFactory is null").createPagesSerde();
            int partitionCount = partitionFunction.getPartitionCount();
            int partitionBufferCapacity = Math.max(1, Math.min(0x100000, Math.toIntExact(maxMemory.toBytes()) / partitionCount));
            this.partitionBuffers = new PartitionBuffer[partitionCount];
            for (int i = 0; i < partitionCount; ++i) {
                this.partitionBuffers[i] = new PartitionBuffer(i, sourceTypes.size(), partitionBufferCapacity, this.pagesAdded, this.rowsAdded, this.serde, lifespan, this.bufferAllocator);
            }
            this.sourceTypes = sourceTypes;
            this.decodedBlocks = new DecodedBlockNode[sourceTypes.size()];
            ImmutableList.Builder variableWidthChannels = ImmutableList.builder();
            int fixedWidthRowSize = 0;
            for (int i = 0; i < sourceTypes.size(); ++i) {
                int bytesPerPosition = PagePartitioner.getFixedWidthTypeSize(sourceTypes.get(i));
                fixedWidthRowSize += bytesPerPosition;
                if (bytesPerPosition != 0) continue;
                variableWidthChannels.add((Object)i);
            }
            this.variableWidthChannels = variableWidthChannels.build();
            this.fixedWidthRowSize = fixedWidthRowSize;
        }

        public ListenableFuture<?> isFull() {
            return this.outputBuffer.isFull();
        }

        public PartitionedOutputInfo getInfo() {
            return new PartitionedOutputInfo(this.rowsAdded.get(), this.pagesAdded.get(), this.outputBuffer.getPeakMemoryUsage());
        }

        public void partitionPage(Page page) {
            int i;
            int positionCount = page.getPositionCount();
            int initialPositionCountForEachBuffer = Math.min(positionCount, (positionCount / this.partitionFunction.getPartitionCount() + 1) * 2);
            for (int i2 = 0; i2 < this.partitionBuffers.length; ++i2) {
                this.partitionBuffers[i2].resetPositions(initialPositionCountForEachBuffer);
            }
            Block nullBlock = this.nullChannel.isPresent() ? page.getBlock(this.nullChannel.getAsInt()) : null;
            Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
            for (int position = 0; position < positionCount; ++position) {
                boolean shouldReplicate;
                boolean bl = shouldReplicate = this.replicatesAnyRow && !this.hasAnyRowBeenReplicated || nullBlock != null && nullBlock.isNull(position);
                if (shouldReplicate) {
                    for (i = 0; i < this.partitionBuffers.length; ++i) {
                        this.partitionBuffers[i].addPosition(position);
                    }
                    this.hasAnyRowBeenReplicated = true;
                    continue;
                }
                int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                this.partitionBuffers[partition].addPosition(position);
            }
            long estimatedSerializedPageSize = 0L;
            for (i = 0; i < this.decodedBlocks.length; ++i) {
                this.decodedBlocks[i] = OptimizedPartitionedOutputOperator.decodeBlock(this.flattener, this.blockLeaseCloser, page.getBlock(i));
                estimatedSerializedPageSize += this.decodedBlocks[i].getEstimatedSerializedSizeInBytes();
            }
            for (i = 0; i < this.partitionBuffers.length; ++i) {
                this.partitionBuffers[i].appendData(this.decodedBlocks, estimatedSerializedPageSize, this.fixedWidthRowSize, this.variableWidthChannels, this.outputBuffer);
            }
            try {
                this.blockLeaseCloser.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void flush() {
            for (int i = 0; i < this.partitionBuffers.length; ++i) {
                this.partitionBuffers[i].flush(this.outputBuffer);
            }
        }

        public long getRetainedSizeInBytes() {
            int i;
            long size = this.bufferAllocator.getEstimatedSizeInBytes();
            for (i = 0; i < this.partitionBuffers.length; ++i) {
                size += this.partitionBuffers[i].getRetainedSizeInBytes();
            }
            for (i = 0; i < this.decodedBlocks.length; ++i) {
                size += this.decodedBlocks[i] == null ? 0L : this.decodedBlocks[i].getRetainedSizeInBytes();
            }
            return size;
        }

        private Page getPartitionFunctionArguments(Page page) {
            if (this.partitionConstantBlocks == null) {
                return page.extractChannels(this.partitionChannels);
            }
            Block[] blocks = new Block[this.partitionChannels.length];
            for (int i = 0; i < blocks.length; ++i) {
                int channel = this.partitionChannels[i];
                blocks[i] = channel < 0 ? new RunLengthEncodedBlock(this.partitionConstantBlocks[i], page.getPositionCount()) : page.getBlock(channel);
            }
            return new Page(page.getPositionCount(), blocks);
        }

        private static int getFixedWidthTypeSize(Type type) {
            int bytesPerPosition = 0;
            if (type instanceof FixedWidthType) {
                bytesPerPosition = ((FixedWidthType)type).getFixedSize() + 1;
            }
            return bytesPerPosition;
        }
    }

    public static class OptimizedPartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<ConstantExpression>> partitionConstants;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final OutputBuffer outputBuffer;
        private final PagesSerdeFactory serdeFactory;
        private final DataSize maxMemory;

        public OptimizedPartitionedOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PartitionedOutputOperator.class.getSimpleName());
            return new OptimizedPartitionedOutputOperator(operatorContext, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new OptimizedPartitionedOutputOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }
    }

    public static class OptimizedPartitionedOutputFactory
    implements OutputFactory {
        private final OutputBuffer outputBuffer;
        private final DataSize maxMemory;

        public OptimizedPartitionedOutputFactory(OutputBuffer outputBuffer, DataSize maxMemory) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            Preconditions.checkArgument((boolean)outputPartitioning.isPresent(), (Object)"outputPartitioning is not present");
            return new OptimizedPartitionedOutputOperatorFactory(operatorId, planNodeId, types, pagePreprocessor, outputPartitioning.get().getPartitionFunction(), outputPartitioning.get().getPartitionChannels(), outputPartitioning.get().getPartitionConstants(), outputPartitioning.get().isReplicateNullsAndAny(), outputPartitioning.get().getNullChannel(), this.outputBuffer, serdeFactory, this.maxMemory);
        }
    }
}

