/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.PageReference;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

class RandomExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;

    public RandomExchanger(List<Consumer<PageReference>> buffers, LocalExchangeMemoryManager memoryManager) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    @Override
    public void accept(Page page) {
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        PageReference pageReference = new PageReference(page, 1, () -> this.memoryManager.updateMemoryUsage(-page.getRetainedSizeInBytes()));
        int randomIndex = ThreadLocalRandom.current().nextInt(this.buffers.size());
        this.buffers.get(randomIndex).accept(pageReference);
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

