/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleHistogram;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class PrecisionRecallStateSerializer
implements AccumulatorStateSerializer<PrecisionRecallState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(PrecisionRecallState state, BlockBuilder out) {
        int requiredBytes = 1;
        if (state.getTrueWeights() != null) {
            requiredBytes += state.getTrueWeights().getRequiredBytesForSerialization();
            requiredBytes += state.getFalseWeights().getRequiredBytesForSerialization();
        }
        SliceOutput sliceOut = Slices.allocate((int)requiredBytes).getOutput();
        sliceOut.appendByte(state.getTrueWeights() == null ? 0 : 1);
        if (state.getTrueWeights() != null) {
            state.getTrueWeights().serialize(sliceOut);
            state.getFalseWeights().serialize(sliceOut);
        }
        VarbinaryType.VARBINARY.writeSlice(out, sliceOut.getUnderlyingSlice());
    }

    public void deserialize(Block block, int index, PrecisionRecallState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        byte hasHistograms = input.readByte();
        Preconditions.checkArgument((hasHistograms == 0 || hasHistograms == 1 ? 1 : 0) != 0, (String)"hasHistogram %s should be boolean-convertible", (int)hasHistograms);
        if (hasHistograms == 1) {
            state.setTrueWeights(FixedDoubleHistogram.deserialize((SliceInput)input));
            state.setFalseWeights(FixedDoubleHistogram.deserialize((SliceInput)input));
        }
    }
}

