/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.histogram;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.HashCommon;

public class HashUtil {
    private HashUtil() {
    }

    public static int nextProbeLinear(int probeCount) {
        return probeCount;
    }

    public static int nextSumOfCount(int probeCount) {
        return probeCount * (probeCount + 1) / 2;
    }

    public static int nextSumOfSquares(int probeCount) {
        return probeCount * (probeCount * probeCount + 1) / 2;
    }

    public static int nextBucketId(int bucketId, int mask, int probe) {
        return bucketId + probe & mask;
    }

    public static int calculateMaxFill(int bucketCount, float fillRatio) {
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be greater than 0");
        int maxFill = (int)Math.ceil((float)bucketCount * fillRatio);
        if (maxFill == bucketCount) {
            --maxFill;
        }
        Preconditions.checkArgument((bucketCount > maxFill ? 1 : 0) != 0, (Object)"bucketCount must be larger than maxFill");
        return maxFill;
    }

    public static int computeBucketCount(int expectedSize, float fillRatio) {
        return HashCommon.arraySize((int)expectedSize, (float)fillRatio);
    }
}

