/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction
public final class VarianceAggregation {
    private VarianceAggregation() {
    }

    @InputFunction
    public static void doubleInput(@AggregationState VarianceState state, @SqlType(value="double") double value) {
        AggregationUtils.updateVarianceState(state, value);
    }

    @InputFunction
    public static void bigintInput(@AggregationState VarianceState state, @SqlType(value="bigint") long value) {
        AggregationUtils.updateVarianceState(state, value);
    }

    @CombineFunction
    public static void combine(@AggregationState VarianceState state, @AggregationState VarianceState otherState) {
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @AggregationFunction(value="variance", alias={"var_samp"})
    @Description(value="Returns the sample variance of the argument")
    @OutputFunction(value="double")
    public static void variance(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="var_pop")
    @Description(value="Returns the population variance of the argument")
    @OutputFunction(value="double")
    public static void variancePop(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev", alias={"stddev_samp"})
    @Description(value="Returns the sample standard deviation of the argument")
    @OutputFunction(value="double")
    public static void stddev(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="stddev_pop")
    @Description(value="Returns the population standard deviation of the argument")
    @OutputFunction(value="double")
    public static void stddevPop(@AggregationState VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (count == 0L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)count;
            result = Math.sqrt(result);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

