/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.JoinBridge;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.ReferenceCount;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class JoinBridgeManager<T extends JoinBridge> {
    private final List<Type> buildOutputTypes;
    private final boolean buildOuter;
    private final PipelineExecutionStrategy probeExecutionStrategy;
    private final PipelineExecutionStrategy buildExecutionStrategy;
    private final Function<Lifespan, T> joinBridgeProvider;
    private final FreezeOnReadCounter probeFactoryCount = new FreezeOnReadCounter();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private InternalJoinBridgeDataManager<T> internalJoinBridgeDataManager;

    @VisibleForTesting
    public static JoinBridgeManager<PartitionedLookupSourceFactory> lookupAllAtOnce(PartitionedLookupSourceFactory factory) {
        return new JoinBridgeManager<PartitionedLookupSourceFactory>(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, ignored -> factory, factory.getOutputTypes());
    }

    public JoinBridgeManager(boolean buildOuter, PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, T> lookupSourceFactoryProvider, List<Type> buildOutputTypes) {
        this.buildOuter = buildOuter;
        this.probeExecutionStrategy = Objects.requireNonNull(probeExecutionStrategy, "probeExecutionStrategy is null");
        this.buildExecutionStrategy = Objects.requireNonNull(lookupSourceExecutionStrategy, "lookupSourceExecutionStrategy is null");
        this.joinBridgeProvider = Objects.requireNonNull(lookupSourceFactoryProvider, "joinBridgeProvider is null");
        this.buildOutputTypes = Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary() {
        if (!this.initialized.get()) {
            JoinBridgeManager joinBridgeManager = this;
            synchronized (joinBridgeManager) {
                if (this.initialized.get()) {
                    return;
                }
                int finalProbeFactoryCount = this.probeFactoryCount.get();
                this.internalJoinBridgeDataManager = JoinBridgeManager.internalJoinBridgeDataManager(this.probeExecutionStrategy, this.buildExecutionStrategy, this.joinBridgeProvider, finalProbeFactoryCount, this.buildOuter ? 1 : 0);
                this.initialized.set(true);
            }
        }
    }

    public List<Type> getBuildOutputTypes() {
        return this.buildOutputTypes;
    }

    public PipelineExecutionStrategy getBuildExecutionStrategy() {
        return this.buildExecutionStrategy;
    }

    public void incrementProbeFactoryCount() {
        this.probeFactoryCount.increment();
    }

    public T getJoinBridge(Lifespan lifespan) {
        this.initializeIfNecessary();
        return this.internalJoinBridgeDataManager.getJoinBridge(lifespan);
    }

    public void probeOperatorFactoryClosedForAllLifespans() {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.probeOperatorFactoryClosedForAllLifespans();
    }

    public void probeOperatorFactoryClosed(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.probeOperatorFactoryClosed(lifespan);
    }

    public void probeOperatorCreated(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.probeOperatorCreated(lifespan);
    }

    public void probeOperatorClosed(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.probeOperatorClosed(lifespan);
    }

    public void outerOperatorFactoryClosed(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.outerOperatorFactoryClosed(lifespan);
    }

    public void outerOperatorCreated(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.outerOperatorCreated(lifespan);
    }

    public void outerOperatorClosed(Lifespan lifespan) {
        this.initializeIfNecessary();
        this.internalJoinBridgeDataManager.outerOperatorClosed(lifespan);
    }

    public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
        this.initializeIfNecessary();
        return this.internalJoinBridgeDataManager.getOuterPositionsFuture(lifespan);
    }

    private static <T extends JoinBridge> InternalJoinBridgeDataManager<T> internalJoinBridgeDataManager(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy buildExecutionStrategy, Function<Lifespan, T> joinBridgeProvider, int probeFactoryCount, int outerFactoryCount) {
        Preconditions.checkArgument((outerFactoryCount == 0 || outerFactoryCount == 1 ? 1 : 0) != 0, (Object)"outerFactoryCount should only be 0 or 1 because it is expected that outer factory never gets duplicated.");
        switch (probeExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                switch (buildExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new TaskWideInternalJoinBridgeDataManager<T>(joinBridgeProvider, probeFactoryCount, outerFactoryCount);
                    }
                    case GROUPED_EXECUTION: {
                        throw new UnsupportedOperationException("Invalid combination. Lookup source should not be grouped if probe is not going to take advantage of it.");
                    }
                }
                throw new IllegalArgumentException("Unknown buildExecutionStrategy: " + (Object)((Object)buildExecutionStrategy));
            }
            case GROUPED_EXECUTION: {
                switch (buildExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new SharedInternalJoinBridgeDataManager<T>(joinBridgeProvider, probeFactoryCount, outerFactoryCount);
                    }
                    case GROUPED_EXECUTION: {
                        return new OneToOneInternalJoinBridgeDataManager<T>(joinBridgeProvider, probeFactoryCount, outerFactoryCount);
                    }
                }
                throw new IllegalArgumentException("Unknown buildExecutionStrategy: " + (Object)((Object)buildExecutionStrategy));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class FreezeOnReadCounter {
        private int count;
        private boolean frozen;

        private FreezeOnReadCounter() {
        }

        public synchronized void increment() {
            Preconditions.checkState((!this.frozen ? 1 : 0) != 0, (Object)"Counter has been read");
            ++this.count;
        }

        public synchronized int get() {
            this.frozen = true;
            return this.count;
        }
    }

    private static class JoinLifecycle {
        private final ReferenceCount probeReferenceCount;
        private final ReferenceCount outerReferenceCount;
        private final ListenableFuture<?> whenBuildAndProbeFinishes;
        private final ListenableFuture<?> whenAllFinishes;

        public JoinLifecycle(JoinBridge joinBridge, int probeFactoryCount, int outerFactoryCount) {
            Preconditions.checkArgument((outerFactoryCount == 0 || outerFactoryCount == 1 ? 1 : 0) != 0);
            this.outerReferenceCount = new ReferenceCount(outerFactoryCount);
            this.probeReferenceCount = new ReferenceCount(probeFactoryCount);
            this.whenBuildAndProbeFinishes = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{joinBridge.whenBuildFinishes(), this.probeReferenceCount.getFreeFuture()}).call(() -> null, MoreExecutors.directExecutor());
            this.whenAllFinishes = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.whenBuildAndProbeFinishes, this.outerReferenceCount.getFreeFuture()}).call(() -> null, MoreExecutors.directExecutor());
            this.whenAllFinishes.addListener(joinBridge::destroy, MoreExecutors.directExecutor());
        }

        public ListenableFuture<?> whenBuildAndProbeFinishes() {
            return this.whenBuildAndProbeFinishes;
        }

        private void retainForProbe() {
            this.probeReferenceCount.retain();
        }

        private void releaseForProbe() {
            this.probeReferenceCount.release();
        }

        private void retainForOuter() {
            this.outerReferenceCount.retain();
        }

        private void releaseForOuter() {
            this.outerReferenceCount.release();
        }
    }

    private static class SharedInternalJoinBridgeDataManager<T extends JoinBridge>
    implements InternalJoinBridgeDataManager<T> {
        private final T taskWideJoinBridge;
        private final JoinLifecycle joinLifecycle;

        public SharedInternalJoinBridgeDataManager(Function<Lifespan, T> lookupSourceFactoryProvider, int probeFactoryCount, int outerFactoryCount) {
            this.taskWideJoinBridge = (JoinBridge)lookupSourceFactoryProvider.apply(Lifespan.taskWide());
            this.joinLifecycle = new JoinLifecycle((JoinBridge)this.taskWideJoinBridge, probeFactoryCount, outerFactoryCount);
        }

        @Override
        public T getJoinBridge(Lifespan lifespan) {
            return this.taskWideJoinBridge;
        }

        @Override
        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan), (Object)"join bridge is not partitioned");
            return Futures.transform(this.joinLifecycle.whenBuildAndProbeFinishes(), ignored -> this.taskWideJoinBridge.getOuterPositionIterator(), (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public void probeOperatorFactoryClosedForAllLifespans() {
            this.joinLifecycle.releaseForProbe();
        }

        @Override
        public void probeOperatorFactoryClosed(Lifespan lifespan) {
        }

        @Override
        public void probeOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0, (Object)"build operator should not produce or destroy probes");
            this.joinLifecycle.retainForProbe();
        }

        @Override
        public void probeOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0, (Object)"build operator should not produce or destroy probes");
            this.joinLifecycle.releaseForProbe();
        }

        @Override
        public void outerOperatorFactoryClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan), (Object)"join bridge is not partitioned");
            this.joinLifecycle.releaseForOuter();
        }

        @Override
        public void outerOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan), (Object)"join bridge is not partitioned");
            this.joinLifecycle.retainForOuter();
        }

        @Override
        public void outerOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan), (Object)"join bridge is not partitioned");
            this.joinLifecycle.releaseForOuter();
        }
    }

    private static class OneToOneInternalJoinBridgeDataManager<T extends JoinBridge>
    implements InternalJoinBridgeDataManager<T> {
        private final Map<Lifespan, JoinBridgeAndLifecycle<T>> joinBridgeMap = new ConcurrentHashMap<Lifespan, JoinBridgeAndLifecycle<T>>();
        private final Function<Lifespan, T> joinBridgeProvider;
        private final int probeFactoryCount;
        private final int outerFactoryCount;

        public OneToOneInternalJoinBridgeDataManager(Function<Lifespan, T> joinBridgeProvider, int probeFactoryCount, int outerFactoryCount) {
            this.joinBridgeProvider = joinBridgeProvider;
            this.probeFactoryCount = probeFactoryCount;
            this.outerFactoryCount = outerFactoryCount;
        }

        @Override
        public T getJoinBridge(Lifespan lifespan) {
            return this.data((Lifespan)lifespan).joinBridge;
        }

        @Override
        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
            return Futures.transform(this.data((Lifespan)lifespan).joinLifecycle.whenBuildAndProbeFinishes(), ignored -> this.data((Lifespan)lifespan).joinBridge.getOuterPositionIterator(), (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public void probeOperatorFactoryClosedForAllLifespans() {
        }

        @Override
        public void probeOperatorFactoryClosed(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.releaseForProbe();
        }

        @Override
        public void probeOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.retainForProbe();
        }

        @Override
        public void probeOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.releaseForProbe();
        }

        @Override
        public void outerOperatorFactoryClosed(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.releaseForOuter();
        }

        @Override
        public void outerOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.retainForOuter();
        }

        @Override
        public void outerOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            this.data((Lifespan)lifespan).joinLifecycle.releaseForOuter();
        }

        private JoinBridgeAndLifecycle<T> data(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            return this.joinBridgeMap.computeIfAbsent(lifespan, span -> {
                JoinBridge joinBridge = (JoinBridge)this.joinBridgeProvider.apply((Lifespan)span);
                return new JoinBridgeAndLifecycle<JoinBridge>(joinBridge, new JoinLifecycle(joinBridge, this.probeFactoryCount, this.outerFactoryCount));
            });
        }

        private static class JoinBridgeAndLifecycle<T extends JoinBridge> {
            T joinBridge;
            JoinLifecycle joinLifecycle;

            public JoinBridgeAndLifecycle(T joinBridge, JoinLifecycle joinLifecycle) {
                this.joinBridge = joinBridge;
                this.joinLifecycle = joinLifecycle;
            }
        }
    }

    private static class TaskWideInternalJoinBridgeDataManager<T extends JoinBridge>
    implements InternalJoinBridgeDataManager<T> {
        private final T joinBridge;
        private final JoinLifecycle joinLifecycle;

        public TaskWideInternalJoinBridgeDataManager(Function<Lifespan, T> lookupSourceFactoryProvider, int probeFactoryCount, int outerFactoryCount) {
            this.joinBridge = (JoinBridge)lookupSourceFactoryProvider.apply(Lifespan.taskWide());
            this.joinLifecycle = new JoinLifecycle((JoinBridge)this.joinBridge, probeFactoryCount, outerFactoryCount);
        }

        @Override
        public T getJoinBridge(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            return this.joinBridge;
        }

        @Override
        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            return Futures.transform(this.joinLifecycle.whenBuildAndProbeFinishes(), ignored -> this.joinBridge.getOuterPositionIterator(), (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public void probeOperatorFactoryClosedForAllLifespans() {
        }

        @Override
        public void probeOperatorFactoryClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.releaseForProbe();
        }

        @Override
        public void probeOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.retainForProbe();
        }

        @Override
        public void probeOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.releaseForProbe();
        }

        @Override
        public void outerOperatorFactoryClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.releaseForOuter();
        }

        @Override
        public void outerOperatorCreated(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.retainForOuter();
        }

        @Override
        public void outerOperatorClosed(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            this.joinLifecycle.releaseForOuter();
        }
    }

    private static interface InternalJoinBridgeDataManager<T extends JoinBridge> {
        public T getJoinBridge(Lifespan var1);

        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan var1);

        public void probeOperatorFactoryClosedForAllLifespans();

        public void probeOperatorFactoryClosed(Lifespan var1);

        public void probeOperatorCreated(Lifespan var1);

        public void probeOperatorClosed(Lifespan var1);

        public void outerOperatorFactoryClosed(Lifespan var1);

        public void outerOperatorCreated(Lifespan var1);

        public void outerOperatorClosed(Lifespan var1);
    }
}

