/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureBase;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.FunctionResolver;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.TypeCoercer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class FunctionAndTypeManager
implements FunctionMetadataManager,
TypeManager {
    private final TransactionManager transactionManager;
    private final BuiltInTypeAndFunctionNamespaceManager builtInTypeAndFunctionNamespaceManager;
    private final FunctionInvokerProvider functionInvokerProvider;
    private final Map<String, FunctionNamespaceManagerFactory> functionNamespaceManagerFactories = new ConcurrentHashMap<String, FunctionNamespaceManagerFactory>();
    private final HandleResolver handleResolver;
    private final Map<String, FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManagers = new ConcurrentHashMap<String, FunctionNamespaceManager<? extends SqlFunction>>();
    private final FunctionResolver functionResolver;
    private final TypeCoercer typeCoercer;
    private final LoadingCache<FunctionResolutionCacheKey, FunctionHandle> functionCache;
    private final LoadingCache<TypeSignature, Type> parametricTypeCache;
    private final CacheStatsMBean cacheStatsMBean;

    @Inject
    public FunctionAndTypeManager(TransactionManager transactionManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig, HandleResolver handleResolver, Set<Type> types) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.builtInTypeAndFunctionNamespaceManager = new BuiltInTypeAndFunctionNamespaceManager(blockEncodingSerde, featuresConfig, types, this);
        this.functionNamespaceManagers.put(BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInTypeAndFunctionNamespaceManager);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        transactionManager.registerFunctionNamespaceManager(BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInTypeAndFunctionNamespaceManager);
        this.functionCache = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.resolveBuiltInFunction(((FunctionResolutionCacheKey)key).functionName, TypeSignatureProvider.fromTypeSignatures(((FunctionResolutionCacheKey)key).parameterTypes))));
        this.parametricTypeCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(typeSignature -> this.instantiateParametricType((TypeSignature)typeSignature, this.builtInTypeAndFunctionNamespaceManager)));
        this.cacheStatsMBean = new CacheStatsMBean(this.functionCache);
        this.functionResolver = new FunctionResolver(this);
        this.typeCoercer = new TypeCoercer(featuresConfig, this);
    }

    public static FunctionAndTypeManager createTestFunctionAndTypeManager() {
        return new FunctionAndTypeManager(InMemoryTransactionManager.createTestTransactionManager(), new BlockEncodingManager(new BlockEncoding[0]), new FeaturesConfig(), new HandleResolver(), (Set<Type>)ImmutableSet.of());
    }

    @Managed
    @Nested
    public CacheStatsMBean getFunctionResolutionCacheStats() {
        return this.cacheStatsMBean;
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        Objects.requireNonNull(functionNamespaceManagerName, "functionNamespaceManagerName is null");
        FunctionNamespaceManagerFactory factory = this.functionNamespaceManagerFactories.get(functionNamespaceManagerName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"No factory for function namespace manager %s", (Object)functionNamespaceManagerName);
        FunctionNamespaceManager functionNamespaceManager = factory.create(catalogName, properties);
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    @VisibleForTesting
    public void addFunctionNamespace(String catalogName, FunctionNamespaceManager functionNamespaceManager) {
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getCatalogSchemaName());
        return functionNamespaceManager.get().getFunctionMetadata(functionHandle);
    }

    public Type getType(TypeSignature signature) {
        if (signature.getTypeSignatureBase().isStandardType()) {
            Optional<Type> type = this.builtInTypeAndFunctionNamespaceManager.getType(signature);
            if (type.isPresent()) {
                return type.get();
            }
            try {
                return (Type)this.parametricTypeCache.getUnchecked((Object)signature);
            }
            catch (UncheckedExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(signature.getTypeSignatureBase());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for type '%s'", (Object)signature.getBase());
        return this.instantiateParametricType(signature, functionNamespaceManager.get());
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters));
    }

    public boolean canCoerce(Type actualType, Type expectedType) {
        return this.typeCoercer.canCoerce(actualType, expectedType);
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctionNamespaceFactory(FunctionNamespaceManagerFactory factory) {
        if (this.functionNamespaceManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
        this.handleResolver.addFunctionNamespace(factory.getName(), factory.getHandleResolver());
    }

    public void registerBuiltInFunctions(List<? extends SqlFunction> functions) {
        this.builtInTypeAndFunctionNamespaceManager.registerBuiltInFunctions(functions);
    }

    public List<SqlFunction> listFunctions(Session session) {
        Object managers = SystemSessionProperties.isListBuiltInFunctionsOnly(session) ? ImmutableSet.of((Object)this.builtInTypeAndFunctionNamespaceManager) : this.functionNamespaceManagers.values();
        return (List)managers.stream().flatMap(manager -> manager.listFunctions().stream()).filter(function -> function.getVisibility() == SqlFunctionVisibility.PUBLIC || function.getVisibility() == SqlFunctionVisibility.EXPERIMENTAL && SystemSessionProperties.isExperimentalFunctionsEnabled(session)).collect(ImmutableList.toImmutableList());
    }

    public Collection<? extends SqlFunction> getFunctions(Optional<TransactionId> transactionId, QualifiedObjectName functionName) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = transactionId.map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getCatalogName()));
        return functionNamespaceManager.get().getFunctions(transactionHandle, functionName);
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(function.getSignature().getName().getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot create function in function namespace: %s", function.getFunctionId().getFunctionName().getCatalogSchemaName()));
        }
        functionNamespaceManager.get().createFunction(function, replace);
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        functionNamespaceManager.get().alterFunction(functionName, parameterTypes, alterRoutineCharacteristics);
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName());
        if (functionNamespaceManager.isPresent()) {
            functionNamespaceManager.get().dropFunction(functionName, parameterTypes, exists);
        } else if (!exists) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName.getCatalogSchemaName()));
        }
    }

    public static QualifiedObjectName qualifyObjectName(QualifiedName name) {
        if (!name.getPrefix().isPresent()) {
            return QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name.getSuffix());
        }
        if (name.getOriginalParts().size() != 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Non-builtin functions must be referenced by 'catalog.schema.function_name', found: %s", name));
        }
        return QualifiedObjectName.valueOf((String)((String)name.getOriginalParts().get(0)), (String)((String)name.getOriginalParts().get(1)), (String)((String)name.getOriginalParts().get(2)));
    }

    public FunctionHandle resolveFunction(Optional<TransactionId> transactionId, QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        if (functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE) && parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
            return this.lookupCachedFunction(functionName, parameterTypes);
        }
        return this.resolveFunctionInternal(transactionId, functionName, parameterTypes);
    }

    public void addType(Type type) {
        TypeSignatureBase typeSignatureBase = type.getTypeSignature().getTypeSignatureBase();
        Preconditions.checkArgument((boolean)typeSignatureBase.isStandardType(), (Object)"Expect standard types");
        this.builtInTypeAndFunctionNamespaceManager.addType(type);
    }

    public void addParametricType(ParametricType parametricType) {
        TypeSignatureBase typeSignatureBase = parametricType.getTypeSignatureBase();
        if (typeSignatureBase.isStandardType()) {
            this.builtInTypeAndFunctionNamespaceManager.addParametricType(parametricType);
        } else {
            Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(typeSignatureBase);
            Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for parametric type %", (Object)parametricType);
            functionNamespaceManager.get().addParametricType(parametricType);
        }
    }

    public List<Type> getTypes() {
        return this.builtInTypeAndFunctionNamespaceManager.getTypes();
    }

    public Collection<ParametricType> getParametricTypes() {
        return this.builtInTypeAndFunctionNamespaceManager.getParametricTypes();
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        return this.typeCoercer.getCommonSuperType(firstType, secondType);
    }

    public boolean isTypeOnlyCoercion(Type actualType, Type expectedType) {
        return this.typeCoercer.isTypeOnlyCoercion(actualType, expectedType);
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        return this.typeCoercer.coerceTypeBase(sourceType, resultTypeBase);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getCatalogSchemaName());
        return functionNamespaceManager.get().getScalarFunctionImplementation(functionHandle);
    }

    public CompletableFuture<Block> executeFunction(FunctionHandle functionHandle, Page inputPage, List<Integer> channels) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getCatalogSchemaName());
        Preconditions.checkState((boolean)functionNamespaceManager.isPresent(), (Object)String.format("FunctionHandle %s should have a serving function namespace", functionHandle));
        return functionNamespaceManager.get().executeFunction(functionHandle, inputPage, channels, (TypeManager)this);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInTypeAndFunctionNamespaceManager.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInTypeAndFunctionNamespaceManager.getAggregateFunctionImplementation(functionHandle);
    }

    public BuiltInScalarFunctionImplementation getBuiltInScalarFunctionImplementation(FunctionHandle functionHandle) {
        return (BuiltInScalarFunctionImplementation)this.builtInTypeAndFunctionNamespaceManager.getScalarFunctionImplementation(functionHandle);
    }

    @VisibleForTesting
    public List<SqlFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(OperatorType::getFunctionName).collect(ImmutableSet.toImmutableSet());
        return (List)this.builtInTypeAndFunctionNamespaceManager.listFunctions().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        try {
            return this.resolveFunction(Optional.empty(), operatorType.getFunctionName(), argumentTypes);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List)argumentTypes.stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList()));
            }
            throw e;
        }
    }

    public FunctionHandle lookupFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        QualifiedObjectName functionName = FunctionAndTypeManager.qualifyObjectName(QualifiedName.of((String)name));
        if (parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
            return this.lookupCachedFunction(functionName, parameterTypes);
        }
        Collection<SqlFunction> candidates = this.builtInTypeAndFunctionNamespaceManager.getFunctions(Optional.empty(), functionName);
        return this.functionResolver.lookupFunction(this.builtInTypeAndFunctionNamespaceManager, Optional.empty(), functionName, parameterTypes, candidates);
    }

    public FunctionHandle lookupCast(CastType castType, TypeSignature fromType, TypeSignature toType) {
        Signature signature = new Signature(castType.getCastName(), FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), toType, Collections.singletonList(fromType), false);
        try {
            this.builtInTypeAndFunctionNamespaceManager.getScalarFunctionImplementation(signature);
        }
        catch (PrestoException e) {
            if (castType.isOperatorType() && e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(CastType.toOperatorType(castType), (List<TypeSignature>)ImmutableList.of((Object)fromType), toType);
            }
            throw e;
        }
        return this.builtInTypeAndFunctionNamespaceManager.getFunctionHandle(Optional.empty(), signature);
    }

    private FunctionHandle resolveFunctionInternal(Optional<TransactionId> transactionId, QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        FunctionNamespaceManager functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getCatalogSchemaName()).orElse(null);
        if (functionNamespaceManager == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, FunctionResolver.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, (Collection<? extends SqlFunction>)ImmutableList.of()));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = transactionId.map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getCatalogName()));
        Collection candidates = functionNamespaceManager.getFunctions(transactionHandle, functionName);
        return this.functionResolver.resolveFunction(functionNamespaceManager, transactionHandle, functionName, parameterTypes, candidates);
    }

    private FunctionHandle resolveBuiltInFunction(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        Preconditions.checkArgument((boolean)functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE), (Object)"Expect built-in functions");
        Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Expect parameter types not to have dependency");
        return this.resolveFunctionInternal(Optional.empty(), functionName, parameterTypes);
    }

    private FunctionHandle lookupCachedFunction(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
        try {
            return (FunctionHandle)this.functionCache.getUnchecked((Object)new FunctionResolutionCacheKey(functionName, parameterTypes));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof PrestoException) {
                throw (PrestoException)e.getCause();
            }
            throw e;
        }
    }

    private Optional<FunctionNamespaceManager<? extends SqlFunction>> getServingFunctionNamespaceManager(CatalogSchemaName functionNamespace) {
        return Optional.ofNullable(this.functionNamespaceManagers.get(functionNamespace.getCatalogName()));
    }

    private Optional<FunctionNamespaceManager<? extends SqlFunction>> getServingFunctionNamespaceManager(TypeSignatureBase typeSignatureBase) {
        return Optional.ofNullable(this.functionNamespaceManagers.get(typeSignatureBase.getQualifiedObjectName().getCatalogName()));
    }

    private Type instantiateParametricType(TypeSignature signature, FunctionNamespaceManager<?> functionNamespaceManager) {
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)this);
            parameters.add(typeParameter);
        }
        Optional type = functionNamespaceManager.getParametricType(signature);
        if (!type.isPresent()) {
            throw new IllegalArgumentException("Unknown type " + signature);
        }
        ParametricType parametricType = (ParametricType)type.get();
        if (parametricType instanceof MapParametricType) {
            return ((MapParametricType)parametricType).createType(this, parameters);
        }
        Type instantiatedType = parametricType.createType(parameters);
        return instantiatedType;
    }

    private static class FunctionResolutionCacheKey {
        private final QualifiedObjectName functionName;
        private final List<TypeSignature> parameterTypes;

        private FunctionResolutionCacheKey(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes) {
            Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Only type signatures without dependency can be cached");
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.parameterTypes = (List)Objects.requireNonNull(parameterTypes, "parameterTypes is null").stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList());
        }

        public int hashCode() {
            return Objects.hash(this.functionName, this.parameterTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionResolutionCacheKey other = (FunctionResolutionCacheKey)obj;
            return Objects.equals(this.functionName, other.functionName) && Objects.equals(this.parameterTypes, other.parameterTypes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameterTypes", this.parameterTypes).toString();
        }
    }
}

