/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

@ThriftStruct
public class ThriftSerializedPage {
    private final Slice slice;
    private final int positionCount;
    private final int uncompressedSizeInBytes;
    private final byte pageCodecMarkers;

    public ThriftSerializedPage(SerializedPage serializedPage) {
        this(serializedPage.getSlice(), serializedPage.getPageCodecMarkers(), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes());
    }

    private ThriftSerializedPage(Slice slice, byte pageCodecMarkers, int positionCount, int uncompressedSizeInBytes) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.positionCount = positionCount;
        Preconditions.checkArgument((uncompressedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"uncompressedSizeInBytes is negative");
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        this.pageCodecMarkers = pageCodecMarkers;
        if (!PageCodecMarker.ENCRYPTED.isSet(pageCodecMarkers)) {
            if (PageCodecMarker.COMPRESSED.isSet(pageCodecMarkers)) {
                Preconditions.checkArgument((uncompressedSizeInBytes > slice.length() ? 1 : 0) != 0, (Object)"compressed size must be smaller than uncompressed size when compressed");
            } else {
                Preconditions.checkArgument((uncompressedSizeInBytes == slice.length() ? 1 : 0) != 0, (Object)"uncompressed size must be equal to slice length when uncompressed");
            }
        }
    }

    @ThriftConstructor
    public ThriftSerializedPage(byte[] data, byte pageCodecMarkers, int positionCount, int uncompressedSizeInBytes) {
        this(Slices.wrappedBuffer((byte[])data), pageCodecMarkers, positionCount, uncompressedSizeInBytes);
    }

    @ThriftField(value=1)
    public byte[] getData() {
        if (this.slice.isCompact()) {
            Object base = this.slice.getBase();
            Preconditions.checkState((boolean)(base instanceof byte[]), (String)"unexpected serialization type %s", base.getClass());
            return (byte[])base;
        }
        return this.slice.getBytes();
    }

    @ThriftField(value=2)
    public byte getPageCodecMarkers() {
        return this.pageCodecMarkers;
    }

    @ThriftField(value=3)
    public int getPositionCount() {
        return this.positionCount;
    }

    @ThriftField(value=4)
    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public SerializedPage toSerializedPage() {
        return new SerializedPage(this.slice, this.pageCodecMarkers, this.positionCount, this.uncompressedSizeInBytes);
    }
}

