/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SerializedPageReference {
    private final SerializedPage serializedPage;
    private final AtomicInteger referenceCount;
    private final Runnable onDereference;

    public SerializedPageReference(SerializedPage serializedPage, int referenceCount, Runnable onDereference) {
        this.serializedPage = Objects.requireNonNull(serializedPage, "page is null");
        Preconditions.checkArgument((referenceCount > 0 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
        this.referenceCount = new AtomicInteger(referenceCount);
        this.onDereference = Objects.requireNonNull(onDereference, "onDereference is null");
    }

    public void addReference() {
        int oldReferences = this.referenceCount.getAndIncrement();
        Preconditions.checkState((oldReferences > 0 ? 1 : 0) != 0, (Object)"Page has already been dereferenced");
    }

    public SerializedPage getSerializedPage() {
        return this.serializedPage;
    }

    public int getPositionCount() {
        return this.serializedPage.getPositionCount();
    }

    public long getRetainedSizeInBytes() {
        return this.serializedPage.getRetainedSizeInBytes();
    }

    public void dereferencePage() {
        int remainingReferences = this.referenceCount.decrementAndGet();
        Preconditions.checkState((remainingReferences >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
        if (remainingReferences == 0) {
            this.onDereference.run();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("referenceCount", (Object)this.referenceCount).toString();
    }
}

