/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskManagementExecutor;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.VoidTraversingQueryContextVisitor;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class TaskThresholdMemoryRevokingScheduler {
    private static final Logger log = Logger.get(TaskThresholdMemoryRevokingScheduler.class);
    private final Supplier<List<SqlTask>> currentTasksSupplier;
    private final ScheduledExecutorService taskManagementExecutor;
    private final long maxRevocableMemoryPerTask;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    private final AtomicBoolean checkPending = new AtomicBoolean();

    @Inject
    public TaskThresholdMemoryRevokingScheduler(SqlTaskManager sqlTaskManager, TaskManagementExecutor taskManagementExecutor, FeaturesConfig config) {
        this(Objects.requireNonNull(sqlTaskManager, "sqlTaskManager cannot be null")::getAllTasks, Objects.requireNonNull(taskManagementExecutor, "taskManagementExecutor cannot be null").getExecutor(), Objects.requireNonNull(config.getMaxRevocableMemoryPerTask(), "maxRevocableMemoryPerTask cannot be null").toBytes());
        log.debug("Using TaskThresholdMemoryRevokingScheduler spilling strategy");
    }

    @VisibleForTesting
    TaskThresholdMemoryRevokingScheduler(Supplier<List<SqlTask>> currentTasksSupplier, ScheduledExecutorService taskManagementExecutor, long maxRevocableMemoryPerTask) {
        this.currentTasksSupplier = Objects.requireNonNull(currentTasksSupplier, "currentTasksSupplier is null");
        this.taskManagementExecutor = Objects.requireNonNull(taskManagementExecutor, "taskManagementExecutor is null");
        this.maxRevocableMemoryPerTask = maxRevocableMemoryPerTask;
    }

    @PostConstruct
    public void start() {
        this.registerTaskMemoryPeriodicCheck();
    }

    private void registerTaskMemoryPeriodicCheck() {
        this.scheduledFuture = this.taskManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.revokeHighMemoryTasksIfNeeded();
            }
            catch (Throwable e) {
                log.error(e, "Error requesting task memory revoking");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    @VisibleForTesting
    void revokeHighMemoryTasksIfNeeded() {
        if (this.checkPending.compareAndSet(false, true)) {
            this.revokeHighMemoryTasks();
        }
    }

    private synchronized void revokeHighMemoryTasks() {
        if (this.checkPending.getAndSet(false)) {
            Collection sqlTasks = Objects.requireNonNull(this.currentTasksSupplier.get());
            for (final SqlTask task : sqlTasks) {
                long currentTaskRevocableMemory = task.getTaskInfo().getStats().getRevocableMemoryReservationInBytes();
                if (currentTaskRevocableMemory < this.maxRevocableMemoryPerTask) continue;
                AtomicLong remainingBytesToRevokeAtomic = new AtomicLong(currentTaskRevocableMemory - this.maxRevocableMemoryPerTask);
                task.getQueryContext().accept(new VoidTraversingQueryContextVisitor<AtomicLong>(){

                    @Override
                    public Void visitQueryContext(QueryContext queryContext, AtomicLong remainingBytesToRevoke) {
                        if (remainingBytesToRevoke.get() < 0L) {
                            return null;
                        }
                        return (Void)super.visitQueryContext(queryContext, remainingBytesToRevoke);
                    }

                    @Override
                    public Void visitOperatorContext(OperatorContext operatorContext, AtomicLong remainingBytesToRevoke) {
                        long revokedBytes;
                        if (remainingBytesToRevoke.get() > 0L && (revokedBytes = operatorContext.requestMemoryRevoking()) > 0L) {
                            remainingBytesToRevoke.addAndGet(-revokedBytes);
                            log.debug("taskId=%s: requested revoking %s; remaining %s", new Object[]{task.getTaskInfo().getTaskId(), revokedBytes, remainingBytesToRevoke.get()});
                        }
                        return null;
                    }
                }, remainingBytesToRevokeAtomic);
            }
        }
    }
}

