/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.event.SplitMonitor;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.planner.HttpRemoteSourceFactory;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final BlockEncodingSerde blockEncodingSerde;
    private final OrderingCompiler orderingCompiler;
    private final SplitMonitor splitMonitor;
    private final FragmentResultCacheManager fragmentResultCacheManager;
    private final ObjectMapper objectMapper;
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;
    private final boolean perOperatorAllocationTrackingEnabled;
    private final boolean allocationTrackingEnabled;
    private final boolean legacyLifespanCompletionCondition;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, BlockEncodingSerde blockEncodingSerde, OrderingCompiler orderingCompiler, SplitMonitor splitMonitor, FragmentResultCacheManager fragmentResultCacheManager, ObjectMapper objectMapper, TaskManagerConfig config) {
        this.taskNotificationExecutor = Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.planner = Objects.requireNonNull(planner, "planner is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        this.fragmentResultCacheManager = Objects.requireNonNull(fragmentResultCacheManager, "fragmentResultCacheManager is null");
        this.objectMapper = objectMapper.copy().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        Objects.requireNonNull(config, "config is null");
        this.perOperatorCpuTimerEnabled = config.isPerOperatorCpuTimerEnabled();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
        this.perOperatorAllocationTrackingEnabled = config.isPerOperatorAllocationTrackingEnabled();
        this.allocationTrackingEnabled = config.isTaskAllocationTrackingEnabled();
        this.legacyLifespanCompletionCondition = config.isLegacyLifespanCompletionCondition();
    }

    public SqlTaskExecution create(Session session, QueryContext queryContext, TaskStateMachine taskStateMachine, OutputBuffer outputBuffer, TaskExchangeClientManager taskExchangeClientManager, PlanFragment fragment, List<TaskSource> sources, TableWriteInfo tableWriteInfo) {
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, session, this.perOperatorCpuTimerEnabled, this.cpuTimerEnabled, this.perOperatorAllocationTrackingEnabled, this.allocationTrackingEnabled, this.legacyLifespanCompletionCondition, FragmentResultCacheContext.createFragmentResultCacheContext(this.fragmentResultCacheManager, fragment.getRoot(), fragment.getPartitioningScheme(), session, this.objectMapper));
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskStateMachine.getTaskId()});){
            try {
                localExecutionPlan = this.planner.plan(taskContext, fragment.getRoot(), fragment.getPartitioningScheme(), fragment.getStageExecutionDescriptor(), fragment.getTableScanSchedulingOrder(), outputBuffer, new HttpRemoteSourceFactory(this.blockEncodingSerde, taskExchangeClientManager, this.orderingCompiler), tableWriteInfo);
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, outputBuffer, sources, localExecutionPlan, this.taskExecutor, this.taskNotificationExecutor, this.splitMonitor);
    }
}

