/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public interface DataDefinitionTask<T extends Statement> {
    public String getName();

    public ListenableFuture<?> execute(T var1, TransactionManager var2, Metadata var3, AccessControl var4, QueryStateMachine var5, List<Expression> var6);

    default public String explain(T statement, List<Expression> parameters) {
        if (statement instanceof Prepare) {
            return SqlFormatter.formatSql(statement, Optional.empty());
        }
        return SqlFormatter.formatSql(statement, Optional.of(parameters));
    }

    default public boolean isTransactionControl() {
        return false;
    }
}

