/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.DispatchQueryFactory;
import com.facebook.presto.dispatcher.FailedDispatchQuery;
import com.facebook.presto.dispatcher.FailedDispatchQueryFactory;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryManagerStats;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.QueryTracker;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.StatementUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class DispatchManager {
    private final QueryIdGenerator queryIdGenerator;
    private final QueryPreparer queryPreparer;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final WarningCollectorFactory warningCollectorFactory;
    private final DispatchQueryFactory dispatchQueryFactory;
    private final FailedDispatchQueryFactory failedDispatchQueryFactory;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionSupplier sessionSupplier;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final int maxQueryLength;
    private final Executor queryExecutor;
    private final BoundedExecutor boundedQueryExecutor;
    private final QueryTracker<DispatchQuery> queryTracker;
    private final QueryManagerStats stats = new QueryManagerStats();

    @Inject
    public DispatchManager(QueryIdGenerator queryIdGenerator, QueryPreparer queryPreparer, ResourceGroupManager resourceGroupManager, WarningCollectorFactory warningCollectorFactory, DispatchQueryFactory dispatchQueryFactory, FailedDispatchQueryFactory failedDispatchQueryFactory, TransactionManager transactionManager, AccessControl accessControl, SessionSupplier sessionSupplier, SessionPropertyDefaults sessionPropertyDefaults, QueryManagerConfig queryManagerConfig, DispatchExecutor dispatchExecutor) {
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.warningCollectorFactory = Objects.requireNonNull(warningCollectorFactory, "warningCollectorFactory is null");
        this.dispatchQueryFactory = Objects.requireNonNull(dispatchQueryFactory, "dispatchQueryFactory is null");
        this.failedDispatchQueryFactory = Objects.requireNonNull(failedDispatchQueryFactory, "failedDispatchQueryFactory is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.maxQueryLength = queryManagerConfig.getMaxQueryLength();
        this.queryExecutor = Objects.requireNonNull(dispatchExecutor, "dispatchExecutor is null").getExecutor();
        this.boundedQueryExecutor = Objects.requireNonNull(dispatchExecutor, "dispatchExecutor is null").getBoundedExecutor();
        this.queryTracker = new QueryTracker(queryManagerConfig, (ScheduledExecutorService)dispatchExecutor.getScheduledExecutor());
    }

    @PostConstruct
    public void start() {
        this.queryTracker.start();
    }

    @PreDestroy
    public void stop() {
        this.queryTracker.stop();
    }

    @Managed
    @Flatten
    public QueryManagerStats getStats() {
        return this.stats;
    }

    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    public ListenableFuture<?> createQuery(QueryId queryId, String slug, SessionContext sessionContext, String query) {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(sessionContext, "sessionFactory is null");
        Objects.requireNonNull(query, "query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        Preconditions.checkArgument((!this.queryTracker.tryGetQuery(queryId).isPresent() ? 1 : 0) != 0, (String)"query %s already exists", (Object)queryId);
        DispatchQueryCreationFuture queryCreationFuture = new DispatchQueryCreationFuture();
        this.boundedQueryExecutor.execute(() -> {
            try {
                this.createQueryInternal(queryId, slug, sessionContext, query, this.resourceGroupManager);
            }
            finally {
                queryCreationFuture.set(null);
            }
        });
        return queryCreationFuture;
    }

    private <C> void createQueryInternal(QueryId queryId, String slug, SessionContext sessionContext, String query, ResourceGroupManager<C> resourceGroupManager) {
        Session session = null;
        try {
            if (query.length() > this.maxQueryLength) {
                int queryLength = query.length();
                query = query.substring(0, this.maxQueryLength);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_TEXT_TOO_LARGE, String.format("Query text length (%s) exceeds the maximum length (%s)", queryLength, this.maxQueryLength));
            }
            session = this.sessionSupplier.createSession(queryId, sessionContext);
            WarningCollector warningCollector = this.warningCollectorFactory.create(SystemSessionProperties.getWarningHandlingLevel(session));
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(session, query, warningCollector);
            Optional<QueryType> queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass());
            SelectionContext<C> selectionContext = resourceGroupManager.selectGroup(new SelectionCriteria(sessionContext.getIdentity().getPrincipal().isPresent(), sessionContext.getIdentity().getUser(), Optional.ofNullable(sessionContext.getSource()), sessionContext.getClientTags(), sessionContext.getResourceEstimates(), queryType.map(Enum::name)));
            session = this.sessionPropertyDefaults.newSessionWithDefaultProperties(session, queryType.map(Enum::name), Optional.of(selectionContext.getResourceGroupId()));
            this.transactionManager.activateTransaction(session, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.accessControl);
            DispatchQuery dispatchQuery = this.dispatchQueryFactory.createDispatchQuery(session, query, preparedQuery, slug, selectionContext.getResourceGroupId(), queryType, warningCollector);
            boolean queryAdded = this.queryCreated(dispatchQuery);
            if (queryAdded && !dispatchQuery.isDone()) {
                try {
                    resourceGroupManager.submit(preparedQuery.getStatement(), dispatchQuery, selectionContext, this.queryExecutor);
                }
                catch (Throwable e) {
                    dispatchQuery.fail(e);
                }
            }
        }
        catch (Throwable throwable) {
            if (session == null) {
                session = Session.builder(new SessionPropertyManager()).setQueryId(queryId).setIdentity(sessionContext.getIdentity()).setSource(sessionContext.getSource()).build();
            }
            FailedDispatchQuery failedDispatchQuery = this.failedDispatchQueryFactory.createFailedDispatchQuery(session, query, Optional.empty(), throwable);
            this.queryCreated(failedDispatchQuery);
        }
    }

    private boolean queryCreated(DispatchQuery dispatchQuery) {
        boolean queryAdded = this.queryTracker.addQuery(dispatchQuery);
        if (queryAdded) {
            dispatchQuery.addStateChangeListener(newState -> {
                if (newState.isDone()) {
                    this.queryTracker.expireQuery(dispatchQuery.getQueryId());
                }
            });
            this.stats.trackQueryStats(dispatchQuery);
        }
        return queryAdded;
    }

    public ListenableFuture<?> waitForDispatched(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).map(dispatchQuery -> {
            dispatchQuery.recordHeartbeat();
            return dispatchQuery.getDispatchedFuture();
        }).orElseGet(() -> Futures.immediateFuture(null));
    }

    public List<BasicQueryInfo> getQueries() {
        return (List)this.queryTracker.getAllQueries().stream().map(ManagedQueryExecution::getBasicQueryInfo).collect(ImmutableList.toImmutableList());
    }

    public BasicQueryInfo getQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getBasicQueryInfo();
    }

    public Optional<DispatchInfo> getDispatchInfo(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).map(dispatchQuery -> {
            dispatchQuery.recordHeartbeat();
            return dispatchQuery.getDispatchInfo();
        });
    }

    public boolean isQueryPresent(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).isPresent();
    }

    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.queryTracker.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    public void cancelQuery(QueryId queryId) {
        this.queryTracker.tryGetQuery(queryId).ifPresent(DispatchQuery::cancel);
    }

    private static class DispatchQueryCreationFuture
    extends AbstractFuture<QueryInfo> {
        private DispatchQueryCreationFuture() {
        }

        protected boolean set(QueryInfo value) {
            return super.set((Object)value);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

