/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.ComparisonStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpVariableResolver;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class FilterStatsCalculator {
    static final double UNKNOWN_FILTER_COEFFICIENT = 0.9;
    private final Metadata metadata;
    private final ScalarStatsCalculator scalarStatsCalculator;
    private final StatsNormalizer normalizer;
    private final LiteralEncoder literalEncoder;
    private final FunctionResolution functionResolution;

    @Inject
    public FilterStatsCalculator(Metadata metadata, ScalarStatsCalculator scalarStatsCalculator, StatsNormalizer normalizer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.scalarStatsCalculator = Objects.requireNonNull(scalarStatsCalculator, "scalarStatsCalculator is null");
        this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        this.functionResolution = new FunctionResolution(metadata.getFunctionAndTypeManager());
    }

    @Deprecated
    public PlanNodeStatsEstimate filterStats(PlanNodeStatsEstimate statsEstimate, Expression predicate, Session session, TypeProvider types) {
        Expression simplifiedExpression = this.simplifyExpression(session, predicate, types);
        return (PlanNodeStatsEstimate)new FilterExpressionStatsCalculatingVisitor(statsEstimate, session, types).process((Node)simplifiedExpression);
    }

    public PlanNodeStatsEstimate filterStats(PlanNodeStatsEstimate statsEstimate, RowExpression predicate, ConnectorSession session) {
        RowExpression simplifiedExpression = this.simplifyExpression(session, predicate);
        return new FilterRowExpressionStatsCalculatingVisitor(statsEstimate, session, this.metadata.getFunctionAndTypeManager()).process(simplifiedExpression);
    }

    public PlanNodeStatsEstimate filterStats(PlanNodeStatsEstimate statsEstimate, RowExpression predicate, Session session) {
        return this.filterStats(statsEstimate, predicate, session.toConnectorSession());
    }

    private Expression simplifyExpression(Session session, Expression predicate, TypeProvider types) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(session, predicate, types);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer(predicate, this.metadata, session, expressionTypes);
        Object value = interpreter.optimize(NoOpVariableResolver.INSTANCE);
        if (value == null) {
            value = false;
        }
        return this.literalEncoder.toExpression(value, (Type)BooleanType.BOOLEAN);
    }

    private RowExpression simplifyExpression(ConnectorSession session, RowExpression predicate) {
        RowExpressionInterpreter interpreter = new RowExpressionInterpreter(predicate, this.metadata, session, ExpressionOptimizer.Level.OPTIMIZED);
        Object value = interpreter.optimize();
        if (value == null) {
            value = false;
        }
        return LiteralEncoder.toRowExpression(value, (Type)BooleanType.BOOLEAN);
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Session session, Expression expression, TypeProvider types) {
        ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries(this.metadata.getFunctionAndTypeManager(), session, types, Collections.emptyList(), node -> new IllegalStateException("Unexpected node: %s" + node), WarningCollector.NOOP, false);
        expressionAnalyzer.analyze(expression, Scope.create());
        return expressionAnalyzer.getExpressionTypes();
    }

    private class FilterRowExpressionStatsCalculatingVisitor
    implements RowExpressionVisitor<PlanNodeStatsEstimate, Void> {
        private final PlanNodeStatsEstimate input;
        private final ConnectorSession session;
        private final FunctionAndTypeManager functionAndTypeManager;

        FilterRowExpressionStatsCalculatingVisitor(PlanNodeStatsEstimate input, ConnectorSession session, FunctionAndTypeManager functionAndTypeManager) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        }

        public PlanNodeStatsEstimate visitSpecialForm(SpecialFormExpression node, Void context) {
            switch (node.getForm()) {
                case AND: {
                    return this.estimateLogicalAnd((RowExpression)node.getArguments().get(0), (RowExpression)node.getArguments().get(1));
                }
                case OR: {
                    return this.estimateLogicalOr((RowExpression)node.getArguments().get(0), (RowExpression)node.getArguments().get(1));
                }
                case IN: {
                    return this.estimateIn((RowExpression)node.getArguments().get(0), node.getArguments().subList(1, node.getArguments().size()));
                }
                case IS_NULL: {
                    return this.estimateIsNull((RowExpression)node.getArguments().get(0));
                }
            }
            return PlanNodeStatsEstimate.unknown();
        }

        public PlanNodeStatsEstimate visitConstant(ConstantExpression node, Void context) {
            if (node.getType().equals(BooleanType.BOOLEAN)) {
                if (node.getValue() != null && ((Boolean)node.getValue()).booleanValue()) {
                    return this.input;
                }
                PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
                result.setOutputRowCount(0.0);
                this.input.getVariablesWithKnownStatistics().forEach(variable -> result.addVariableStatistics((VariableReferenceExpression)variable, VariableStatsEstimate.zero()));
                return result.build();
            }
            return PlanNodeStatsEstimate.unknown();
        }

        public PlanNodeStatsEstimate visitLambda(LambdaDefinitionExpression node, Void context) {
            return PlanNodeStatsEstimate.unknown();
        }

        public PlanNodeStatsEstimate visitVariableReference(VariableReferenceExpression node, Void context) {
            return PlanNodeStatsEstimate.unknown();
        }

        public PlanNodeStatsEstimate visitCall(CallExpression node, Void context) {
            FunctionMetadata functionMetadata = FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().getFunctionMetadata(node.getFunctionHandle());
            if (functionMetadata.getOperatorType().map(OperatorType::isComparisonOperator).orElse(false).booleanValue()) {
                Optional<VariableReferenceExpression> leftVariable;
                OperatorType operatorType = (OperatorType)functionMetadata.getOperatorType().get();
                RowExpression left = (RowExpression)node.getArguments().get(0);
                RowExpression right = (RowExpression)node.getArguments().get(1);
                Preconditions.checkArgument((!(left instanceof ConstantExpression) || !(right instanceof ConstantExpression) ? 1 : 0) != 0, (Object)"Literal-to-literal not supported here, should be eliminated earlier");
                if (!(left instanceof VariableReferenceExpression) && right instanceof VariableReferenceExpression) {
                    OperatorType flippedOperator = this.flip(operatorType);
                    return this.process((RowExpression)Expressions.call(flippedOperator.name(), FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().resolveOperator(flippedOperator, TypeSignatureProvider.fromTypes(right.getType(), left.getType())), (Type)BooleanType.BOOLEAN, right, left));
                }
                if (left instanceof ConstantExpression) {
                    OperatorType flippedOperator = this.flip(operatorType);
                    return this.process((RowExpression)Expressions.call(flippedOperator.name(), FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().resolveOperator(flippedOperator, TypeSignatureProvider.fromTypes(right.getType(), left.getType())), (Type)BooleanType.BOOLEAN, right, left));
                }
                if (left instanceof VariableReferenceExpression && left.equals((Object)right)) {
                    return this.process(this.not(this.isNull(left)));
                }
                VariableStatsEstimate leftStats = this.getRowExpressionStats(left);
                Optional<VariableReferenceExpression> optional = leftVariable = left instanceof VariableReferenceExpression ? Optional.of((VariableReferenceExpression)left) : Optional.empty();
                if (right instanceof ConstantExpression) {
                    Object rightValue = ((ConstantExpression)right).getValue();
                    if (rightValue == null) {
                        return this.visitConstant(Expressions.constantNull((Type)BooleanType.BOOLEAN), null);
                    }
                    OptionalDouble literal = StatsUtil.toStatsRepresentation(FilterStatsCalculator.this.metadata.getFunctionAndTypeManager(), this.session, right.getType(), rightValue);
                    return ComparisonStatsCalculator.estimateExpressionToLiteralComparison(this.input, leftStats, leftVariable, literal, this.getComparisonOperator(operatorType));
                }
                VariableStatsEstimate rightStats = this.getRowExpressionStats(right);
                if (rightStats.isSingleValue()) {
                    OptionalDouble value = Double.isNaN(rightStats.getLowValue()) ? OptionalDouble.empty() : OptionalDouble.of(rightStats.getLowValue());
                    return ComparisonStatsCalculator.estimateExpressionToLiteralComparison(this.input, leftStats, leftVariable, value, this.getComparisonOperator(operatorType));
                }
                Optional<VariableReferenceExpression> rightVariable = right instanceof VariableReferenceExpression ? Optional.of((VariableReferenceExpression)right) : Optional.empty();
                return ComparisonStatsCalculator.estimateExpressionToExpressionComparison(this.input, leftStats, leftVariable, rightStats, rightVariable, this.getComparisonOperator(operatorType));
            }
            if (node.getFunctionHandle().equals(FilterStatsCalculator.this.functionResolution.notFunction())) {
                RowExpression arguemnt = (RowExpression)node.getArguments().get(0);
                if (arguemnt instanceof SpecialFormExpression && ((SpecialFormExpression)arguemnt).getForm().equals((Object)SpecialFormExpression.Form.IS_NULL)) {
                    RowExpression innerArugment = (RowExpression)((SpecialFormExpression)arguemnt).getArguments().get(0);
                    if (innerArugment instanceof VariableReferenceExpression) {
                        VariableReferenceExpression variable = (VariableReferenceExpression)innerArugment;
                        VariableStatsEstimate variableStats = this.input.getVariableStatistics(variable);
                        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
                        result.setOutputRowCount(this.input.getOutputRowCount() * (1.0 - variableStats.getNullsFraction()));
                        result.addVariableStatistics(variable, variableStats.mapNullsFraction(x -> 0.0));
                        return result.build();
                    }
                    return PlanNodeStatsEstimate.unknown();
                }
                return PlanNodeStatsEstimateMath.subtractSubsetStats(this.input, this.process(arguemnt));
            }
            if (FilterStatsCalculator.this.functionResolution.isBetweenFunction(node.getFunctionHandle())) {
                RowExpression value = (RowExpression)node.getArguments().get(0);
                RowExpression min = (RowExpression)node.getArguments().get(1);
                RowExpression max = (RowExpression)node.getArguments().get(2);
                if (!(value instanceof VariableReferenceExpression)) {
                    return PlanNodeStatsEstimate.unknown();
                }
                if (!this.getRowExpressionStats(min).isSingleValue()) {
                    return PlanNodeStatsEstimate.unknown();
                }
                if (!this.getRowExpressionStats(max).isSingleValue()) {
                    return PlanNodeStatsEstimate.unknown();
                }
                VariableStatsEstimate valueStats = this.input.getVariableStatistics((VariableReferenceExpression)value);
                CallExpression lowerBound = Expressions.call(OperatorType.GREATER_THAN_OR_EQUAL.name(), FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes(value.getType(), min.getType())), (Type)BooleanType.BOOLEAN, value, min);
                CallExpression upperBound = Expressions.call(OperatorType.LESS_THAN_OR_EQUAL.name(), FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes(value.getType(), max.getType())), (Type)BooleanType.BOOLEAN, value, max);
                RowExpression transformed = Double.isInfinite(valueStats.getLowValue()) ? LogicalRowExpressions.and((RowExpression[])new RowExpression[]{lowerBound, upperBound}) : LogicalRowExpressions.and((RowExpression[])new RowExpression[]{upperBound, lowerBound});
                return this.process(transformed);
            }
            if (DynamicFilters.isDynamicFilter((RowExpression)node)) {
                return this.process((RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            }
            return PlanNodeStatsEstimate.unknown();
        }

        public PlanNodeStatsEstimate visitInputReference(InputReferenceExpression node, Void context) {
            throw new UnsupportedOperationException("plan node stats estimation should not reach channel mapping");
        }

        private FilterRowExpressionStatsCalculatingVisitor newEstimate(PlanNodeStatsEstimate input) {
            return new FilterRowExpressionStatsCalculatingVisitor(input, this.session, this.functionAndTypeManager);
        }

        private PlanNodeStatsEstimate process(RowExpression rowExpression) {
            return FilterStatsCalculator.this.normalizer.normalize((PlanNodeStatsEstimate)rowExpression.accept((RowExpressionVisitor)this, null));
        }

        private PlanNodeStatsEstimate estimateLogicalAnd(RowExpression left, RowExpression right) {
            PlanNodeStatsEstimate smallestKnownEstimate;
            PlanNodeStatsEstimate logicalAndEstimate;
            PlanNodeStatsEstimate leftEstimate = this.process(left);
            if (!leftEstimate.isOutputRowCountUnknown() && !(logicalAndEstimate = this.newEstimate(leftEstimate).process(right)).isOutputRowCountUnknown()) {
                return logicalAndEstimate;
            }
            PlanNodeStatsEstimate rightEstimate = this.process(right);
            if (leftEstimate.isOutputRowCountUnknown()) {
                smallestKnownEstimate = rightEstimate;
            } else if (rightEstimate.isOutputRowCountUnknown()) {
                smallestKnownEstimate = leftEstimate;
            } else {
                PlanNodeStatsEstimate planNodeStatsEstimate = smallestKnownEstimate = leftEstimate.getOutputRowCount() <= rightEstimate.getOutputRowCount() ? leftEstimate : rightEstimate;
            }
            if (smallestKnownEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            return smallestKnownEstimate.mapOutputRowCount(rowCount -> rowCount * 0.9);
        }

        private PlanNodeStatsEstimate estimateLogicalOr(RowExpression left, RowExpression right) {
            PlanNodeStatsEstimate leftEstimate = this.process(left);
            if (leftEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate rightEstimate = this.process(right);
            if (rightEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate andEstimate = this.newEstimate(leftEstimate).process(right);
            if (andEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            return PlanNodeStatsEstimateMath.capStats(PlanNodeStatsEstimateMath.subtractSubsetStats(PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues(leftEstimate, rightEstimate), andEstimate), this.input);
        }

        private PlanNodeStatsEstimate estimateIn(RowExpression value, List<RowExpression> candidates) {
            ImmutableList equalityEstimates = (ImmutableList)candidates.stream().map(inValue -> this.process((RowExpression)Expressions.call(OperatorType.EQUAL.name(), FilterStatsCalculator.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(value.getType(), inValue.getType())), (Type)BooleanType.BOOLEAN, value, inValue))).collect(ImmutableList.toImmutableList());
            if (equalityEstimates.stream().anyMatch(PlanNodeStatsEstimate::isOutputRowCountUnknown)) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate inEstimate = equalityEstimates.stream().reduce(PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues).orElse(PlanNodeStatsEstimate.unknown());
            if (inEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            VariableStatsEstimate valueStats = this.getRowExpressionStats(value);
            if (valueStats.isUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            double notNullValuesBeforeIn = this.input.getOutputRowCount() * (1.0 - valueStats.getNullsFraction());
            PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
            result.setOutputRowCount(Double.min(inEstimate.getOutputRowCount(), notNullValuesBeforeIn));
            if (value instanceof VariableReferenceExpression) {
                VariableReferenceExpression valueVariable = (VariableReferenceExpression)value;
                VariableStatsEstimate newVariableStats = inEstimate.getVariableStatistics(valueVariable).mapDistinctValuesCount(newDistinctValuesCount -> Double.min(newDistinctValuesCount, valueStats.getDistinctValuesCount()));
                result.addVariableStatistics(valueVariable, newVariableStats);
            }
            return result.build();
        }

        private PlanNodeStatsEstimate estimateIsNull(RowExpression expression) {
            if (expression instanceof VariableReferenceExpression) {
                VariableReferenceExpression variable = (VariableReferenceExpression)expression;
                VariableStatsEstimate variableStats = this.input.getVariableStatistics(variable);
                PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
                result.setOutputRowCount(this.input.getOutputRowCount() * variableStats.getNullsFraction());
                result.addVariableStatistics(variable, VariableStatsEstimate.builder().setNullsFraction(1.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setDistinctValuesCount(0.0).build());
                return result.build();
            }
            return PlanNodeStatsEstimate.unknown();
        }

        private RowExpression isNull(RowExpression expression) {
            return new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{expression});
        }

        private RowExpression not(RowExpression expression) {
            return Expressions.call("not", FilterStatsCalculator.this.functionResolution.notFunction(), expression.getType(), expression);
        }

        private ComparisonExpression.Operator getComparisonOperator(OperatorType operator) {
            switch (operator) {
                case EQUAL: {
                    return ComparisonExpression.Operator.EQUAL;
                }
                case NOT_EQUAL: {
                    return ComparisonExpression.Operator.NOT_EQUAL;
                }
                case LESS_THAN: {
                    return ComparisonExpression.Operator.LESS_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return ComparisonExpression.Operator.GREATER_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
                }
                case IS_DISTINCT_FROM: {
                    return ComparisonExpression.Operator.IS_DISTINCT_FROM;
                }
            }
            throw new IllegalStateException("Unsupported comparison operator type: " + operator);
        }

        private OperatorType flip(OperatorType operatorType) {
            switch (operatorType) {
                case EQUAL: {
                    return OperatorType.EQUAL;
                }
                case NOT_EQUAL: {
                    return OperatorType.NOT_EQUAL;
                }
                case LESS_THAN: {
                    return OperatorType.GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return OperatorType.GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return OperatorType.LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return OperatorType.LESS_THAN_OR_EQUAL;
                }
                case IS_DISTINCT_FROM: {
                    return OperatorType.IS_DISTINCT_FROM;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + operatorType);
        }

        private VariableStatsEstimate getRowExpressionStats(RowExpression expression) {
            if (expression instanceof VariableReferenceExpression) {
                VariableReferenceExpression variable = (VariableReferenceExpression)expression;
                return Objects.requireNonNull(this.input.getVariableStatistics(variable), () -> String.format("No statistics for variable %s", variable));
            }
            return FilterStatsCalculator.this.scalarStatsCalculator.calculate(expression, this.input, this.session);
        }
    }

    private class FilterExpressionStatsCalculatingVisitor
    extends AstVisitor<PlanNodeStatsEstimate, Void> {
        private final PlanNodeStatsEstimate input;
        private final Session session;
        private final TypeProvider types;

        FilterExpressionStatsCalculatingVisitor(PlanNodeStatsEstimate input, Session session, TypeProvider types) {
            this.input = input;
            this.session = session;
            this.types = types;
        }

        public PlanNodeStatsEstimate process(Node node, @Nullable Void context) {
            return FilterStatsCalculator.this.normalizer.normalize((PlanNodeStatsEstimate)super.process(node, (Object)context));
        }

        protected PlanNodeStatsEstimate visitExpression(Expression node, Void context) {
            return PlanNodeStatsEstimate.unknown();
        }

        protected PlanNodeStatsEstimate visitNotExpression(NotExpression node, Void context) {
            if (node.getValue() instanceof IsNullPredicate) {
                return (PlanNodeStatsEstimate)this.process((Node)new IsNotNullPredicate(((IsNullPredicate)node.getValue()).getValue()));
            }
            return PlanNodeStatsEstimateMath.subtractSubsetStats(this.input, (PlanNodeStatsEstimate)this.process((Node)node.getValue()));
        }

        protected PlanNodeStatsEstimate visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            switch (node.getOperator()) {
                case AND: {
                    return this.estimateLogicalAnd(node.getLeft(), node.getRight());
                }
                case OR: {
                    return this.estimateLogicalOr(node.getLeft(), node.getRight());
                }
            }
            throw new IllegalArgumentException("Unexpected binary operator: " + node.getOperator());
        }

        private PlanNodeStatsEstimate estimateLogicalAnd(Expression left, Expression right) {
            PlanNodeStatsEstimate smallestKnownEstimate;
            PlanNodeStatsEstimate logicalAndEstimate;
            PlanNodeStatsEstimate leftEstimate = (PlanNodeStatsEstimate)this.process((Node)left);
            if (!leftEstimate.isOutputRowCountUnknown() && !(logicalAndEstimate = (PlanNodeStatsEstimate)new FilterExpressionStatsCalculatingVisitor(leftEstimate, this.session, this.types).process((Node)right)).isOutputRowCountUnknown()) {
                return logicalAndEstimate;
            }
            PlanNodeStatsEstimate rightEstimate = (PlanNodeStatsEstimate)this.process((Node)right);
            if (leftEstimate.isOutputRowCountUnknown()) {
                smallestKnownEstimate = rightEstimate;
            } else if (rightEstimate.isOutputRowCountUnknown()) {
                smallestKnownEstimate = leftEstimate;
            } else {
                PlanNodeStatsEstimate planNodeStatsEstimate = smallestKnownEstimate = leftEstimate.getOutputRowCount() <= rightEstimate.getOutputRowCount() ? leftEstimate : rightEstimate;
            }
            if (smallestKnownEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            return smallestKnownEstimate.mapOutputRowCount(rowCount -> rowCount * 0.9);
        }

        private PlanNodeStatsEstimate estimateLogicalOr(Expression left, Expression right) {
            PlanNodeStatsEstimate leftEstimate = (PlanNodeStatsEstimate)this.process((Node)left);
            if (leftEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate rightEstimate = (PlanNodeStatsEstimate)this.process((Node)right);
            if (rightEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate andEstimate = (PlanNodeStatsEstimate)new FilterExpressionStatsCalculatingVisitor(leftEstimate, this.session, this.types).process((Node)right);
            if (andEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            return PlanNodeStatsEstimateMath.capStats(PlanNodeStatsEstimateMath.subtractSubsetStats(PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues(leftEstimate, rightEstimate), andEstimate), this.input);
        }

        protected PlanNodeStatsEstimate visitBooleanLiteral(BooleanLiteral node, Void context) {
            if (node.getValue()) {
                return this.input;
            }
            PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
            result.setOutputRowCount(0.0);
            this.input.getVariablesWithKnownStatistics().forEach(variable -> result.addVariableStatistics((VariableReferenceExpression)variable, VariableStatsEstimate.zero()));
            return result.build();
        }

        protected PlanNodeStatsEstimate visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            if (node.getValue() instanceof SymbolReference) {
                VariableReferenceExpression variable = this.toVariable(node.getValue());
                VariableStatsEstimate variableStats = this.input.getVariableStatistics(variable);
                PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
                result.setOutputRowCount(this.input.getOutputRowCount() * (1.0 - variableStats.getNullsFraction()));
                result.addVariableStatistics(variable, variableStats.mapNullsFraction(x -> 0.0));
                return result.build();
            }
            return PlanNodeStatsEstimate.unknown();
        }

        protected PlanNodeStatsEstimate visitIsNullPredicate(IsNullPredicate node, Void context) {
            if (node.getValue() instanceof SymbolReference) {
                VariableReferenceExpression variable = this.toVariable(node.getValue());
                VariableStatsEstimate variableStats = this.input.getVariableStatistics(variable);
                PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
                result.setOutputRowCount(this.input.getOutputRowCount() * variableStats.getNullsFraction());
                result.addVariableStatistics(variable, VariableStatsEstimate.builder().setNullsFraction(1.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setDistinctValuesCount(0.0).build());
                return result.build();
            }
            return PlanNodeStatsEstimate.unknown();
        }

        protected PlanNodeStatsEstimate visitBetweenPredicate(BetweenPredicate node, Void context) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return PlanNodeStatsEstimate.unknown();
            }
            if (!this.getExpressionStats(node.getMin()).isSingleValue()) {
                return PlanNodeStatsEstimate.unknown();
            }
            if (!this.getExpressionStats(node.getMax()).isSingleValue()) {
                return PlanNodeStatsEstimate.unknown();
            }
            VariableStatsEstimate valueStats = this.input.getVariableStatistics(this.toVariable(node.getValue()));
            ComparisonExpression lowerBound = new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin());
            ComparisonExpression upperBound = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax());
            Expression transformed = Double.isInfinite(valueStats.getLowValue()) ? ExpressionUtils.and(new Expression[]{lowerBound, upperBound}) : ExpressionUtils.and(new Expression[]{upperBound, lowerBound});
            return (PlanNodeStatsEstimate)this.process((Node)transformed);
        }

        protected PlanNodeStatsEstimate visitInPredicate(InPredicate node, Void context) {
            if (!(node.getValueList() instanceof InListExpression)) {
                return PlanNodeStatsEstimate.unknown();
            }
            InListExpression inList = (InListExpression)node.getValueList();
            ImmutableList equalityEstimates = (ImmutableList)inList.getValues().stream().map(inValue -> (PlanNodeStatsEstimate)this.process((Node)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, node.getValue(), inValue))).collect(ImmutableList.toImmutableList());
            if (equalityEstimates.stream().anyMatch(PlanNodeStatsEstimate::isOutputRowCountUnknown)) {
                return PlanNodeStatsEstimate.unknown();
            }
            PlanNodeStatsEstimate inEstimate = equalityEstimates.stream().reduce(PlanNodeStatsEstimateMath::addStatsAndSumDistinctValues).orElse(PlanNodeStatsEstimate.unknown());
            if (inEstimate.isOutputRowCountUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            VariableStatsEstimate valueStats = this.getExpressionStats(node.getValue());
            if (valueStats.isUnknown()) {
                return PlanNodeStatsEstimate.unknown();
            }
            double notNullValuesBeforeIn = this.input.getOutputRowCount() * (1.0 - valueStats.getNullsFraction());
            PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.buildFrom(this.input);
            result.setOutputRowCount(Double.min(inEstimate.getOutputRowCount(), notNullValuesBeforeIn));
            if (node.getValue() instanceof SymbolReference) {
                VariableReferenceExpression valueVariable = this.toVariable(node.getValue());
                VariableStatsEstimate newvariableStats = inEstimate.getVariableStatistics(valueVariable).mapDistinctValuesCount(newDistinctValuesCount -> Double.min(newDistinctValuesCount, valueStats.getDistinctValuesCount()));
                result.addVariableStatistics(valueVariable, newvariableStats);
            }
            return result.build();
        }

        protected PlanNodeStatsEstimate visitComparisonExpression(ComparisonExpression node, Void context) {
            Optional<VariableReferenceExpression> leftVariable;
            ComparisonExpression.Operator operator = node.getOperator();
            Expression left = node.getLeft();
            Expression right = node.getRight();
            Preconditions.checkArgument((!(left instanceof Literal) || !(right instanceof Literal) ? 1 : 0) != 0, (Object)"Literal-to-literal not supported here, should be eliminated earlier");
            if (!(left instanceof SymbolReference) && right instanceof SymbolReference) {
                return (PlanNodeStatsEstimate)this.process((Node)new ComparisonExpression(operator.flip(), right, left));
            }
            if (left instanceof Literal && !(right instanceof Literal)) {
                return (PlanNodeStatsEstimate)this.process((Node)new ComparisonExpression(operator.flip(), right, left));
            }
            if (left instanceof SymbolReference && left.equals((Object)right)) {
                return (PlanNodeStatsEstimate)this.process((Node)new IsNotNullPredicate(left));
            }
            VariableStatsEstimate leftStats = this.getExpressionStats(left);
            Optional<VariableReferenceExpression> optional = leftVariable = left instanceof SymbolReference ? Optional.of(this.toVariable(left)) : Optional.empty();
            if (right instanceof Literal) {
                Object literalValue = LiteralInterpreter.evaluate(FilterStatsCalculator.this.metadata, this.session.toConnectorSession(), right);
                if (literalValue == null) {
                    return this.visitBooleanLiteral(BooleanLiteral.FALSE_LITERAL, null);
                }
                OptionalDouble literal = StatsUtil.toStatsRepresentation(FilterStatsCalculator.this.metadata, this.session, this.getType(left), literalValue);
                return ComparisonStatsCalculator.estimateExpressionToLiteralComparison(this.input, leftStats, leftVariable, literal, operator);
            }
            VariableStatsEstimate rightStats = this.getExpressionStats(right);
            if (rightStats.isSingleValue()) {
                OptionalDouble value = Double.isNaN(rightStats.getLowValue()) ? OptionalDouble.empty() : OptionalDouble.of(rightStats.getLowValue());
                return ComparisonStatsCalculator.estimateExpressionToLiteralComparison(this.input, leftStats, leftVariable, value, operator);
            }
            Optional<VariableReferenceExpression> rightVariable = right instanceof SymbolReference ? Optional.of(this.toVariable(right)) : Optional.empty();
            return ComparisonStatsCalculator.estimateExpressionToExpressionComparison(this.input, leftStats, leftVariable, rightStats, rightVariable, operator);
        }

        private Type getType(Expression expression) {
            if (expression instanceof SymbolReference) {
                return Objects.requireNonNull(this.types.get(expression), () -> String.format("No type for expression %s", expression));
            }
            ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries(FilterStatsCalculator.this.metadata.getFunctionAndTypeManager(), this.session, this.types, (List<Expression>)ImmutableList.of(), node -> new VerifyException("Unexpected subquery"), WarningCollector.NOOP, false);
            return expressionAnalyzer.analyze(expression, Scope.create());
        }

        private VariableStatsEstimate getExpressionStats(Expression expression) {
            if (expression instanceof SymbolReference) {
                VariableReferenceExpression variable = this.toVariable(expression);
                return Objects.requireNonNull(this.input.getVariableStatistics(variable), () -> String.format("No statistics for variable %s", variable));
            }
            return FilterStatsCalculator.this.scalarStatsCalculator.calculate(expression, this.input, this.session, this.types);
        }

        private VariableReferenceExpression toVariable(Expression expression) {
            Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (String)"Unexpected expression: %s", (Object)expression);
            return new VariableReferenceExpression(((SymbolReference)expression).getName(), this.types.get(expression));
        }
    }
}

