/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpatialJoinUtils {
    public static final QualifiedFunctionName ST_CONTAINS = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_contains");
    public static final QualifiedFunctionName ST_CROSSES = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_crosses");
    public static final QualifiedFunctionName ST_EQUALS = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_equals");
    public static final QualifiedFunctionName ST_INTERSECTS = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_intersects");
    public static final QualifiedFunctionName ST_OVERLAPS = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_overlaps");
    public static final QualifiedFunctionName ST_TOUCHES = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_touches");
    public static final QualifiedFunctionName ST_WITHIN = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_within");
    public static final QualifiedFunctionName ST_DISTANCE = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_distance");
    private static final Set<String> ALLOWED_SPATIAL_JOIN_FUNCTIONS = Stream.of(ST_CONTAINS, ST_CROSSES, ST_EQUALS, ST_INTERSECTS, ST_OVERLAPS, ST_TOUCHES, ST_WITHIN).map(QualifiedFunctionName::getFunctionName).map(String::toLowerCase).collect(Collectors.toSet());

    private SpatialJoinUtils() {
    }

    public static List<CallExpression> extractSupportedSpatialFunctions(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> SpatialJoinUtils.isSupportedSpatialFunction(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(CallExpression call, FunctionManager functionManager) {
        String functionName = functionManager.getFunctionMetadata(call.getFunctionHandle()).getName().getFunctionName().toLowerCase(Locale.ENGLISH);
        return ALLOWED_SPATIAL_JOIN_FUNCTIONS.contains(functionName);
    }

    public static List<CallExpression> extractSupportedSpatialComparisons(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> new FunctionResolution(functionManager).isComparisonFunction(call.getFunctionHandle())).filter(call -> SpatialJoinUtils.isSupportedSpatialComparison(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(CallExpression expression, FunctionManager functionManager) {
        FunctionMetadata metadata = functionManager.getFunctionMetadata(expression.getFunctionHandle());
        Preconditions.checkArgument((metadata.getOperatorType().isPresent() && ((OperatorType)metadata.getOperatorType().get()).isComparisonOperator() ? 1 : 0) != 0);
        switch ((OperatorType)metadata.getOperatorType().get()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(0), functionManager);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(1), functionManager);
            }
        }
        return false;
    }

    private static boolean isSTDistance(RowExpression expression, FunctionManager functionManager) {
        return expression instanceof CallExpression && functionManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getName().equals((Object)ST_DISTANCE);
    }

    public static FunctionHandle getFlippedFunctionHandle(CallExpression callExpression, FunctionManager functionManager) {
        FunctionMetadata callExpressionMetadata = functionManager.getFunctionMetadata(callExpression.getFunctionHandle());
        Preconditions.checkArgument((boolean)callExpressionMetadata.getOperatorType().isPresent());
        OperatorType operatorType = SpatialJoinUtils.flip((OperatorType)callExpressionMetadata.getOperatorType().get());
        List<TypeSignatureProvider> typeProviderList = TypeSignatureProvider.fromTypes((List)callExpression.getArguments().stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList()));
        Preconditions.checkArgument((typeProviderList.size() == 2 ? 1 : 0) != 0, (Object)"Expected there to be only two arguments in type provider");
        return functionManager.resolveOperator(operatorType, (List<TypeSignatureProvider>)ImmutableList.of((Object)typeProviderList.get(1), (Object)typeProviderList.get(0)));
    }

    public static OperatorType flip(OperatorType operatorType) {
        switch (operatorType) {
            case EQUAL: {
                return OperatorType.EQUAL;
            }
            case NOT_EQUAL: {
                return OperatorType.NOT_EQUAL;
            }
            case LESS_THAN: {
                return OperatorType.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return OperatorType.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return OperatorType.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return OperatorType.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return OperatorType.IS_DISTINCT_FROM;
            }
        }
        throw new IllegalArgumentException("Unsupported comparison: " + operatorType);
    }
}

