/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.iterative.rule.LambdaCaptureDesugaringRewriter;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class SqlFunctionUtils {
    private SqlFunctionUtils() {
    }

    public static Expression getSqlFunctionExpression(FunctionMetadata functionMetadata, SqlInvokedScalarFunctionImplementation implementation, SqlFunctionProperties sqlFunctionProperties, List<Expression> arguments) {
        Preconditions.checkArgument((boolean)functionMetadata.getImplementationType().equals((Object)FunctionImplementationType.SQL), (Object)String.format("Expect SQL function, get %s", functionMetadata.getImplementationType()));
        Preconditions.checkArgument((boolean)functionMetadata.getArgumentNames().isPresent(), (Object)"ArgumentNames is missing");
        Expression expression = SqlFunctionUtils.normalizeParameters((List)functionMetadata.getArgumentNames().get(), SqlFunctionUtils.parseSqlFunctionExpression(implementation, sqlFunctionProperties));
        return SqlFunctionArgumentBinder.bindFunctionArguments(expression, (List)functionMetadata.getArgumentNames().get(), arguments);
    }

    public static RowExpression getSqlFunctionRowExpression(FunctionMetadata functionMetadata, SqlInvokedScalarFunctionImplementation functionImplementation, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, List<RowExpression> arguments) {
        Preconditions.checkArgument((boolean)functionMetadata.getImplementationType().equals((Object)FunctionImplementationType.SQL), (Object)String.format("Expect SQL function, get %s", functionMetadata.getImplementationType()));
        Preconditions.checkArgument((boolean)functionMetadata.getArgumentNames().isPresent(), (Object)"ArgumentNames is missing");
        Expression normalized = SqlFunctionUtils.normalizeParameters((List)functionMetadata.getArgumentNames().get(), SqlFunctionUtils.parseSqlFunctionExpression(functionImplementation, sqlFunctionProperties));
        Expression expression = SqlFunctionUtils.coerceIfNecessary(functionMetadata, normalized, sqlFunctionProperties, metadata);
        PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
        Map<Identifier, VariableReferenceExpression> variables = SqlFunctionUtils.buildIdentifierToVariableMap(functionMetadata, expression, sqlFunctionProperties, metadata, variableAllocator);
        Expression rewritten = SqlFunctionUtils.rewriteSqlFunctionExpressionWithVariables(expression, variables);
        Expression lambdaCaptureDesugaredExpression = LambdaCaptureDesugaringRewriter.rewrite(rewritten, variableAllocator);
        return SqlFunctionArgumentBinder.bindFunctionArguments(SqlToRowExpressionTranslator.translate(lambdaCaptureDesugaredExpression, ExpressionAnalyzer.analyzeSqlFunctionExpression(metadata, sqlFunctionProperties, lambdaCaptureDesugaredExpression, variableAllocator.getTypes().allTypes()).getExpressionTypes(), (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), metadata.getFunctionManager(), metadata.getTypeManager(), Optional.empty(), Optional.empty(), sqlFunctionProperties), (List)((List)functionMetadata.getArgumentNames().get()).stream().map(Identifier::new).map(variables::get).map(Optional::ofNullable).map(variable -> variable.map(VariableReferenceExpression::getName)).collect(ImmutableList.toImmutableList()), arguments);
    }

    private static Expression normalizeParameters(List<String> argumentNames, Expression sqlFunction) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Map<String, String>>(){

            public Expression rewriteIdentifier(Identifier node, Map<String, String> context, ExpressionTreeRewriter<Map<String, String>> treeRewriter) {
                String name = node.getValue().toLowerCase(Locale.ENGLISH);
                if (context.containsKey(name)) {
                    return new Identifier(context.get(name));
                }
                return node;
            }
        }, (Expression)sqlFunction, argumentNames.stream().collect(ImmutableMap.toImmutableMap(String::toLowerCase, Function.identity())));
    }

    private static Expression parseSqlFunctionExpression(SqlInvokedScalarFunctionImplementation functionImplementation, SqlFunctionProperties sqlFunctionProperties) {
        ParsingOptions parsingOptions = ParsingOptions.builder().setDecimalLiteralTreatment(sqlFunctionProperties.isParseDecimalLiteralAsDouble() ? ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE : ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL).build();
        return new SqlParser().createReturn(functionImplementation.getImplementation(), parsingOptions).getExpression();
    }

    private static Map<String, Type> getFunctionArgumentTypes(FunctionMetadata functionMetadata, Metadata metadata) {
        List argumentNames = (List)functionMetadata.getArgumentNames().get();
        List argumentTypes = (List)functionMetadata.getArgumentTypes().stream().map(metadata::getType).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((argumentNames.size() == argumentTypes.size() ? 1 : 0) != 0, (Object)String.format("Expect argumentNames (size %d) and argumentTypes (size %d) to be of the same size", argumentNames.size(), argumentTypes.size()));
        ImmutableMap.Builder typeBuilder = ImmutableMap.builder();
        for (int i = 0; i < argumentNames.size(); ++i) {
            typeBuilder.put(argumentNames.get(i), argumentTypes.get(i));
        }
        return typeBuilder.build();
    }

    private static Map<Identifier, VariableReferenceExpression> buildIdentifierToVariableMap(FunctionMetadata functionMetadata, Expression sqlFunction, SqlFunctionProperties sqlFunctionProperties, Metadata metadata, PlanVariableAllocator variableAllocator) {
        Map<String, Type> argumentTypes = SqlFunctionUtils.getFunctionArgumentTypes(functionMetadata, metadata);
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.analyzeSqlFunctionExpression(metadata, sqlFunctionProperties, sqlFunction, argumentTypes).getExpressionTypes();
        LinkedHashMap<Identifier, VariableReferenceExpression> variables = new LinkedHashMap<Identifier, VariableReferenceExpression>();
        for (Map.Entry<NodeRef<Expression>, Type> entry : expressionTypes.entrySet()) {
            Expression node = (Expression)entry.getKey().getNode();
            if (node instanceof LambdaArgumentDeclaration) {
                LambdaArgumentDeclaration lambdaArgumentDeclaration = (LambdaArgumentDeclaration)node;
                if (variables.containsKey(lambdaArgumentDeclaration.getName())) continue;
                variables.put(lambdaArgumentDeclaration.getName(), variableAllocator.newVariable((Expression)lambdaArgumentDeclaration.getName(), entry.getValue()));
                continue;
            }
            if (!(node instanceof Identifier) || !argumentTypes.containsKey(((Identifier)node).getValue()) || variables.containsKey(node)) continue;
            variables.put((Identifier)node, variableAllocator.newVariable(node, entry.getValue()));
        }
        return variables;
    }

    private static Expression rewriteSqlFunctionExpressionWithVariables(Expression sqlFunction, Map<Identifier, VariableReferenceExpression> variableMap) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Map<Identifier, VariableReferenceExpression>>(){

            public Expression rewriteLambdaExpression(LambdaExpression node, Map<Identifier, VariableReferenceExpression> context, ExpressionTreeRewriter<Map<Identifier, VariableReferenceExpression>> treeRewriter) {
                ImmutableList.Builder newArguments = ImmutableList.builder();
                for (LambdaArgumentDeclaration argument : node.getArguments()) {
                    VariableReferenceExpression variable = context.get(argument.getName());
                    newArguments.add((Object)new LambdaArgumentDeclaration(new Identifier(variable.getName())));
                }
                return new LambdaExpression((List)newArguments.build(), treeRewriter.rewrite(node.getBody(), context));
            }

            public Expression rewriteIdentifier(Identifier node, Map<Identifier, VariableReferenceExpression> context, ExpressionTreeRewriter<Map<Identifier, VariableReferenceExpression>> treeRewriter) {
                return new SymbolReference(context.get(node).getName());
            }
        }, (Expression)sqlFunction, variableMap);
    }

    private static Expression coerceIfNecessary(FunctionMetadata functionMetadata, Expression sqlFunction, SqlFunctionProperties sqlFunctionProperties, Metadata metadata) {
        final ExpressionAnalysis analysis = ExpressionAnalyzer.analyzeSqlFunctionExpression(metadata, sqlFunctionProperties, sqlFunction, SqlFunctionUtils.getFunctionArgumentTypes(functionMetadata, metadata));
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<ExpressionAnalysis>(){

            public Expression rewriteExpression(Expression expression, ExpressionAnalysis context, ExpressionTreeRewriter<ExpressionAnalysis> treeRewriter) {
                Expression rewritten = treeRewriter.defaultRewrite(expression, null);
                Type coercion = analysis.getCoercion(expression);
                if (coercion != null) {
                    return new Cast(rewritten, coercion.getTypeSignature().toString(), false, analysis.isTypeOnlyCoercion(expression));
                }
                return rewritten;
            }
        }, (Expression)sqlFunction, (Object)analysis);
    }

    private static final class SqlFunctionArgumentBinder {
        private SqlFunctionArgumentBinder() {
        }

        public static Expression bindFunctionArguments(Expression function, List<String> argumentNames, List<Expression> argumentValues) {
            Preconditions.checkArgument((argumentNames.size() == argumentValues.size() ? 1 : 0) != 0, (Object)String.format("Expect same size for argumentNames (%d) and argumentValues (%d)", argumentNames.size(), argumentValues.size()));
            ImmutableMap.Builder argumentBindings = ImmutableMap.builder();
            for (int i = 0; i < argumentNames.size(); ++i) {
                argumentBindings.put((Object)argumentNames.get(i), (Object)argumentValues.get(i));
            }
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionFunctionVisitor((Map<String, Expression>)argumentBindings.build()), (Expression)function);
        }

        public static RowExpression bindFunctionArguments(RowExpression function, List<Optional<String>> argumentNames, List<RowExpression> argumentValues) {
            Preconditions.checkArgument((argumentNames.size() == argumentValues.size() ? 1 : 0) != 0, (Object)String.format("Expect same size for argumentNames (%d) and argumentValues (%d)", argumentNames.size(), argumentValues.size()));
            ImmutableMap.Builder argumentBindings = ImmutableMap.builder();
            for (int i = 0; i < argumentNames.size(); ++i) {
                if (!argumentNames.get(i).isPresent()) continue;
                argumentBindings.put((Object)argumentNames.get(i).get(), (Object)argumentValues.get(i));
            }
            return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionRewriter<Map<String, RowExpression>>(){

                public RowExpression rewriteLambda(LambdaDefinitionExpression lambda, Map<String, RowExpression> context, RowExpressionTreeRewriter<Map<String, RowExpression>> treeRewriter) {
                    ImmutableMap lambdaContext = (ImmutableMap)context.entrySet().stream().filter(entry -> !lambda.getArguments().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                    RowExpression body = treeRewriter.rewrite(lambda.getBody(), (Object)lambdaContext);
                    return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), body);
                }

                public RowExpression rewriteVariableReference(VariableReferenceExpression variable, Map<String, RowExpression> context, RowExpressionTreeRewriter<Map<String, RowExpression>> treeRewriter) {
                    if (context.containsKey(variable.getName())) {
                        return context.get(variable.getName());
                    }
                    return variable;
                }
            }, (RowExpression)function, (Object)argumentBindings.build());
        }

        private static class ExpressionFunctionVisitor
        extends ExpressionRewriter<Void> {
            private final Map<String, Expression> argumentBindings;

            public ExpressionFunctionVisitor(Map<String, Expression> argumentBindings) {
                this.argumentBindings = Objects.requireNonNull(argumentBindings, "argumentBindings is null");
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (this.argumentBindings.containsKey(node.getValue())) {
                    return this.argumentBindings.get(node.getValue());
                }
                return node;
            }
        }
    }
}

