/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ExternalCallExpressionChecker;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class VerifyProjectionLocality
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(metadata.getFunctionManager()), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final ExternalCallExpressionChecker externalCallExpressionChecker;

        Visitor(FunctionManager functionManager) {
            this.externalCallExpressionChecker = new ExternalCallExpressionChecker(Objects.requireNonNull(functionManager, "functionManager is null"));
        }

        public Void visitProject(ProjectNode node, Void context) {
            switch (node.getLocality()) {
                case LOCAL: {
                    Preconditions.checkState((boolean)node.getAssignments().getExpressions().stream().noneMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)this.externalCallExpressionChecker, null)), (Object)String.format("ProjectNode with LOCAL locality has remote functions. Assignments are: %s", node.getAssignments()));
                    break;
                }
                case REMOTE: {
                    node.getAssignments().getExpressions().forEach(expression -> {
                        Preconditions.checkState((expression instanceof VariableReferenceExpression || expression instanceof CallExpression ? 1 : 0) != 0, (Object)String.format("Expect VariableReferenceExpression or CallExpression, got %s", expression.getClass().getName()));
                        if (expression instanceof CallExpression) {
                            Preconditions.checkState((boolean)((Boolean)expression.accept((RowExpressionVisitor)this.externalCallExpressionChecker, null)), (Object)String.format("Expect expression %s to be an external function", expression));
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException("ProjectNode should have locality LOCAL or REMOTE");
                }
            }
            return null;
        }
    }
}

