/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SetOperationNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.WindowNodeUtil;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ValidateDependenciesChecker
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        ValidateDependenciesChecker.validate(plan, types);
    }

    public static void validate(PlanNode plan, TypeProvider types) {
        plan.accept((PlanVisitor)new Visitor(types), (Object)ImmutableSet.of());
    }

    private static class Visitor
    extends InternalPlanVisitor<Void, Set<VariableReferenceExpression>> {
        private final TypeProvider types;

        public Visitor(TypeProvider types) {
            this.types = Objects.requireNonNull(types, "types is null");
        }

        public Void visitPlan(PlanNode node, Set<VariableReferenceExpression> boundVariables) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            return null;
        }

        public Void visitAggregation(AggregationNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getGroupingKeys(), "Invalid node. Grouping key variables (%s) not in source plan output (%s)", node.getGroupingKeys(), node.getSource().getOutputVariables());
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                Set<VariableReferenceExpression> dependencies = AggregationNodeUtils.extractAggregationUniqueVariables(aggregation, this.types);
                this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)dependencies, "Invalid node. Aggregation dependencies (%s) not in source plan output (%s)", dependencies, node.getSource().getOutputVariables());
                aggregation.getMask().ifPresent(mask -> this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)ImmutableSet.of((Object)mask), "Invalid node. Aggregation mask symbol (%s) not in source plan output (%s)", mask, node.getSource().getOutputVariables()));
            }
            return null;
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            this.checkDependencies(source.getOutputVariables(), node.getInputVariables(), "Invalid node. Grouping symbols (%s) not in source plan output (%s)", node.getInputVariables(), source.getOutputVariables());
            return null;
        }

        public Void visitMarkDistinct(MarkDistinctNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            this.checkDependencies(source.getOutputVariables(), node.getDistinctVariables(), "Invalid node. Mark distinct symbols (%s) not in source plan output (%s)", node.getDistinctVariables(), source.getOutputVariables());
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", node.getPartitionBy(), node.getSource().getOutputVariables());
            if (node.getOrderingScheme().isPresent()) {
                this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOrderingScheme().get().getOrderByVariables(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", node.getOrderingScheme().get().getOrderByVariables(), node.getSource().getOutputVariables());
            }
            ImmutableList.Builder bounds = ImmutableList.builder();
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getStartValue().isPresent()) {
                    bounds.add((Object)frame.getStartValue().get());
                }
                if (!frame.getEndValue().isPresent()) continue;
                bounds.add((Object)frame.getEndValue().get());
            }
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)bounds.build(), "Invalid node. Frame bounds (%s) not in source plan output (%s)", bounds.build(), node.getSource().getOutputVariables());
            for (WindowNode.Function function : node.getWindowFunctions().values()) {
                Set<VariableReferenceExpression> dependencies = WindowNodeUtil.extractWindowFunctionUniqueVariables(function, this.types);
                this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)dependencies, "Invalid node. Window function dependencies (%s) not in source plan output (%s)", dependencies, node.getSource().getOutputVariables());
            }
            return null;
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", node.getPartitionBy(), node.getSource().getOutputVariables());
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOrderingScheme().getOrderByVariables(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", node.getOrderingScheme().getOrderByVariables(), node.getSource().getOutputVariables());
            return null;
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            this.checkDependencies(source.getOutputVariables(), node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", node.getPartitionBy(), source.getOutputVariables());
            return null;
        }

        public Void visitFilter(FilterNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOutputVariables(), "Invalid node. Output symbols (%s) not in source plan output (%s)", node.getOutputVariables(), node.getSource().getOutputVariables());
            Set dependencies = OriginalExpressionUtils.isExpression(node.getPredicate()) ? (Set)VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(node.getPredicate()), this.types).stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet()) : (Set)VariablesExtractor.extractUnique(node.getPredicate()).stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((boolean)((ImmutableSet)inputs.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())).containsAll((Collection)dependencies), (String)"Symbol from filter (%s) not in sources (%s)", (Object)dependencies, inputs);
            return null;
        }

        @Override
        public Void visitSample(SampleNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            return null;
        }

        public Void visitProject(ProjectNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            for (RowExpression expression : node.getAssignments().getExpressions()) {
                Set<VariableReferenceExpression> dependencies = OriginalExpressionUtils.isExpression(expression) ? VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(expression), this.types) : VariablesExtractor.extractUnique(expression);
                this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)dependencies, "Invalid node. Expression dependencies (%s) not in source plan output (%s)", dependencies, inputs);
            }
            return null;
        }

        public Void visitTopN(TopNNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOutputVariables(), "Invalid node. Output symbols (%s) not in source plan output (%s)", node.getOutputVariables(), node.getSource().getOutputVariables());
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOrderingScheme().getOrderByVariables(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", node.getOrderingScheme().getOrderByVariables(), node.getSource().getOutputVariables());
            return null;
        }

        @Override
        public Void visitSort(SortNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> inputs = Visitor.createInputs(source, boundVariables);
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, (Collection<VariableReferenceExpression>)node.getOutputVariables(), "Invalid node. Output symbols (%s) not in source plan output (%s)", node.getOutputVariables(), node.getSource().getOutputVariables());
            this.checkDependencies((Collection<VariableReferenceExpression>)inputs, node.getOrderingScheme().getOrderByVariables(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", node.getOrderingScheme().getOrderByVariables(), node.getSource().getOutputVariables());
            return null;
        }

        @Override
        public Void visitOutput(OutputNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            this.checkDependencies(source.getOutputVariables(), node.getOutputVariables(), "Invalid node. Output column dependencies (%s) not in source plan output (%s)", node.getOutputVariables(), source.getOutputVariables());
            return null;
        }

        public Void visitLimit(LimitNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            return null;
        }

        public Void visitDistinctLimit(DistinctLimitNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            this.checkDependencies(source.getOutputVariables(), node.getOutputVariables(), "Invalid node. Output column dependencies (%s) not in source plan output (%s)", node.getOutputVariables(), source.getOutputVariables());
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getLeft().accept((PlanVisitor)this, boundVariables);
            node.getRight().accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> leftInputs = Visitor.createInputs(node.getLeft(), boundVariables);
            ImmutableSet<VariableReferenceExpression> rightInputs = Visitor.createInputs(node.getRight(), boundVariables);
            ImmutableSet allInputs = ImmutableSet.builder().addAll(leftInputs).addAll(rightInputs).build();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)leftInputs.contains(clause.getLeft()), (String)"Symbol from join clause (%s) not in left source (%s)", (Object)clause.getLeft(), (Object)node.getLeft().getOutputVariables());
                Preconditions.checkArgument((boolean)rightInputs.contains(clause.getRight()), (String)"Symbol from join clause (%s) not in right source (%s)", (Object)clause.getRight(), (Object)node.getRight().getOutputVariables());
            }
            node.getFilter().ifPresent(arg_0 -> this.lambda$visitJoin$1((Set)allInputs, arg_0));
            this.checkLeftOutputVariablesBeforeRight(node.getLeft().getOutputVariables(), node.getOutputVariables());
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getSource().accept((PlanVisitor)this, boundVariables);
            node.getFilteringSource().accept((PlanVisitor)this, boundVariables);
            Preconditions.checkArgument((boolean)node.getSource().getOutputVariables().contains(node.getSourceJoinVariable()), (String)"Symbol from semi join clause (%s) not in source (%s)", (Object)node.getSourceJoinVariable(), (Object)node.getSource().getOutputVariables());
            Preconditions.checkArgument((boolean)node.getFilteringSource().getOutputVariables().contains(node.getFilteringSourceJoinVariable()), (String)"Symbol from semi join clause (%s) not in filtering source (%s)", (Object)node.getSourceJoinVariable(), (Object)node.getFilteringSource().getOutputVariables());
            ImmutableSet<VariableReferenceExpression> outputs = Visitor.createInputs(node, boundVariables);
            Preconditions.checkArgument((boolean)outputs.containsAll(node.getSource().getOutputVariables()), (String)"Semi join output symbols (%s) must contain all of the source symbols (%s)", node.getOutputVariables(), (Object)node.getSource().getOutputVariables());
            Preconditions.checkArgument((boolean)outputs.contains(node.getSemiJoinOutput()), (String)"Semi join output symbols (%s) must contain join result (%s)", node.getOutputVariables(), (Object)node.getSemiJoinOutput());
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getLeft().accept((PlanVisitor)this, boundVariables);
            node.getRight().accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> leftInputs = Visitor.createInputs(node.getLeft(), boundVariables);
            ImmutableSet<VariableReferenceExpression> rightInputs = Visitor.createInputs(node.getRight(), boundVariables);
            ImmutableSet allInputs = ImmutableSet.builder().addAll(leftInputs).addAll(rightInputs).build();
            Set<VariableReferenceExpression> predicateVariables = OriginalExpressionUtils.isExpression(node.getFilter()) ? VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(node.getFilter()), this.types) : VariablesExtractor.extractUnique(node.getFilter());
            Preconditions.checkArgument((boolean)allInputs.containsAll(predicateVariables), (String)"Symbol from filter (%s) not in sources (%s)", predicateVariables, (Object)allInputs);
            this.checkLeftOutputVariablesBeforeRight(node.getLeft().getOutputVariables(), node.getOutputVariables());
            return null;
        }

        private void checkLeftOutputVariablesBeforeRight(List<VariableReferenceExpression> leftVariables, List<VariableReferenceExpression> outputVariables) {
            int leftMaxPosition = -1;
            Optional<Object> rightMinPosition = Optional.empty();
            HashSet<VariableReferenceExpression> leftVariablesSet = new HashSet<VariableReferenceExpression>(leftVariables);
            for (int i = 0; i < outputVariables.size(); ++i) {
                VariableReferenceExpression variable = outputVariables.get(i);
                if (leftVariablesSet.contains(variable)) {
                    leftMaxPosition = i;
                    continue;
                }
                if (rightMinPosition.isPresent()) continue;
                rightMinPosition = Optional.of(i);
            }
            Preconditions.checkState((!rightMinPosition.isPresent() || (Integer)rightMinPosition.get() > leftMaxPosition ? 1 : 0) != 0, (Object)"Not all left output variables are before right output variables");
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getProbeSource().accept((PlanVisitor)this, boundVariables);
            node.getIndexSource().accept((PlanVisitor)this, boundVariables);
            ImmutableSet<VariableReferenceExpression> probeInputs = Visitor.createInputs(node.getProbeSource(), boundVariables);
            ImmutableSet<VariableReferenceExpression> indexSourceInputs = Visitor.createInputs(node.getIndexSource(), boundVariables);
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)probeInputs.contains(clause.getProbe()), (String)"Probe variable from index join clause (%s) not in probe source (%s)", (Object)clause.getProbe(), (Object)node.getProbeSource().getOutputVariables());
                Preconditions.checkArgument((boolean)indexSourceInputs.contains(clause.getIndex()), (String)"Index variable from index join clause (%s) not in index source (%s)", (Object)clause.getIndex(), (Object)node.getIndexSource().getOutputVariables());
            }
            Set lookupVariables = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<VariableReferenceExpression, VariableReferenceExpression> trace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), lookupVariables);
            Preconditions.checkArgument((!trace.isEmpty() && lookupVariables.containsAll(trace.keySet()) ? 1 : 0) != 0, (String)"Index lookup symbols are not traceable to index source: %s", (Object)lookupVariables);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Set<VariableReferenceExpression> boundVariables) {
            this.checkDependencies(node.getOutputVariables(), node.getLookupVariables(), "Lookup variables must be part of output symbols", new Object[0]);
            this.checkDependencies(node.getAssignments().keySet(), node.getOutputVariables(), "Assignments must contain mappings for output symbols", new Object[0]);
            return null;
        }

        public Void visitTableScan(TableScanNode node, Set<VariableReferenceExpression> boundVariables) {
            return null;
        }

        public Void visitValues(ValuesNode node, Set<VariableReferenceExpression> boundVariables) {
            Set<VariableReferenceExpression> correlatedDependencies = VariablesExtractor.extractUnique((PlanNode)node, this.types);
            this.checkDependencies(boundVariables, correlatedDependencies, "Invalid node. Expression correlated dependencies (%s) not satisfied by (%s)", correlatedDependencies, boundVariables);
            return null;
        }

        @Override
        public Void visitUnnest(UnnestNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            ImmutableSet required = ImmutableSet.builder().addAll(node.getReplicateVariables()).addAll(node.getUnnestVariables().keySet()).build();
            this.checkDependencies(source.getOutputVariables(), (Collection<VariableReferenceExpression>)required, "Invalid node. Dependencies (%s) not in source plan output (%s)", required, source.getOutputVariables());
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Set<VariableReferenceExpression> boundVariables) {
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Set<VariableReferenceExpression> boundVariables) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                this.checkDependencies(subplan.getOutputVariables(), (Collection<VariableReferenceExpression>)node.getInputs().get(i), "EXCHANGE subplan must provide all of the necessary symbols", new Object[0]);
                subplan.accept((PlanVisitor)this, boundVariables);
            }
            this.checkDependencies(node.getOutputVariables(), node.getPartitioningScheme().getOutputLayout(), "EXCHANGE must provide all of the necessary symbols for partition function", new Object[0]);
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            return null;
        }

        @Override
        public Void visitTableWriteMerge(TableWriterMergeNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            return null;
        }

        @Override
        public Void visitDelete(DeleteNode node, Set<VariableReferenceExpression> boundVariables) {
            PlanNode source = node.getSource();
            source.accept((PlanVisitor)this, boundVariables);
            Preconditions.checkArgument((boolean)source.getOutputVariables().contains(node.getRowId()), (String)"Invalid node. Row ID symbol (%s) is not in source plan output (%s)", (Object)node.getRowId(), (Object)node.getSource().getOutputVariables());
            return null;
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Set<VariableReferenceExpression> boundVariables) {
            return null;
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getSource().accept((PlanVisitor)this, boundVariables);
            StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor = node.getDescriptor();
            ImmutableSet dependencies = ImmutableSet.builder().addAll(descriptor.getGrouping().values()).addAll(descriptor.getColumnStatistics().values()).addAll(descriptor.getTableStatistics().values()).build();
            List outputVariables = node.getSource().getOutputVariables();
            this.checkDependencies((Collection<VariableReferenceExpression>)dependencies, (Collection<VariableReferenceExpression>)dependencies, "Invalid node. Dependencies (%s) not in source plan output (%s)", dependencies, outputVariables);
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getSource().accept((PlanVisitor)this, boundVariables);
            return null;
        }

        public Void visitUnion(UnionNode node, Set<VariableReferenceExpression> boundVariables) {
            return this.visitSetOperation((SetOperationNode)node, boundVariables);
        }

        private Void visitSetOperation(SetOperationNode node, Set<VariableReferenceExpression> boundVariables) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = (PlanNode)node.getSources().get(i);
                this.checkDependencies(subplan.getOutputVariables(), node.sourceOutputLayout(i), "%s subplan must provide all of the necessary symbols", node.getClass().getSimpleName());
                subplan.accept((PlanVisitor)this, boundVariables);
            }
            return null;
        }

        public Void visitIntersect(IntersectNode node, Set<VariableReferenceExpression> boundVariables) {
            return this.visitSetOperation((SetOperationNode)node, boundVariables);
        }

        public Void visitExcept(ExceptNode node, Set<VariableReferenceExpression> boundVariables) {
            return this.visitSetOperation((SetOperationNode)node, boundVariables);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Set<VariableReferenceExpression> boundVariables) {
            node.getSource().accept((PlanVisitor)this, boundVariables);
            return null;
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Set<VariableReferenceExpression> boundVariables) {
            node.getSource().accept((PlanVisitor)this, boundVariables);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Set<VariableReferenceExpression> boundVariables) {
            ImmutableSet subqueryCorrelation = ImmutableSet.builder().addAll(boundVariables).addAll(node.getCorrelation()).build();
            node.getInput().accept((PlanVisitor)this, boundVariables);
            node.getSubquery().accept((PlanVisitor)this, (Object)subqueryCorrelation);
            this.checkDependencies(node.getInput().getOutputVariables(), node.getCorrelation(), "APPLY input must provide all the necessary correlation variables for subquery", new Object[0]);
            this.checkDependencies(VariablesExtractor.extractUnique(node.getSubquery(), this.types), node.getCorrelation(), "not all APPLY correlation symbols are used in subquery", new Object[0]);
            ImmutableSet inputs = ImmutableSet.builder().addAll(Visitor.createInputs(node.getSubquery(), boundVariables)).addAll(Visitor.createInputs(node.getInput(), boundVariables)).build();
            for (RowExpression expression : node.getSubqueryAssignments().getExpressions()) {
                Set<VariableReferenceExpression> dependencies = OriginalExpressionUtils.isExpression(expression) ? VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(expression), this.types) : VariablesExtractor.extractUnique(expression);
                this.checkDependencies((Collection<VariableReferenceExpression>)inputs, dependencies, "Invalid node. Expression dependencies (%s) not in source plan output (%s)", dependencies, inputs);
            }
            return null;
        }

        @Override
        public Void visitLateralJoin(LateralJoinNode node, Set<VariableReferenceExpression> boundVariables) {
            ImmutableSet subqueryCorrelation = ImmutableSet.builder().addAll(boundVariables).addAll(node.getCorrelation()).build();
            node.getInput().accept((PlanVisitor)this, boundVariables);
            node.getSubquery().accept((PlanVisitor)this, (Object)subqueryCorrelation);
            this.checkDependencies(node.getInput().getOutputVariables(), node.getCorrelation(), "LATERAL input must provide all the necessary correlation symbols for subquery", new Object[0]);
            this.checkDependencies(VariablesExtractor.extractUnique(node.getSubquery(), this.types), node.getCorrelation(), "not all LATERAL correlation symbols are used in subquery", new Object[0]);
            return null;
        }

        private static ImmutableSet<VariableReferenceExpression> createInputs(PlanNode source, Set<VariableReferenceExpression> boundVariables) {
            return ImmutableSet.builder().addAll((Iterable)source.getOutputVariables()).addAll(boundVariables).build();
        }

        private void checkDependencies(Collection<VariableReferenceExpression> inputs, Collection<VariableReferenceExpression> required, String message, Object ... parameters) {
            Preconditions.checkArgument((boolean)ImmutableSet.copyOf(inputs).containsAll(required), (String)message, (Object[])parameters);
        }

        private /* synthetic */ void lambda$visitJoin$1(Set allInputs, RowExpression predicate) {
            Set predicateVariables = OriginalExpressionUtils.isExpression(predicate) ? (Set)VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(predicate), this.types).stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet()) : (Set)VariablesExtractor.extractUnique(predicate).stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((boolean)((ImmutableSet)allInputs.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())).containsAll((Collection)predicateVariables), (String)"Symbol from filter (%s) not in sources (%s)", (Object)predicateVariables, (Object)allInputs);
        }
    }
}

