/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.sanity.CheckUnsupportedExternalFunctions;
import com.facebook.presto.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import com.facebook.presto.sql.planner.sanity.NoIdentifierLeftChecker;
import com.facebook.presto.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import com.facebook.presto.sql.planner.sanity.ValidateDependenciesChecker;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyNoFilteredAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyNoOriginalExpression;
import com.facebook.presto.sql.planner.sanity.VerifyOnlyOneOutputNode;
import com.facebook.presto.sql.planner.sanity.VerifyProjectionLocality;
import com.facebook.presto.sql.planner.sanity.WarnOnScanWithoutPartitionPredicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import javax.inject.Inject;

public final class PlanChecker {
    private final Multimap<Stage, Checker> checkers;

    @Inject
    public PlanChecker(FeaturesConfig featuresConfig) {
        this(featuresConfig, false);
    }

    public PlanChecker(FeaturesConfig featuresConfig, boolean forceSingleNode) {
        this.checkers = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FRAGMENT, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyNoFilteredAggregations(), new VerifyNoOriginalExpression()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new CheckUnsupportedExternalFunctions(), new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new ValidateAggregationsWithDefaultValues(forceSingleNode), new ValidateStreamingAggregations(), new VerifyNoOriginalExpression(), new VerifyProjectionLocality(), new WarnOnScanWithoutPartitionPredicate(featuresConfig)}).build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types, warningCollector));
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types, warningCollector));
    }

    public void validatePlanFragment(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FRAGMENT).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types, warningCollector));
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL,
        FRAGMENT;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, SqlParser var4, TypeProvider var5, WarningCollector var6);
    }
}

