/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ExternalCallExpressionChecker;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class CheckUnsupportedExternalFunctions
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(metadata.getFunctionManager()), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final ExternalCallExpressionChecker externalCallExpressionChecker;

        Visitor(FunctionManager functionManager) {
            this.externalCallExpressionChecker = new ExternalCallExpressionChecker(Objects.requireNonNull(functionManager, "functionManager is null"));
        }

        public Void visitFilter(FilterNode node, Void context) {
            Preconditions.checkState(((Boolean)node.getPredicate().accept((RowExpressionVisitor)this.externalCallExpressionChecker, null) == false ? 1 : 0) != 0, (String)"Expect FilterNode predicate with external functions be converted to project: %s", (Object)node.getPredicate());
            node.getSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            Preconditions.checkState((boolean)node.getAggregations().values().stream().noneMatch(aggregation -> aggregation.getFilter().isPresent() || (Boolean)aggregation.getCall().accept((RowExpressionVisitor)this.externalCallExpressionChecker, null) != false), (Object)"Expect aggregation to be local");
            node.getSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            if (node.getFilter().isPresent() && ((Boolean)node.getFilter().get().accept((RowExpressionVisitor)this.externalCallExpressionChecker, null)).booleanValue()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("External function in join filter is not supported: %s", node.getFilter().get()));
            }
            node.getSources().forEach(child -> {
                Void cfr_ignored_0 = (Void)child.accept((PlanVisitor)this, (Object)context);
            });
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            throw new IllegalStateException("Do not expect ApplyNode");
        }

        @Override
        public Void visitLateralJoin(LateralJoinNode node, Void context) {
            throw new IllegalStateException("Do not expect ApplyNode");
        }
    }
}

