/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RowExpressionEqualityInference;
import com.facebook.presto.sql.planner.RowExpressionPredicateExtractor;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.ExpressionEquivalence;
import com.facebook.presto.sql.planner.optimizations.ExternalCallExpressionChecker;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RowExpressionPredicatePushDown
implements PlanOptimizer {
    private final Metadata metadata;
    private final RowExpressionPredicateExtractor effectivePredicateExtractor;
    private final SqlParser sqlParser;

    public RowExpressionPredicatePushDown(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.effectivePredicateExtractor = new RowExpressionPredicateExtractor(new RowExpressionDomainTranslator(metadata), metadata.getFunctionManager(), metadata.getTypeManager());
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(variableAllocator, idAllocator, this.metadata, this.effectivePredicateExtractor, this.sqlParser, session), plan, LogicalRowExpressions.TRUE_CONSTANT);
    }

    private static class Rewriter
    extends SimplePlanRewriter<RowExpression> {
        private final PlanVariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final RowExpressionPredicateExtractor effectivePredicateExtractor;
        private final Session session;
        private final ExpressionEquivalence expressionEquivalence;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final LogicalRowExpressions logicalRowExpressions;
        private final TypeManager typeManager;
        private final FunctionManager functionManager;
        private final ExternalCallExpressionChecker externalCallExpressionChecker;

        private Rewriter(PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, RowExpressionPredicateExtractor effectivePredicateExtractor, SqlParser sqlParser, Session session) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.effectivePredicateExtractor = Objects.requireNonNull(effectivePredicateExtractor, "effectivePredicateExtractor is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.expressionEquivalence = new ExpressionEquivalence(metadata, sqlParser);
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata);
            this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)this.determinismEvaluator, (StandardFunctionResolution)new FunctionResolution(metadata.getFunctionManager()), (FunctionMetadataManager)metadata.getFunctionManager());
            this.typeManager = metadata.getTypeManager();
            this.functionManager = metadata.getFunctionManager();
            this.externalCallExpressionChecker = new ExternalCallExpressionChecker(this.functionManager);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            if (!context.get().equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, context.get());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                HashMap<VariableReferenceExpression, VariableReferenceExpression> outputsToInputs = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                for (int index = 0; index < node.getInputs().get(i).size(); ++index) {
                    outputsToInputs.put(node.getOutputVariables().get(index), node.getInputs().get(i).get(index));
                }
                RowExpression sourcePredicate = RowExpressionVariableInliner.inlineVariables(outputsToInputs, context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new ExchangeNode(node.getId(), node.getType(), node.getScope(), node.getPartitioningScheme(), (List<PlanNode>)builder.build(), node.getInputs(), node.isEnsureSourceOrdering(), node.getOrderingScheme());
            }
            return node;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            Predicate<RowExpression> isSupported = conjunct -> {
                if (!this.determinismEvaluator.isDeterministic((RowExpression)conjunct)) return false;
                if (!VariablesExtractor.extractUnique(conjunct).stream().allMatch(node.getPartitionBy()::contains)) return false;
                return true;
            };
            Map<Boolean, List<RowExpression>> conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)context.get()).stream().collect(Collectors.partitioningBy(isSupported));
            PlanNode rewrittenNode = context.defaultRewrite(node, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            Set deterministicVariables = node.getAssignments().entrySet().stream().filter(entry -> this.determinismEvaluator.isDeterministic((RowExpression)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<RowExpression> deterministic = conjunct -> deterministicVariables.containsAll(VariablesExtractor.extractUnique(conjunct));
            Map<Boolean, List<RowExpression>> conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            List<RowExpression> deterministicConjuncts = conjuncts.get(true);
            Map<Boolean, List<RowExpression>> inlineConjuncts = deterministicConjuncts.stream().collect(Collectors.partitioningBy(expression -> this.isInliningCandidate((RowExpression)expression, node)));
            List inlinedDeterministicConjuncts = inlineConjuncts.get(true).stream().map(entry -> RowExpressionVariableInliner.inlineVariables(node.getAssignments().getMap(), entry)).collect(Collectors.toList());
            PlanNode rewrittenNode = context.defaultRewrite((PlanNode)node, this.logicalRowExpressions.combineConjuncts(inlinedDeterministicConjuncts));
            List<RowExpression> nonInliningConjuncts = inlineConjuncts.get(false);
            nonInliningConjuncts.addAll((Collection<RowExpression>)conjuncts.get(false));
            if (!nonInliningConjuncts.isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, this.logicalRowExpressions.combineConjuncts(nonInliningConjuncts));
            }
            return rewrittenNode;
        }

        private boolean isInliningCandidate(RowExpression expression, ProjectNode node) {
            FunctionResolution functionResolution = new FunctionResolution(this.functionManager);
            Verify.verify((boolean)Expressions.uniqueSubExpressions(expression).stream().noneMatch(subExpression -> subExpression instanceof CallExpression && functionResolution.isTryFunction(((CallExpression)subExpression).getFunctionHandle())));
            ImmutableSet childOutputSet = ImmutableSet.copyOf((Collection)node.getOutputVariables());
            Map dependencies = VariablesExtractor.extractAll(expression).stream().filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return dependencies.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 1L && (Boolean)node.getAssignments().get((VariableReferenceExpression)entry.getKey()).accept((RowExpressionVisitor)new ExternalCallExpressionChecker(this.functionManager), null) == false || node.getAssignments().get((VariableReferenceExpression)entry.getKey()) instanceof ConstantExpression);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            Map<VariableReferenceExpression, VariableReferenceExpression> commonGroupingVariableMapping = node.getGroupingColumns().entrySet().stream().filter(entry -> node.getCommonGroupingColumns().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Predicate<RowExpression> pushdownEligiblePredicate = conjunct -> VariablesExtractor.extractUnique(conjunct).stream().allMatch(commonGroupingVariableMapping.keySet()::contains);
            Map<Boolean, List<RowExpression>> conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)context.get()).stream().collect(Collectors.partitioningBy(pushdownEligiblePredicate));
            PlanNode rewrittenNode = context.defaultRewrite(node, RowExpressionVariableInliner.inlineVariables(commonGroupingVariableMapping, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            ImmutableSet pushDownableVariables = ImmutableSet.copyOf((Collection)node.getDistinctVariables());
            Map<Boolean, List<RowExpression>> conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)context.get()).stream().collect(Collectors.partitioningBy(arg_0 -> Rewriter.lambda$visitMarkDistinct$9((Set)pushDownableVariables, arg_0)));
            PlanNode rewrittenNode = context.defaultRewrite((PlanNode)node, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, this.logicalRowExpressions.combineConjuncts((Collection)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                RowExpression sourcePredicate = RowExpressionVariableInliner.inlineVariables(node.sourceVariableMap(i), context.get());
                PlanNode source = (PlanNode)node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List)builder.build(), node.getOutputVariables(), node.getVariableMapping());
            }
            return node;
        }

        @Deprecated
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            PlanNode rewrittenPlan = context.rewrite(node.getSource(), this.logicalRowExpressions.combineConjuncts(new RowExpression[]{node.getPredicate(), context.get()}));
            if (!(rewrittenPlan instanceof FilterNode)) {
                return rewrittenPlan;
            }
            FilterNode rewrittenFilterNode = (FilterNode)rewrittenPlan;
            if (!this.areExpressionsEquivalent(rewrittenFilterNode.getPredicate(), node.getPredicate()) || node.getSource() != rewrittenFilterNode.getSource()) {
                return rewrittenPlan;
            }
            return node;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            boolean filtersEquivalent;
            RowExpression newJoinPredicate;
            RowExpression postJoinPredicate;
            ConstantExpression rightPredicate;
            ConstantExpression leftPredicate;
            RowExpression inheritedPredicate = context.get();
            node = this.tryNormalizeToOuterToInnerJoin(node, inheritedPredicate);
            RowExpression leftEffectivePredicate = this.effectivePredicateExtractor.extract(node.getLeft());
            RowExpression rightEffectivePredicate = this.effectivePredicateExtractor.extract(node.getRight());
            RowExpression joinPredicate = this.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputVariables());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = rightOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case FULL: {
                    leftPredicate = LogicalRowExpressions.TRUE_CONSTANT;
                    rightPredicate = LogicalRowExpressions.TRUE_CONSTANT;
                    postJoinPredicate = inheritedPredicate;
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            if (newJoinPredicate.equals((Object)LogicalRowExpressions.FALSE_CONSTANT)) {
                newJoinPredicate = Rewriter.buildEqualsExpression(this.functionManager, (RowExpression)Expressions.constant(0L, (Type)BigintType.BIGINT), (RowExpression)Expressions.constant(1L, (Type)BigintType.BIGINT));
            }
            PlanNode leftSource = context.rewrite(node.getLeft(), (RowExpression)leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), (RowExpression)rightPredicate);
            JoinNode output = node;
            Assignments.Builder leftProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignments(node.getLeft().getOutputVariables()));
            Assignments.Builder rightProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignments(node.getRight().getOutputVariables()));
            ProjectNode.Locality leftLocality = ProjectNode.Locality.LOCAL;
            ProjectNode.Locality rightLocality = ProjectNode.Locality.LOCAL;
            ArrayList<JoinNode.EquiJoinClause> equiJoinClauses = new ArrayList<JoinNode.EquiJoinClause>();
            ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)newJoinPredicate)) {
                if (this.joinEqualityExpression(node.getLeft().getOutputVariables()).test(conjunct)) {
                    boolean alignedComparison = Iterables.all(VariablesExtractor.extractUnique(Rewriter.getLeft(conjunct)), (com.google.common.base.Predicate)Predicates.in((Collection)node.getLeft().getOutputVariables()));
                    RowExpression leftExpression = alignedComparison ? Rewriter.getLeft(conjunct) : Rewriter.getRight(conjunct);
                    RowExpression rightExpression = alignedComparison ? Rewriter.getRight(conjunct) : Rewriter.getLeft(conjunct);
                    VariableReferenceExpression leftVariable = this.variableForExpression(leftExpression);
                    if (!node.getLeft().getOutputVariables().contains(leftVariable)) {
                        leftProjections.put(leftVariable, leftExpression);
                        if (((Boolean)leftExpression.accept((RowExpressionVisitor)this.externalCallExpressionChecker, null)).booleanValue()) {
                            leftLocality = ProjectNode.Locality.REMOTE;
                        }
                    }
                    VariableReferenceExpression rightVariable = this.variableForExpression(rightExpression);
                    if (!node.getRight().getOutputVariables().contains(rightVariable)) {
                        rightProjections.put(rightVariable, rightExpression);
                        if (((Boolean)rightExpression.accept((RowExpressionVisitor)this.externalCallExpressionChecker, null)).booleanValue()) {
                            rightLocality = ProjectNode.Locality.REMOTE;
                        }
                    }
                    equiJoinClauses.add(new JoinNode.EquiJoinClause(leftVariable, rightVariable));
                    continue;
                }
                joinFilterBuilder.add((Object)conjunct);
            }
            Optional<Object> newJoinFilter = Optional.of(this.logicalRowExpressions.combineConjuncts((Collection)joinFilterBuilder.build()));
            if (newJoinFilter.get() == LogicalRowExpressions.TRUE_CONSTANT) {
                newJoinFilter = Optional.empty();
            }
            if (node.getType() == JoinNode.Type.INNER && newJoinFilter.isPresent() && equiJoinClauses.isEmpty()) {
                postJoinPredicate = this.logicalRowExpressions.combineConjuncts(new RowExpression[]{postJoinPredicate, (RowExpression)newJoinFilter.get()});
                newJoinFilter = Optional.empty();
            }
            boolean bl = filtersEquivalent = newJoinFilter.isPresent() == node.getFilter().isPresent() && (!newJoinFilter.isPresent() || this.areExpressionsEquivalent((RowExpression)newJoinFilter.get(), node.getFilter().get()));
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !filtersEquivalent || !ImmutableSet.copyOf(equiJoinClauses).equals((Object)ImmutableSet.copyOf(node.getCriteria()))) {
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build(), leftLocality);
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build(), rightLocality);
                Optional<JoinNode.DistributionType> distributionType = node.getDistributionType();
                if (node.getDistributionType().isPresent()) {
                    if (node.getType().mustPartition()) {
                        distributionType = Optional.of(JoinNode.DistributionType.PARTITIONED);
                    }
                    if (node.getType().mustReplicate(equiJoinClauses)) {
                        distributionType = Optional.of(JoinNode.DistributionType.REPLICATED);
                    }
                }
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, equiJoinClauses, (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftSource.getOutputVariables()).addAll((Iterable)rightSource.getOutputVariables()).build(), newJoinFilter, node.getLeftHashVariable(), node.getRightHashVariable(), distributionType);
            }
            if (!postJoinPredicate.equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, postJoinPredicate);
            }
            if (!node.getOutputVariables().equals(output.getOutputVariables())) {
                output = new ProjectNode(this.idAllocator.getNextId(), (PlanNode)output, AssignmentUtils.identityAssignments(node.getOutputVariables()), ProjectNode.Locality.LOCAL);
            }
            return output;
        }

        private static RowExpression getLeft(RowExpression expression) {
            Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
            return (RowExpression)((CallExpression)expression).getArguments().get(0);
        }

        private static RowExpression getRight(RowExpression expression) {
            Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
            return (RowExpression)((CallExpression)expression).getArguments().get(1);
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression newJoinPredicate;
            RowExpression postJoinPredicate;
            RowExpression rightPredicate;
            RowExpression leftPredicate;
            RowExpression inheritedPredicate = context.get();
            if (node.getType() == SpatialJoinNode.Type.LEFT && this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate)) {
                node = new SpatialJoinNode(node.getId(), SpatialJoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getOutputVariables(), node.getFilter(), node.getLeftPartitionVariable(), node.getRightPartitionVariable(), node.getKdbTree());
            }
            RowExpression leftEffectivePredicate = this.effectivePredicateExtractor.extract(node.getLeft());
            RowExpression rightEffectivePredicate = this.effectivePredicateExtractor.extract(node.getRight());
            RowExpression joinPredicate = node.getFilter();
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Verify.verify((!newJoinPredicate.equals((Object)LogicalRowExpressions.FALSE_CONSTANT) ? 1 : 0) != 0, (String)"Spatial join predicate is missing", (Object[])new Object[0]);
            PlanNode leftSource = context.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), rightPredicate);
            SpatialJoinNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !this.areExpressionsEquivalent(newJoinPredicate, joinPredicate)) {
                Assignments.Builder leftProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignments(node.getLeft().getOutputVariables()));
                Assignments.Builder rightProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignments(node.getRight().getOutputVariables()));
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build(), ProjectNode.Locality.LOCAL);
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build(), ProjectNode.Locality.LOCAL);
                output = new SpatialJoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getOutputVariables(), newJoinPredicate, node.getLeftPartitionVariable(), node.getRightPartitionVariable(), node.getKdbTree());
            }
            if (!postJoinPredicate.equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, postJoinPredicate);
            }
            return output;
        }

        private VariableReferenceExpression variableForExpression(RowExpression expression) {
            if (expression instanceof VariableReferenceExpression) {
                return (VariableReferenceExpression)expression;
            }
            return this.variableAllocator.newVariable(expression);
        }

        private OuterJoinPushDownResult processLimitedOuterJoin(RowExpression inheritedPredicate, RowExpression outerEffectivePredicate, RowExpression innerEffectivePredicate, RowExpression joinPredicate, Collection<VariableReferenceExpression> outerVariables) {
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(outerEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(outerVariables)), (Object)"outerEffectivePredicate must only contain variables from outerVariables");
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(innerEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables))), (Object)"innerEffectivePredicate must not contain variables from outerVariables");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            postJoinConjuncts.addAll(Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic)));
            inheritedPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(innerEffectivePredicate);
            joinConjuncts.addAll(Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)joinPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic)));
            joinPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(joinPredicate);
            RowExpressionEqualityInference inheritedInference = this.createEqualityInference(inheritedPredicate);
            RowExpressionEqualityInference outerInference = this.createEqualityInference(inheritedPredicate, outerEffectivePredicate);
            RowExpressionEqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(outerVariables));
            RowExpression outerOnlyInheritedEqualities = this.logicalRowExpressions.combineConjuncts(equalityPartition.getScopeEqualities());
            RowExpressionEqualityInference potentialNullSymbolInference = this.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            for (RowExpression conjunct : this.nonInferrableConjuncts(inheritedPredicate)) {
                RowExpression outerRewritten = outerInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(outerVariables));
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    RowExpression innerRewritten = potentialNullSymbolInference.rewriteExpression(outerRewritten, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)));
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            for (RowExpression conjunct : this.nonInferrableConjuncts(outerEffectivePredicate)) {
                RowExpression rewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)));
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            for (RowExpression conjunct : this.nonInferrableConjuncts(joinPredicate)) {
                RowExpression innerRewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)));
                if (innerRewritten != null) {
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                joinConjuncts.add((Object)conjunct);
            }
            RowExpressionEqualityInference potentialNullSymbolInferenceWithoutInnerInferred = this.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables))).getScopeEqualities());
            RowExpressionEqualityInference.EqualityPartition joinEqualityPartition = this.createEqualityInference(joinPredicate).generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)));
            innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
            joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
            return new OuterJoinPushDownResult(this.logicalRowExpressions.combineConjuncts((Collection)outerPushdownConjuncts.build()), this.logicalRowExpressions.combineConjuncts((Collection)innerPushdownConjuncts.build()), this.logicalRowExpressions.combineConjuncts((Collection)joinConjuncts.build()), this.logicalRowExpressions.combineConjuncts((Collection)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(RowExpression inheritedPredicate, RowExpression leftEffectivePredicate, RowExpression rightEffectivePredicate, RowExpression joinPredicate, Collection<VariableReferenceExpression> leftVariables) {
            RowExpression rewritten;
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(leftEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(leftVariables)), (Object)"leftEffectivePredicate must only contain variables from leftVariables");
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(rightEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables))), (Object)"rightEffectivePredicate must not contain variables from leftVariables");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            joinConjuncts.addAll(Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic)));
            inheritedPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(inheritedPredicate);
            joinConjuncts.addAll(Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)joinPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic)));
            joinPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(joinPredicate);
            leftEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(leftEffectivePredicate);
            rightEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(rightEffectivePredicate);
            RowExpressionEqualityInference allInference = new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).addEqualityInference(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate).build();
            RowExpressionEqualityInference allInferenceWithoutLeftInferred = new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).addEqualityInference(inheritedPredicate, rightEffectivePredicate, joinPredicate).build();
            RowExpressionEqualityInference allInferenceWithoutRightInferred = new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).addEqualityInference(inheritedPredicate, leftEffectivePredicate, joinPredicate).build();
            for (RowExpression conjunct : new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(inheritedPredicate)) {
                RowExpression rightRewrittenConjunct;
                RowExpression leftRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables));
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (RowExpression conjunct : new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(rightEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables));
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (RowExpression conjunct : new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(leftEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)));
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (RowExpression conjunct : new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(joinPredicate)) {
                RowExpression rightRewritten;
                RowExpression leftRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables));
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables)).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables))).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in(leftVariables)).apply(arg_0))).getScopeStraddlingEqualities());
            return new InnerJoinPushDownResult(this.logicalRowExpressions.combineConjuncts((Collection)leftPushDownConjuncts.build()), this.logicalRowExpressions.combineConjuncts((Collection)rightPushDownConjuncts.build()), this.logicalRowExpressions.combineConjuncts((Collection)joinConjuncts.build()), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        }

        private RowExpression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)this.toRowExpression(equiJoinClause));
            }
            joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return this.logicalRowExpressions.combineConjuncts((Collection)builder.build());
        }

        private RowExpression toRowExpression(JoinNode.EquiJoinClause equiJoinClause) {
            return Rewriter.buildEqualsExpression(this.functionManager, (RowExpression)equiJoinClause.getLeft(), (RowExpression)equiJoinClause.getRight());
        }

        private JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, RowExpression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.FULL).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object)((Object)node.getType()));
            if (node.getType() == JoinNode.Type.INNER) {
                return node;
            }
            if (node.getType() == JoinNode.Type.FULL) {
                boolean canConvertToLeftJoin = this.canConvertOuterToInner(node.getLeft().getOutputVariables(), inheritedPredicate);
                boolean canConvertToRightJoin = this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate);
                if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                    return node;
                }
                if (canConvertToLeftJoin && canConvertToRightJoin) {
                    return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
                }
                return new JoinNode(node.getId(), canConvertToLeftJoin ? JoinNode.Type.LEFT : JoinNode.Type.RIGHT, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
            }
            if (node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputVariables(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
        }

        private boolean canConvertOuterToInner(List<VariableReferenceExpression> innerVariablesForOuterJoin, RowExpression inheritedPredicate) {
            ImmutableSet innerVariables = ImmutableSet.copyOf(innerVariablesForOuterJoin);
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate)) {
                RowExpression response;
                if (!this.determinismEvaluator.isDeterministic(conjunct) || (response = this.nullInputEvaluator((Collection<VariableReferenceExpression>)innerVariables, conjunct)) != null && !Expressions.isNull(response) && !LogicalRowExpressions.FALSE_CONSTANT.equals((Object)response)) continue;
                return true;
            }
            return false;
        }

        private RowExpression simplifyExpression(RowExpression expression) {
            return new RowExpressionOptimizer(this.metadata).optimize(expression, ExpressionOptimizer.Level.SERIALIZABLE, this.session.toConnectorSession());
        }

        private boolean areExpressionsEquivalent(RowExpression leftExpression, RowExpression rightExpression) {
            return this.expressionEquivalence.areExpressionsEquivalent(this.simplifyExpression(leftExpression), this.simplifyExpression(rightExpression));
        }

        private RowExpression nullInputEvaluator(Collection<VariableReferenceExpression> nullSymbols, RowExpression expression) {
            expression = RowExpressionNodeInliner.replaceExpression((RowExpression)expression, nullSymbols.stream().collect(Collectors.toMap(Function.identity(), variable -> Expressions.constantNull(variable.getType()))));
            return new RowExpressionOptimizer(this.metadata).optimize(expression, ExpressionOptimizer.Level.OPTIMIZED, this.session.toConnectorSession());
        }

        private Predicate<RowExpression> joinEqualityExpression(Collection<VariableReferenceExpression> leftVariables) {
            return expression -> {
                if (this.determinismEvaluator.isDeterministic((RowExpression)expression) && this.isOperation((RowExpression)expression, OperatorType.EQUAL)) {
                    Set<VariableReferenceExpression> variables1 = VariablesExtractor.extractUnique(Rewriter.getLeft(expression));
                    Set<VariableReferenceExpression> variables2 = VariablesExtractor.extractUnique(Rewriter.getRight(expression));
                    if (variables1.isEmpty() || variables2.isEmpty()) {
                        return false;
                    }
                    return Iterables.all(variables1, (com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)) && Iterables.all(variables2, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftVariables))) || Iterables.all(variables2, (com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)) && Iterables.all(variables1, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)));
                }
                return false;
            };
        }

        private boolean isOperation(RowExpression expression, OperatorType type) {
            Optional operatorType;
            if (expression instanceof CallExpression && (operatorType = this.functionManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getOperatorType()).isPresent()) {
                return ((OperatorType)operatorType.get()).equals((Object)type);
            }
            return false;
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression inheritedPredicate = context.get();
            if (!LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate).contains(node.getSemiJoinOutput())) {
                return this.visitNonFilteringSemiJoin(node, context);
            }
            return this.visitFilteringSemiJoin(node, context);
        }

        private PlanNode visitNonFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression inheritedPredicate = context.get();
            ArrayList<RowExpression> sourceConjuncts = new ArrayList<RowExpression>();
            ArrayList<RowExpression> postJoinConjuncts = new ArrayList<RowExpression>();
            PlanNode rewrittenFilteringSource = context.defaultRewrite(node.getFilteringSource(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            RowExpressionEqualityInference inheritedInference = new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).addEqualityInference(inheritedPredicate).build();
            for (RowExpression conjunct : new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(inheritedPredicate)) {
                RowExpression rewrittenConjunct = inheritedInference.rewriteExpressionAllowNonDeterministic(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)node.getSource().getOutputVariables()));
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            RowExpressionEqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in((Collection)node.getSource().getOutputVariables())).apply(arg_0)));
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), this.logicalRowExpressions.combineConjuncts(sourceConjuncts));
            SemiJoinNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, this.logicalRowExpressions.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        private PlanNode visitFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression rewritten;
            RowExpression rewrittenConjunct;
            RowExpression inheritedPredicate = context.get();
            RowExpression deterministicInheritedPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(inheritedPredicate);
            RowExpression sourceEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(node.getSource()));
            RowExpression filteringSourceEffectivePredicate = this.logicalRowExpressions.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(node.getFilteringSource()));
            CallExpression joinExpression = Rewriter.buildEqualsExpression(this.functionManager, (RowExpression)node.getSourceJoinVariable(), (RowExpression)node.getFilteringSourceJoinVariable());
            List sourceVariables = node.getSource().getOutputVariables();
            List filteringSourceVariables = node.getFilteringSource().getOutputVariables();
            ArrayList<RowExpression> sourceConjuncts = new ArrayList<RowExpression>();
            ArrayList<RowExpression> filteringSourceConjuncts = new ArrayList<RowExpression>();
            ArrayList<RowExpression> postJoinConjuncts = new ArrayList<RowExpression>();
            RowExpressionEqualityInference allInference = this.createEqualityInference(new RowExpression[]{deterministicInheritedPredicate, sourceEffectivePredicate, filteringSourceEffectivePredicate, joinExpression});
            RowExpressionEqualityInference allInferenceWithoutSourceInferred = this.createEqualityInference(new RowExpression[]{deterministicInheritedPredicate, filteringSourceEffectivePredicate, joinExpression});
            RowExpressionEqualityInference allInferenceWithoutFilteringSourceInferred = this.createEqualityInference(new RowExpression[]{deterministicInheritedPredicate, sourceEffectivePredicate, joinExpression});
            for (RowExpression conjunct : this.nonInferrableConjuncts(inheritedPredicate)) {
                rewrittenConjunct = allInference.rewriteExpressionAllowNonDeterministic(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables));
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            for (RowExpression conjunct : this.nonInferrableConjuncts(deterministicInheritedPredicate)) {
                rewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables));
                if (rewrittenConjunct == null) continue;
                filteringSourceConjuncts.add(rewrittenConjunct);
            }
            for (RowExpression conjunct : this.nonInferrableConjuncts(filteringSourceEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables));
                if (rewritten == null) continue;
                sourceConjuncts.add(rewritten);
            }
            for (RowExpression conjunct : this.nonInferrableConjuncts(sourceEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables));
                if (rewritten == null) continue;
                filteringSourceConjuncts.add(rewritten);
            }
            sourceConjuncts.addAll(allInferenceWithoutSourceInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables)).getScopeEqualities());
            filteringSourceConjuncts.addAll(allInferenceWithoutFilteringSourceInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables)).getScopeEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), this.logicalRowExpressions.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), this.logicalRowExpressions.combineConjuncts(filteringSourceConjuncts));
            SemiJoinNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, this.logicalRowExpressions.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        private Iterable<RowExpression> nonInferrableConjuncts(RowExpression inheritedPredicate) {
            return new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).nonInferrableConjuncts(inheritedPredicate);
        }

        private RowExpressionEqualityInference createEqualityInference(RowExpression ... expressions) {
            return new RowExpressionEqualityInference.Builder(this.functionManager, this.typeManager).addEqualityInference(expressions).build();
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            if (node.hasEmptyGroupingSet()) {
                return this.visitPlan((PlanNode)node, context);
            }
            RowExpression inheritedPredicate = context.get();
            RowExpressionEqualityInference equalityInference = this.createEqualityInference(inheritedPredicate);
            ArrayList<RowExpression> pushdownConjuncts = new ArrayList<RowExpression>();
            ArrayList<RowExpression> postAggregationConjuncts = new ArrayList<RowExpression>();
            List groupingKeyVariables = node.getGroupingKeys();
            postAggregationConjuncts.addAll((Collection<RowExpression>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic))));
            inheritedPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(inheritedPredicate);
            for (RowExpression conjunct : this.nonInferrableConjuncts(inheritedPredicate)) {
                if (node.getGroupIdVariable().isPresent() && VariablesExtractor.extractUnique(conjunct).contains(node.getGroupIdVariable().get())) {
                    postAggregationConjuncts.add(conjunct);
                    continue;
                }
                RowExpression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)groupingKeyVariables));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            RowExpressionEqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in((Collection)groupingKeyVariables)).apply(arg_0)));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), this.logicalRowExpressions.combineConjuncts(pushdownConjuncts));
            AggregationNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getAggregations(), node.getGroupingSets(), (List)ImmutableList.of(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, this.logicalRowExpressions.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression inheritedPredicate = context.get();
            RowExpressionEqualityInference equalityInference = this.createEqualityInference(inheritedPredicate);
            ArrayList<RowExpression> pushdownConjuncts = new ArrayList<RowExpression>();
            ArrayList<RowExpression> postUnnestConjuncts = new ArrayList<RowExpression>();
            postUnnestConjuncts.addAll((Collection<RowExpression>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(this.determinismEvaluator::isDeterministic))));
            inheritedPredicate = this.logicalRowExpressions.filterDeterministicConjuncts(inheritedPredicate);
            for (RowExpression conjunct : this.nonInferrableConjuncts(inheritedPredicate)) {
                RowExpression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(node.getReplicateVariables()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postUnnestConjuncts.add(conjunct);
            }
            RowExpressionEqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in(node.getReplicateVariables())).apply(arg_0)));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), this.logicalRowExpressions.combineConjuncts(pushdownConjuncts));
            UnnestNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateVariables(), node.getUnnestVariables(), node.getOrdinalityVariable());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, this.logicalRowExpressions.combineConjuncts(postUnnestConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            RowExpression predicate = this.simplifyExpression(context.get());
            if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)predicate)) {
                return new FilterNode(this.idAllocator.getNextId(), (PlanNode)node, predicate);
            }
            return node;
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<RowExpression> context) {
            Set<VariableReferenceExpression> predicateVariables = VariablesExtractor.extractUnique(context.get());
            Preconditions.checkState((!predicateVariables.contains(node.getIdVariable()) ? 1 : 0) != 0, (Object)"UniqueId in predicate is not yet supported");
            return context.defaultRewrite(node, context.get());
        }

        private static CallExpression buildEqualsExpression(FunctionManager functionManager, RowExpression left, RowExpression right) {
            return Expressions.call(OperatorType.EQUAL.getFunctionName().getFunctionName(), functionManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(left.getType(), right.getType())), (Type)BooleanType.BOOLEAN, left, right);
        }

        private static /* synthetic */ boolean lambda$visitMarkDistinct$9(Set pushDownableVariables, RowExpression conjunct) {
            return pushDownableVariables.containsAll(VariablesExtractor.extractUnique(conjunct));
        }

        private static class InnerJoinPushDownResult {
            private final RowExpression leftPredicate;
            private final RowExpression rightPredicate;
            private final RowExpression joinPredicate;
            private final RowExpression postJoinPredicate;

            private InnerJoinPushDownResult(RowExpression leftPredicate, RowExpression rightPredicate, RowExpression joinPredicate, RowExpression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private RowExpression getLeftPredicate() {
                return this.leftPredicate;
            }

            private RowExpression getRightPredicate() {
                return this.rightPredicate;
            }

            private RowExpression getJoinPredicate() {
                return this.joinPredicate;
            }

            private RowExpression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final RowExpression outerJoinPredicate;
            private final RowExpression innerJoinPredicate;
            private final RowExpression joinPredicate;
            private final RowExpression postJoinPredicate;

            private OuterJoinPushDownResult(RowExpression outerJoinPredicate, RowExpression innerJoinPredicate, RowExpression joinPredicate, RowExpression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private RowExpression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private RowExpression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            public RowExpression getJoinPredicate() {
                return this.joinPredicate;
            }

            private RowExpression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }
    }
}

