/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushdownSubfields
implements PlanOptimizer {
    private final Metadata metadata;

    public PushdownSubfields(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        if (!SystemSessionProperties.isPushdownSubfieldsEnabled(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Rewriter(session, this.metadata), plan, new Rewriter.Context());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;
        private final Metadata metadata;
        private final StandardFunctionResolution functionResolution;
        private final ExpressionOptimizer expressionOptimizer;
        private final SubfieldExtractor subfieldExtractor;
        private static final QualifiedFunctionName ARBITRARY_AGGREGATE_FUNCTION = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"arbitrary");

        public Rewriter(Session session, Metadata metadata) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.functionResolution = new FunctionResolution(metadata.getFunctionManager());
            this.expressionOptimizer = new RowExpressionOptimizer(metadata);
            this.subfieldExtractor = new SubfieldExtractor(this.functionResolution, this.expressionOptimizer, session.toConnectorSession());
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getGroupingKeys());
            for (Map.Entry entry : node.getAggregations().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
                QualifiedFunctionName aggregateName = this.metadata.getFunctionManager().getFunctionMetadata(aggregation.getCall().getFunctionHandle()).getName();
                if (ARBITRARY_AGGREGATE_FUNCTION.equals((Object)aggregateName)) {
                    Preconditions.checkState((boolean)(aggregation.getArguments().get(0) instanceof VariableReferenceExpression));
                    context.get().addAssignment(variable, (VariableReferenceExpression)aggregation.getArguments().get(0));
                } else {
                    aggregation.getArguments().forEach(expression -> {
                        Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
                    });
                }
                aggregation.getFilter().ifPresent(expression -> {
                    Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
                });
                aggregation.getOrderBy().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
                aggregation.getMask().ifPresent(context.get().variables::add);
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getCorrelation());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSource().getOutputVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getPredicate().accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
                context.get().addAssignment(entry.getKey(), entry.getValue());
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).forEach(context.get().variables::add);
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).forEach(context.get().variables::add);
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).forEach(context.get().variables::add);
            node.getFilter().ifPresent(expression -> {
                Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
            });
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOutputVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                RowExpression expression = (RowExpression)entry.getValue();
                if (expression instanceof VariableReferenceExpression) {
                    context.get().addAssignment(variable, (VariableReferenceExpression)expression);
                    continue;
                }
                Optional<Subfield> subfield = Rewriter.toSubfield(expression, this.functionResolution, this.expressionOptimizer, this.session.toConnectorSession());
                if (subfield.isPresent()) {
                    context.get().addAssignment(variable, subfield.get());
                    continue;
                }
                expression.accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getSourceJoinVariable());
            context.get().variables.add(node.getFilteringSourceJoinVariable());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getFilter().accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (context.get().subfields.isEmpty()) {
                return node;
            }
            ImmutableMap.Builder newAssignments = ImmutableMap.builder();
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                if (context.get().variables.contains(variable)) {
                    newAssignments.put(entry);
                    continue;
                }
                List subfields = context.get().findSubfields(variable.getName());
                Verify.verify((!subfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                String columnName = Rewriter.getColumnName(this.session, this.metadata, node.getTable(), (ColumnHandle)entry.getValue());
                List columnSubfields = (List)subfields.stream().filter(subfield -> !Rewriter.prefixExists(subfield, subfields)).map(Subfield::getPath).map(path -> new Subfield(columnName, path)).collect(ImmutableList.toImmutableList());
                newAssignments.put((Object)variable, (Object)((ColumnHandle)entry.getValue()).withRequiredSubfields(columnSubfields));
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputVariables(), (Map)newAssignments.build(), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getColumns());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getVariableMapping().entrySet()) {
                ((List)entry.getValue()).forEach(variable -> ((Context)context.get()).addAssignment((VariableReferenceExpression)entry.getKey(), variable));
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            ImmutableList.Builder newSubfields = ImmutableList.builder();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : node.getUnnestVariables().entrySet()) {
                List matchingSubfields;
                VariableReferenceExpression container = entry.getKey();
                boolean found = false;
                if (this.isRowType(container) && !SystemSessionProperties.isLegacyUnnest(this.session)) {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            newSubfields.add((Object)new Subfield(container.getName(), (List)ImmutableList.of((Object)Subfield.allSubscripts(), (Object)Rewriter.nestedField(field.getName()))));
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).add((Object)Rewriter.nestedField(field.getName())).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                } else {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            context.get().variables.add(container);
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                }
                if (found) continue;
                context.get().variables.add(container);
            }
            context.get().subfields.addAll(newSubfields.build());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSpecification().getPartitionBy());
            node.getSpecification().getOrderingScheme().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(CallExpression::getArguments).flatMap(Collection::stream).forEach(expression -> {
                Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
            });
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getStartValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getEndValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        private boolean isRowType(VariableReferenceExpression variable) {
            return variable.getType() instanceof ArrayType && ((ArrayType)variable.getType()).getElementType() instanceof RowType;
        }

        private static boolean prefixExists(Subfield subfieldPath, Collection<Subfield> subfieldPaths) {
            return subfieldPaths.stream().anyMatch(path -> path.isPrefix(subfieldPath));
        }

        private static String getColumnName(Session session, Metadata metadata, TableHandle tableHandle, ColumnHandle columnHandle) {
            return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
        }

        private static Optional<Subfield> toSubfield(RowExpression expression, StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
            block7: {
                ImmutableList.Builder elements = ImmutableList.builder();
                while (true) {
                    if (expression instanceof VariableReferenceExpression) {
                        return Optional.of(new Subfield(((VariableReferenceExpression)expression).getName(), (List)elements.build().reverse()));
                    }
                    if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.DEREFERENCE) {
                        SpecialFormExpression dereference = (SpecialFormExpression)expression;
                        RowExpression base = (RowExpression)dereference.getArguments().get(0);
                        RowType baseType = (RowType)base.getType();
                        RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)dereference.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                        if (indexExpression instanceof ConstantExpression) {
                            Optional fieldName;
                            Object index = ((ConstantExpression)indexExpression).getValue();
                            Verify.verify((index != null ? 1 : 0) != 0, (String)"Struct field index cannot be null", (Object[])new Object[0]);
                            if (index instanceof Number && (fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) {
                                elements.add((Object)Rewriter.nestedField((String)fieldName.get()));
                                expression = base;
                                continue;
                            }
                        }
                        return Optional.empty();
                    }
                    if (!(expression instanceof CallExpression) || !functionResolution.isSubscriptFunction(((CallExpression)expression).getFunctionHandle())) break block7;
                    List arguments = ((CallExpression)expression).getArguments();
                    RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)arguments.get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                    if (!(indexExpression instanceof ConstantExpression)) break;
                    Object index = ((ConstantExpression)indexExpression).getValue();
                    if (index == null) {
                        return Optional.empty();
                    }
                    if (index instanceof Number) {
                        elements.add((Object)new Subfield.LongSubscript(((Number)index).longValue()));
                        expression = (RowExpression)arguments.get(0);
                        continue;
                    }
                    if (!Varchars.isVarcharType((Type)indexExpression.getType())) break;
                    elements.add((Object)new Subfield.StringSubscript(((Slice)index).toStringUtf8()));
                    expression = (RowExpression)arguments.get(0);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private static Subfield.NestedField nestedField(String name) {
            return new Subfield.NestedField(name.toLowerCase(Locale.ENGLISH));
        }

        private static final class Context {
            private final Set<VariableReferenceExpression> variables = new HashSet<VariableReferenceExpression>();
            private final Set<Subfield> subfields = new HashSet<Subfield>();

            private Context() {
            }

            private void addAssignment(VariableReferenceExpression variable, VariableReferenceExpression otherVariable) {
                if (this.variables.contains(variable)) {
                    this.variables.add(otherVariable);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(otherVariable.getName(), path)).forEach(this.subfields::add);
            }

            private void addAssignment(VariableReferenceExpression variable, Subfield subfield) {
                if (this.variables.contains(variable)) {
                    this.subfields.add(subfield);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(subfield.getRootName(), (List)ImmutableList.builder().addAll((Iterable)subfield.getPath()).addAll((Iterable)path).build())).forEach(this.subfields::add);
            }

            private List<Subfield> findSubfields(String rootName) {
                return (List)this.subfields.stream().filter(subfield -> rootName.equals(subfield.getRootName())).collect(ImmutableList.toImmutableList());
            }
        }

        private static final class SubfieldExtractor
        extends DefaultRowExpressionTraversalVisitor<Context> {
            private final StandardFunctionResolution functionResolution;
            private final ExpressionOptimizer expressionOptimizer;
            private final ConnectorSession connectorSession;

            private SubfieldExtractor(StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession) {
                this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
                this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimizer is null");
                this.connectorSession = Objects.requireNonNull(connectorSession, "connectorSession is null");
            }

            public Void visitCall(CallExpression call, Context context) {
                if (!this.functionResolution.isSubscriptFunction(call.getFunctionHandle())) {
                    call.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                    return null;
                }
                Optional subfield = Rewriter.toSubfield((RowExpression)call, this.functionResolution, this.expressionOptimizer, this.connectorSession);
                if (subfield.isPresent()) {
                    context.subfields.add(subfield.get());
                } else {
                    call.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                }
                return null;
            }

            public Void visitSpecialForm(SpecialFormExpression specialForm, Context context) {
                if (specialForm.getForm() != SpecialFormExpression.Form.DEREFERENCE) {
                    specialForm.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                    return null;
                }
                Optional subfield = Rewriter.toSubfield((RowExpression)specialForm, this.functionResolution, this.expressionOptimizer, this.connectorSession);
                if (subfield.isPresent()) {
                    context.subfields.add(subfield.get());
                } else {
                    specialForm.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                }
                return null;
            }

            public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
                context.variables.add(reference);
                return null;
            }
        }
    }
}

