/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.ProjectNodeUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

public class RemoveRedundantIdentityProjections
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(ProjectNodeUtils::isIdentity).matching(RemoveRedundantIdentityProjections::outputsSameAsSource);

    private static boolean outputsSameAsSource(ProjectNode node) {
        return ImmutableSet.copyOf((Collection)node.getOutputVariables()).equals((Object)ImmutableSet.copyOf((Collection)node.getSource().getOutputVariables()));
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(project.getSource());
    }
}

