/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.ExpressionVariableInliner;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final FunctionResolution functionResolution;

    public InlineProjections(FunctionManager functionManager) {
        this.functionResolution = new FunctionResolution(functionManager);
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        if (parent.getLocality().equals((Object)ProjectNode.Locality.REMOTE) || child.getLocality().equals((Object)ProjectNode.Locality.REMOTE) || !parent.getLocality().equals((Object)child.getLocality())) {
            return Rule.Result.empty();
        }
        Sets.SetView<VariableReferenceExpression> targets = this.extractInliningTargets(parent, child, context);
        if (targets.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments assignments = child.getAssignments().filter(arg_0 -> targets.contains(arg_0));
        Map<VariableReferenceExpression, RowExpression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.inlineReferences((RowExpression)entry.getValue(), assignments, context.getVariableAllocator().getTypes())));
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(expression -> InlineProjections.extractInputs(expression, context.getVariableAllocator().getTypes()).stream()).collect(Collectors.toSet());
        Assignments.Builder childAssignments = Assignments.builder();
        for (Map.Entry assignment : child.getAssignments().entrySet()) {
            if (targets.contains(assignment.getKey())) continue;
            childAssignments.put(assignment);
        }
        boolean allTranslated = child.getAssignments().entrySet().stream().map(Map.Entry::getValue).noneMatch(OriginalExpressionUtils::isExpression);
        for (VariableReferenceExpression input : inputs) {
            if (allTranslated) {
                childAssignments.put(input, (RowExpression)input);
                continue;
            }
            childAssignments.put(AssignmentUtils.identityAsSymbolReference(input));
        }
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(parent.getId(), (PlanNode)new ProjectNode(child.getId(), child.getSource(), childAssignments.build(), child.getLocality()), Assignments.copyOf(parentAssignments), parent.getLocality()));
    }

    private RowExpression inlineReferences(RowExpression expression, Assignments assignments, TypeProvider types) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            Function<VariableReferenceExpression, Expression> mapping = variable -> {
                if (assignments.get(variable) == null) {
                    return new SymbolReference(variable.getName());
                }
                return OriginalExpressionUtils.castToExpression(assignments.get(variable));
            };
            return OriginalExpressionUtils.castToRowExpression(ExpressionVariableInliner.inlineVariables(mapping, OriginalExpressionUtils.castToExpression(expression), types));
        }
        return RowExpressionVariableInliner.inlineVariables(variable -> (RowExpression)assignments.getMap().getOrDefault(variable, variable), expression);
    }

    private Sets.SetView<VariableReferenceExpression> extractInliningTargets(ProjectNode parent, ProjectNode child, Rule.Context context) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf((Collection)child.getOutputVariables());
        TypeProvider types = context.getVariableAllocator().getTypes();
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> InlineProjections.extractInputs(expression, context.getVariableAllocator().getTypes()).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set constants = dependencies.keySet().stream().filter(input -> InlineProjections.isConstant(child.getAssignments().get(input))).collect(Collectors.toSet());
        Set tryArguments = parent.getAssignments().getExpressions().stream().flatMap(expression -> this.extractTryArguments((RowExpression)expression, types).stream()).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !tryArguments.contains(entry.getKey())).filter(entry -> !AssignmentUtils.isIdentity(child.getAssignments(), (VariableReferenceExpression)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, constants);
    }

    private Set<VariableReferenceExpression> extractTryArguments(RowExpression expression, TypeProvider types) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            return AstUtils.preOrder((Node)OriginalExpressionUtils.castToExpression(expression)).filter(TryExpression.class::isInstance).map(TryExpression.class::cast).flatMap(tryExpression -> VariablesExtractor.extractAll((Expression)tryExpression, types).stream()).collect(Collectors.toSet());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>>(){

            public Void visitCall(CallExpression call, ImmutableSet.Builder<VariableReferenceExpression> context) {
                if (InlineProjections.this.functionResolution.isTryFunction(call.getFunctionHandle())) {
                    context.addAll(VariablesExtractor.extractAll((RowExpression)call));
                }
                return super.visitCall(call, context);
            }
        }, (Object)builder);
        return builder.build();
    }

    private static List<VariableReferenceExpression> extractInputs(RowExpression expression, TypeProvider types) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            return VariablesExtractor.extractAll(OriginalExpressionUtils.castToExpression(expression), types);
        }
        return VariablesExtractor.extractAll(expression);
    }

    private static boolean isConstant(RowExpression expression) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            return OriginalExpressionUtils.castToExpression(expression) instanceof Literal;
        }
        return expression instanceof ConstantExpression;
    }
}

