/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticsAggregationPlanner {
    private final PlanVariableAllocator variableAllocator;
    private final Metadata metadata;

    public StatisticsAggregationPlanner(PlanVariableAllocator variableAllocator, Metadata metadata) {
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public TableStatisticAggregation createStatisticsAggregation(TableStatisticsMetadata statisticsMetadata, Map<String, VariableReferenceExpression> columnToVariableMap, boolean useOriginalExpression) {
        StatisticAggregationsDescriptor.Builder descriptor = StatisticAggregationsDescriptor.builder();
        List groupingColumns = statisticsMetadata.getGroupingColumns();
        List groupingVariables = (List)groupingColumns.stream().map(columnToVariableMap::get).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < groupingVariables.size(); ++i) {
            descriptor.addGrouping((String)groupingColumns.get(i), groupingVariables.get(i));
        }
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        FunctionResolution functionResolution = new FunctionResolution(this.metadata.getFunctionManager());
        for (TableStatisticType type : statisticsMetadata.getTableStatistics()) {
            if (type != TableStatisticType.ROW_COUNT) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table-wide statistic type not supported: " + type);
            }
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(new CallExpression("count", functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty());
            VariableReferenceExpression variable = this.variableAllocator.newVariable("rowCount", (Type)BigintType.BIGINT);
            aggregations.put((Object)variable, (Object)aggregation);
            descriptor.addTableStatistic(TableStatisticType.ROW_COUNT, variable);
        }
        for (ColumnStatisticMetadata columnStatisticMetadata : statisticsMetadata.getColumnStatistics()) {
            String columnName = columnStatisticMetadata.getColumnName();
            ColumnStatisticType statisticType = columnStatisticMetadata.getStatisticType();
            VariableReferenceExpression inputVariable = columnToVariableMap.get(columnName);
            Verify.verify((inputVariable != null ? 1 : 0) != 0, (String)"inputVariable is null", (Object[])new Object[0]);
            ColumnStatisticsAggregation aggregation = this.createColumnAggregation(statisticType, inputVariable, useOriginalExpression);
            VariableReferenceExpression variable = this.variableAllocator.newVariable(statisticType + ":" + columnName, aggregation.getOutputType());
            aggregations.put((Object)variable, (Object)aggregation.getAggregation());
            descriptor.addColumnStatistic(columnStatisticMetadata, variable);
        }
        StatisticAggregations aggregation = new StatisticAggregations((Map<VariableReferenceExpression, AggregationNode.Aggregation>)aggregations.build(), groupingVariables);
        return new TableStatisticAggregation(aggregation, descriptor.build());
    }

    private ColumnStatisticsAggregation createColumnAggregation(ColumnStatisticType statisticType, VariableReferenceExpression input, boolean useOriginalExpression) {
        VariableReferenceExpression inputExpression = useOriginalExpression ? OriginalExpressionUtils.castToRowExpression((Expression)new SymbolReference(input.getName())) : input;
        switch (statisticType) {
            case MIN_VALUE: {
                return this.createAggregation("min", (RowExpression)inputExpression, input.getType(), input.getType());
            }
            case MAX_VALUE: {
                return this.createAggregation("max", (RowExpression)inputExpression, input.getType(), input.getType());
            }
            case NUMBER_OF_DISTINCT_VALUES: {
                return this.createAggregation("approx_distinct", (RowExpression)inputExpression, input.getType(), (Type)BigintType.BIGINT);
            }
            case NUMBER_OF_NON_NULL_VALUES: {
                return this.createAggregation("count", (RowExpression)inputExpression, input.getType(), (Type)BigintType.BIGINT);
            }
            case NUMBER_OF_TRUE_VALUES: {
                return this.createAggregation("count_if", (RowExpression)inputExpression, (Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
            }
            case TOTAL_SIZE_IN_BYTES: {
                return this.createAggregation("$internal$sum_data_size_for_stats", (RowExpression)inputExpression, input.getType(), (Type)BigintType.BIGINT);
            }
            case MAX_VALUE_SIZE_IN_BYTES: {
                return this.createAggregation("$internal$max_data_size_for_stats", (RowExpression)inputExpression, input.getType(), (Type)BigintType.BIGINT);
            }
        }
        throw new IllegalArgumentException("Unsupported statistic type: " + statisticType);
    }

    private ColumnStatisticsAggregation createAggregation(String functionName, RowExpression input, Type inputType, Type outputType) {
        FunctionManager functionManager = this.metadata.getFunctionManager();
        FunctionHandle functionHandle = functionManager.lookupFunction(functionName, TypeSignatureProvider.fromTypes((List<? extends Type>)ImmutableList.of((Object)inputType)));
        Type resolvedType = this.metadata.getType((TypeSignature)Iterables.getOnlyElement((Iterable)functionManager.getFunctionMetadata(functionHandle).getArgumentTypes()));
        Verify.verify((boolean)resolvedType.equals(inputType), (String)"resolved function input type does not match the input type: %s != %s", (Object)resolvedType, (Object)inputType);
        return new ColumnStatisticsAggregation(new AggregationNode.Aggregation(new CallExpression(functionName, functionHandle, outputType, (List)ImmutableList.of((Object)input)), Optional.empty(), Optional.empty(), false, Optional.empty()), outputType);
    }

    public static class ColumnStatisticsAggregation {
        private final AggregationNode.Aggregation aggregation;
        private final Type outputType;

        private ColumnStatisticsAggregation(AggregationNode.Aggregation aggregation, Type outputType) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public Type getOutputType() {
            return this.outputType;
        }
    }

    public static class TableStatisticAggregation {
        private final StatisticAggregations aggregations;
        private final StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor;

        private TableStatisticAggregation(StatisticAggregations aggregations, StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
            this.aggregations = Objects.requireNonNull(aggregations, "statisticAggregations is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        public StatisticAggregations getAggregations() {
            return this.aggregations;
        }

        public StatisticAggregationsDescriptor<VariableReferenceExpression> getDescriptor() {
            return this.descriptor;
        }
    }
}

