/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SortExpressionExtractor {
    private SortExpressionExtractor() {
    }

    public static Optional<SortExpressionContext> extractSortExpression(Set<VariableReferenceExpression> buildVariables, RowExpression filter, FunctionManager functionManager) {
        List filterConjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)filter);
        SortExpressionVisitor visitor = new SortExpressionVisitor(buildVariables, functionManager);
        RowExpressionDeterminismEvaluator determinismEvaluator = new RowExpressionDeterminismEvaluator(functionManager);
        List sortExpressionCandidates = (List)filterConjuncts.stream().filter(arg_0 -> ((DeterminismEvaluator)determinismEvaluator).isDeterministic(arg_0)).map(conjunct -> (Optional)conjunct.accept((RowExpressionVisitor)visitor, null)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(SortExpressionContext::getSortExpression, Function.identity(), SortExpressionExtractor::merge)).values().stream().collect(ImmutableList.toImmutableList());
        return sortExpressionCandidates.stream().sorted(Comparator.comparing(context -> -1 * context.getSearchExpressions().size())).findFirst();
    }

    private static SortExpressionContext merge(SortExpressionContext left, SortExpressionContext right) {
        Preconditions.checkArgument((boolean)left.getSortExpression().equals((Object)right.getSortExpression()));
        ImmutableList.Builder searchExpressions = ImmutableList.builder();
        searchExpressions.addAll(left.getSearchExpressions());
        searchExpressions.addAll(right.getSearchExpressions());
        return new SortExpressionContext(left.getSortExpression(), (List<RowExpression>)searchExpressions.build());
    }

    private static Optional<VariableReferenceExpression> asBuildVariableReference(Set<VariableReferenceExpression> buildLayout, RowExpression expression) {
        VariableReferenceExpression reference;
        if (expression instanceof VariableReferenceExpression && buildLayout.contains(reference = (VariableReferenceExpression)expression)) {
            return Optional.of(reference);
        }
        return Optional.empty();
    }

    private static boolean hasBuildVariableReference(Set<VariableReferenceExpression> buildVariables, RowExpression expression) {
        return (Boolean)expression.accept((RowExpressionVisitor)new BuildVariableReferenceFinder(buildVariables), null);
    }

    private static class BuildVariableReferenceFinder
    implements RowExpressionVisitor<Boolean, Void> {
        private final Set<VariableReferenceExpression> buildVariables;

        public BuildVariableReferenceFinder(Set<VariableReferenceExpression> buildVariables) {
            this.buildVariables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(buildVariables, "buildVariables is null"));
        }

        public Boolean visitInputReference(InputReferenceExpression input, Void context) {
            return false;
        }

        public Boolean visitCall(CallExpression call, Void context) {
            for (RowExpression argument : call.getArguments()) {
                if (!((Boolean)argument.accept((RowExpressionVisitor)this, (Object)context)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return false;
        }

        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return (Boolean)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context);
        }

        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return this.buildVariables.contains(reference);
        }

        public Boolean visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            for (RowExpression argument : specialForm.getArguments()) {
                if (!((Boolean)argument.accept((RowExpressionVisitor)this, (Object)context)).booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static class SortExpressionVisitor
    implements RowExpressionVisitor<Optional<SortExpressionContext>, Void> {
        private final Set<VariableReferenceExpression> buildVariables;
        private final FunctionManager functionManager;

        public SortExpressionVisitor(Set<VariableReferenceExpression> buildVariables, FunctionManager functionManager) {
            this.buildVariables = buildVariables;
            this.functionManager = functionManager;
        }

        public Optional<SortExpressionContext> visitCall(CallExpression call, Void context) {
            FunctionMetadata functionMetadata = this.functionManager.getFunctionMetadata(call.getFunctionHandle());
            if (!functionMetadata.getOperatorType().map(OperatorType::isComparisonOperator).orElse(false).booleanValue()) {
                return Optional.empty();
            }
            switch ((OperatorType)functionMetadata.getOperatorType().get()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    RowExpression left = (RowExpression)call.getArguments().get(0);
                    RowExpression right = (RowExpression)call.getArguments().get(1);
                    Optional sortChannel = SortExpressionExtractor.asBuildVariableReference(this.buildVariables, right);
                    boolean hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildVariableReference(this.buildVariables, left);
                    if (!sortChannel.isPresent()) {
                        sortChannel = SortExpressionExtractor.asBuildVariableReference(this.buildVariables, left);
                        hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildVariableReference(this.buildVariables, right);
                    }
                    if (sortChannel.isPresent() && !hasBuildReferencesOnOtherSide) {
                        return sortChannel.map(variableReference -> new SortExpressionContext((RowExpression)variableReference, Collections.singletonList(call)));
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }

        public Optional<SortExpressionContext> visitInputReference(InputReferenceExpression input, Void context) {
            return Optional.empty();
        }

        public Optional<SortExpressionContext> visitConstant(ConstantExpression literal, Void context) {
            return Optional.empty();
        }

        public Optional<SortExpressionContext> visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return Optional.empty();
        }

        public Optional<SortExpressionContext> visitVariableReference(VariableReferenceExpression reference, Void context) {
            return Optional.empty();
        }

        public Optional<SortExpressionContext> visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            return Optional.empty();
        }
    }
}

