/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class RowExpressionVariableInliner
extends RowExpressionRewriter<Void> {
    private final Set<String> excludedNames = new HashSet<String>();
    private final Function<VariableReferenceExpression, ? extends RowExpression> mapping;

    private RowExpressionVariableInliner(Function<VariableReferenceExpression, ? extends RowExpression> mapping) {
        this.mapping = mapping;
    }

    public static RowExpression inlineVariables(Function<VariableReferenceExpression, ? extends RowExpression> mapping, RowExpression expression) {
        return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionVariableInliner(mapping), (RowExpression)expression);
    }

    public static RowExpression inlineVariables(Map<VariableReferenceExpression, ? extends RowExpression> mapping, RowExpression expression) {
        return RowExpressionVariableInliner.inlineVariables(mapping::get, expression);
    }

    public RowExpression rewriteVariableReference(VariableReferenceExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
        if (!this.excludedNames.contains(node.getName())) {
            RowExpression result = this.mapping.apply(node);
            Preconditions.checkState((result != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return result;
        }
        return null;
    }

    public RowExpression rewriteLambda(LambdaDefinitionExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkArgument((!node.getArguments().stream().anyMatch(this.excludedNames::contains) ? 1 : 0) != 0, (Object)"Lambda argument already contained in excluded names.");
        this.excludedNames.addAll(node.getArguments());
        RowExpression result = treeRewriter.defaultRewrite((RowExpression)node, (Object)context);
        this.excludedNames.removeAll(node.getArguments());
        return result;
    }
}

