/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TryExpression;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private final FunctionManager functionManager;
    private final TypeManager typeManager;

    public NullabilityAnalyzer(FunctionManager functionManager, TypeManager typeManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Deprecated
    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process((Node)expression, result);
        return result.get();
    }

    public boolean mayReturnNullOnNonNullInput(RowExpression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        expression.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)new RowExpressionVisitor(this.functionManager, this.typeManager), (Object)result);
        return result.get();
    }

    private static class RowExpressionVisitor
    extends DefaultRowExpressionTraversalVisitor<AtomicBoolean> {
        private final FunctionManager functionManager;
        private final TypeManager typeManager;

        public RowExpressionVisitor(FunctionManager functionManager, TypeManager typeManager) {
            this.functionManager = functionManager;
            this.typeManager = typeManager;
        }

        public Void visitCall(CallExpression call, AtomicBoolean result) {
            FunctionMetadata function = this.functionManager.getFunctionMetadata(call.getFunctionHandle());
            Optional operator = function.getOperatorType();
            if (operator.isPresent()) {
                switch ((OperatorType)operator.get()) {
                    case SATURATED_FLOOR_CAST: 
                    case CAST: {
                        Preconditions.checkArgument((call.getArguments().size() == 1 ? 1 : 0) != 0);
                        Type sourceType = ((RowExpression)call.getArguments().get(0)).getType();
                        Type targetType = call.getType();
                        if (!this.typeManager.isTypeOnlyCoercion(sourceType, targetType)) {
                            result.set(true);
                        }
                    }
                    case SUBSCRIPT: {
                        result.set(true);
                    }
                }
            } else if (!this.functionReturnsNullForNotNullInput(function)) {
                result.set(true);
            }
            call.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)this, (Object)result);
            });
            return null;
        }

        private boolean functionReturnsNullForNotNullInput(FunctionMetadata function) {
            return function.getName().getFunctionName().equalsIgnoreCase("like");
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, AtomicBoolean result) {
            switch (specialForm.getForm()) {
                case IN: 
                case IF: 
                case SWITCH: 
                case WHEN: 
                case NULL_IF: 
                case DEREFERENCE: {
                    result.set(true);
                }
            }
            specialForm.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)this, (Object)result);
            });
            return null;
        }
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitCast(Cast node, AtomicBoolean result) {
            result.set(node.isSafe() || !node.isTypeOnly());
            return null;
        }

        protected Void visitNullIfExpression(NullIfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitInPredicate(InPredicate node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSubscriptExpression(SubscriptExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitTryExpression(TryExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitIfExpression(IfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean result) {
            result.set(true);
            return null;
        }
    }
}

