/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.ConstantPageProjection;
import com.facebook.presto.operator.project.GeneratedPageProjection;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFieldsToInputParametersRewriter;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CommonSubExpressionRewriter;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class PageFunctionCompiler {
    private static Logger log = Logger.get(PageFunctionCompiler.class);
    private static final int MAX_PROJECTION_GROUP_SIZE = 10;
    private final Metadata metadata;
    private final DeterminismEvaluator determinismEvaluator;
    private final LoadingCache<CacheKey, Supplier<PageProjection>> projectionCache;
    private final LoadingCache<CacheKey, Supplier<PageFilter>> filterCache;
    private final CacheStatsMBean projectionCacheStats;
    private final CacheStatsMBean filterCacheStats;

    @Inject
    public PageFunctionCompiler(Metadata metadata, CompilerConfig config) {
        this(metadata, Objects.requireNonNull(config, "config is null").getExpressionCacheSize());
    }

    public PageFunctionCompiler(Metadata metadata, int expressionCacheSize) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata.getFunctionManager());
        if (expressionCacheSize > 0) {
            this.projectionCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(cacheKey -> this.compileProjectionInternal(((CacheKey)cacheKey).sqlFunctionProperties, ((CacheKey)cacheKey).rowExpressions, ((CacheKey)cacheKey).isOptimizeCommonSubExpression, Optional.empty())));
            this.projectionCacheStats = new CacheStatsMBean(this.projectionCache);
        } else {
            this.projectionCache = null;
            this.projectionCacheStats = null;
        }
        if (expressionCacheSize > 0) {
            this.filterCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(cacheKey -> this.compileFilterInternal(((CacheKey)cacheKey).sqlFunctionProperties, (RowExpression)((CacheKey)cacheKey).rowExpressions.get(0), ((CacheKey)cacheKey).isOptimizeCommonSubExpression, Optional.empty())));
            this.filterCacheStats = new CacheStatsMBean(this.filterCache);
        } else {
            this.filterCache = null;
            this.filterCacheStats = null;
        }
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getProjectionCache() {
        return this.projectionCacheStats;
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getFilterCache() {
        return this.filterCacheStats;
    }

    public List<Supplier<PageProjectionWithOutputs>> compileProjections(SqlFunctionProperties sqlFunctionProperties, List<? extends RowExpression> projections, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        if (isOptimizeCommonSubExpression) {
            ImmutableList.Builder pageProjections = ImmutableList.builder();
            ImmutableMap.Builder expressionsWithPositionBuilder = ImmutableMap.builder();
            for (int i = 0; i < projections.size(); ++i) {
                RowExpression projection = projections.get(i);
                if (projection instanceof ConstantExpression || projection instanceof InputReferenceExpression) {
                    pageProjections.add(this.toPageProjectionWithOutputs(this.compileProjection(sqlFunctionProperties, projection, classNameSuffix), new int[]{i}));
                    continue;
                }
                expressionsWithPositionBuilder.put((Object)projection, (Object)i);
            }
            ImmutableMap expressionsWithPosition = expressionsWithPositionBuilder.build();
            Map<List<RowExpression>, Boolean> projectionsPartitionedByCSE = CommonSubExpressionRewriter.getExpressionsPartitionedByCSE(expressionsWithPosition.keySet(), 10);
            for (Map.Entry<List<RowExpression>, Boolean> entry : projectionsPartitionedByCSE.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    pageProjections.add(this.toPageProjectionWithOutputs(this.compileProjectionCached(sqlFunctionProperties, entry.getKey(), true, classNameSuffix), PageFunctionCompiler.toIntArray((List)entry.getKey().stream().map(((Map)expressionsWithPosition)::get).collect(ImmutableList.toImmutableList()))));
                    continue;
                }
                Verify.verify((entry.getKey().size() == 1 ? 1 : 0) != 0, (String)"Expect non-cse expression list to only have one element", (Object[])new Object[0]);
                RowExpression projection = entry.getKey().get(0);
                pageProjections.add(this.toPageProjectionWithOutputs(this.compileProjection(sqlFunctionProperties, projection, classNameSuffix), new int[]{(Integer)expressionsWithPosition.get(projection)}));
            }
            return pageProjections.build();
        }
        return (List)IntStream.range(0, projections.size()).mapToObj(outputChannel -> this.toPageProjectionWithOutputs(this.compileProjection(sqlFunctionProperties, (RowExpression)projections.get(outputChannel), classNameSuffix), new int[]{outputChannel})).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    public Supplier<PageProjection> compileProjection(SqlFunctionProperties sqlFunctionProperties, RowExpression projection, Optional<String> classNameSuffix) {
        if (projection instanceof InputReferenceExpression) {
            InputReferenceExpression input = (InputReferenceExpression)projection;
            InputPageProjection projectionFunction = new InputPageProjection(input.getField());
            return () -> projectionFunction;
        }
        if (projection instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)projection;
            ConstantPageProjection projectionFunction = new ConstantPageProjection(constant.getValue(), constant.getType());
            return () -> projectionFunction;
        }
        return this.compileProjectionCached(sqlFunctionProperties, (List<RowExpression>)ImmutableList.of((Object)projection), false, classNameSuffix);
    }

    private Supplier<PageProjection> compileProjectionCached(SqlFunctionProperties sqlFunctionProperties, List<RowExpression> projections, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        if (this.projectionCache == null) {
            return this.compileProjectionInternal(sqlFunctionProperties, projections, isOptimizeCommonSubExpression, classNameSuffix);
        }
        return (Supplier)this.projectionCache.getUnchecked((Object)new CacheKey(sqlFunctionProperties, projections, isOptimizeCommonSubExpression));
    }

    private Supplier<PageProjectionWithOutputs> toPageProjectionWithOutputs(Supplier<PageProjection> pageProjection, int[] outputChannels) {
        return () -> new PageProjectionWithOutputs((PageProjection)pageProjection.get(), outputChannels);
    }

    private Supplier<PageProjection> compileProjectionInternal(SqlFunctionProperties sqlFunctionProperties, List<RowExpression> projections, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        Class<Work> pageProjectionWorkClass;
        Objects.requireNonNull(projections, "projections is null");
        Preconditions.checkArgument((!projections.isEmpty() && projections.stream().allMatch(projection -> projection instanceof CallExpression || projection instanceof SpecialFormExpression) ? 1 : 0) != 0);
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(projections);
        List<RowExpression> rewrittenExpression = result.getRewrittenExpressions();
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition pageProjectionWorkDefinition = this.definePageProjectWorkClass(sqlFunctionProperties, rewrittenExpression, callSiteBinder, isOptimizeCommonSubExpression, classNameSuffix);
        try {
            pageProjectionWorkClass = CompilerUtils.defineClass(pageProjectionWorkDefinition, Work.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (PrestoException prestoException) {
            throw prestoException;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
        }
        return () -> new GeneratedPageProjection(rewrittenExpression, rewrittenExpression.stream().allMatch(arg_0 -> ((DeterminismEvaluator)this.determinismEvaluator).isDeterministic(arg_0)), result.getInputChannels(), Reflection.constructorMethodHandle(pageProjectionWorkClass, List.class, SqlFunctionProperties.class, Page.class, SelectedPositions.class));
    }

    private static ParameterizedType generateProjectionWorkClassName(Optional<String> classNameSuffix) {
        return CompilerUtils.makeClassName("PageProjectionWork", classNameSuffix);
    }

    private ClassDefinition definePageProjectWorkClass(SqlFunctionProperties sqlFunctionProperties, List<RowExpression> projections, CallSiteBinder callSiteBinder, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel;
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateProjectionWorkClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Work.class)});
        FieldDefinition blockBuilderFields = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "blockBuilders", ParameterizedType.type(List.class, (Class[])new Class[]{BlockBuilder.class}));
        FieldDefinition propertiesField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "properties", SqlFunctionProperties.class);
        FieldDefinition pageField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "page", Page.class);
        FieldDefinition selectedPositionsField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "selectedPositions", SelectedPositions.class);
        FieldDefinition nextIndexOrPositionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "nextIndexOrPosition", Integer.TYPE);
        FieldDefinition resultField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "result", List.class);
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        PageFunctionCompiler.generateProcessMethod(classDefinition, blockBuilderFields, projections.size(), propertiesField, pageField, selectedPositionsField, nextIndexOrPositionField, resultField);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getResult", ParameterizedType.type(Object.class), (Iterable)ImmutableList.of());
        method.getBody().append((BytecodeNode)method.getThis().getField(resultField)).ret(Object.class);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, projections, this.metadata, sqlFunctionProperties, "");
        Object cseFields = ImmutableMap.of();
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, new FieldAndVariableReferenceCompiler(callSiteBinder, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, compiledLambdaMap);
        if (isOptimizeCommonSubExpression && !(commonSubExpressionsByLevel = CommonSubExpressionRewriter.collectCSEByLevel(projections)).isEmpty()) {
            cseFields = CommonSubExpressionRewriter.CommonSubExpressionFields.declareCommonSubExpressionFields(classDefinition, commonSubExpressionsByLevel);
            compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, new FieldAndVariableReferenceCompiler(callSiteBinder, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, compiledLambdaMap);
            this.generateCommonSubExpressionMethods(classDefinition, compiler, commonSubExpressionsByLevel, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
            Map commonSubExpressions = (Map)commonSubExpressionsByLevel.values().stream().flatMap(m -> m.entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            projections = (List)projections.stream().map(projection -> CommonSubExpressionRewriter.rewriteExpressionWithCSE(projection, commonSubExpressions)).collect(ImmutableList.toImmutableList());
            if (log.isDebugEnabled()) {
                log.debug("Extracted %d common sub-expressions", new Object[]{commonSubExpressions.size()});
                commonSubExpressions.entrySet().forEach(entry -> log.debug("\t%s = %s", new Object[]{entry.getValue(), entry.getKey()}));
                log.debug("Rewrote %d projections: %s", new Object[]{projections.size(), Joiner.on((String)", ").join((Iterable)projections)});
            }
        }
        this.generateEvaluateMethod(classDefinition, compiler, projections, blockBuilderFields, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
        Parameter blockBuilders = Parameter.arg((String)"blockBuilders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{BlockBuilder.class}));
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", SelectedPositions.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{blockBuilders, properties, page, selectedPositions});
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)thisVariable.setField(blockBuilderFields, BytecodeExpressions.invokeStatic(ImmutableList.class, (String)"copyOf", ImmutableList.class, (BytecodeExpression[])new BytecodeExpression[]{blockBuilders.cast(Collection.class)}))).append((BytecodeNode)thisVariable.setField(propertiesField, (BytecodeExpression)properties)).append((BytecodeNode)thisVariable.setField(pageField, (BytecodeExpression)page)).append((BytecodeNode)thisVariable.setField(selectedPositionsField, (BytecodeExpression)selectedPositions)).append((BytecodeNode)thisVariable.setField(nextIndexOrPositionField, selectedPositions.invoke("getOffset", Integer.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)thisVariable.setField(resultField, BytecodeExpressions.constantNull(Block.class)));
        CommonSubExpressionRewriter.CommonSubExpressionFields.initializeCommonSubExpressionFields(cseFields.values(), thisVariable, body);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
        return classDefinition;
    }

    private static MethodDefinition generateProcessMethod(ClassDefinition classDefinition, FieldDefinition blockBuilders, int blockBuilderSize, FieldDefinition properties, FieldDefinition page, FieldDefinition selectedPositions, FieldDefinition nextIndexOrPosition, FieldDefinition result) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.of());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable from = scope.declareVariable("from", body, thisVariable.getField(nextIndexOrPosition));
        Variable to = scope.declareVariable("to", body, BytecodeExpressions.add((BytecodeExpression)thisVariable.getField(selectedPositions).invoke("getOffset", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)thisVariable.getField(selectedPositions).invoke("size", Integer.TYPE, new BytecodeExpression[0])));
        Variable positions = scope.declareVariable(int[].class, "positions");
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)thisVariable.getField(selectedPositions).invoke("isList", Boolean.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)ifStatement);
        ifStatement.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positions.set(thisVariable.getField(selectedPositions).invoke("getPositions", int[].class, new BytecodeExpression[0]))).append((BytecodeNode)new ForLoop("positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable.invoke("evaluate", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(properties), thisVariable.getField(page), positions.getElement((BytecodeExpression)index)})))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("range based loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable.invoke("evaluate", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(properties), thisVariable.getField(page), index}))));
        Variable blocksBuilder = scope.declareVariable("blocksBuilder", body, BytecodeExpressions.invokeStatic(ImmutableList.class, (String)"builder", ImmutableList.Builder.class, (BytecodeExpression[])new BytecodeExpression[0]));
        Variable iterator = scope.createTempVariable(Integer.TYPE);
        ForLoop forLoop = new ForLoop("for (iterator = 0; iterator < this.blockBuilders.size(); iterator ++) blockBuildersBuilder.add(this.blockBuilders.get(iterator).builder();", new Object[0]).initialize((BytecodeNode)iterator.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)iterator, (BytecodeExpression)BytecodeExpressions.constantInt((int)blockBuilderSize))).update((BytecodeNode)iterator.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blocksBuilder.invoke("add", ImmutableList.Builder.class, new BytecodeExpression[]{thisVariable.getField(blockBuilders).invoke("get", Object.class, new BytecodeExpression[]{iterator}).cast(BlockBuilder.class).invoke("build", Block.class, new BytecodeExpression[0]).cast(Object.class)}).pop()));
        body.append((BytecodeNode)forLoop).comment("result = blockBuildersBuilder.build(); return true").append((BytecodeNode)thisVariable.setField(result, blocksBuilder.invoke("build", ImmutableList.class, new BytecodeExpression[0]))).push(true).retBoolean();
        return method;
    }

    private List<MethodDefinition> generateCommonSubExpressionMethods(ClassDefinition classDefinition, RowExpressionCompiler compiler, Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> commonSubExpressionFieldsMap) {
        ImmutableList.Builder methods = ImmutableList.builder();
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        int startLevel = (Integer)commonSubExpressionsByLevel.keySet().stream().reduce(Math::min).get();
        int maxLevel = (Integer)commonSubExpressionsByLevel.keySet().stream().reduce(Math::max).get();
        for (int i = startLevel; i <= maxLevel; ++i) {
            if (!commonSubExpressionsByLevel.containsKey(i)) continue;
            for (Map.Entry<RowExpression, VariableReferenceExpression> entry : commonSubExpressionsByLevel.get(i).entrySet()) {
                RowExpression cse = entry.getKey();
                Class type = Primitives.wrap((Class)cse.getType().getJavaType());
                VariableReferenceExpression cseVariable = entry.getValue();
                CommonSubExpressionRewriter.CommonSubExpressionFields cseFields = commonSubExpressionFieldsMap.get(cseVariable);
                MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), "get" + cseVariable.getName(), ParameterizedType.type(cseFields.getResultType()), (Iterable)ImmutableList.builder().add((Object)properties).add((Object)page).add((Object)position).build());
                method.comment("cse: %s", new Object[]{cse});
                Scope scope = method.getScope();
                BytecodeBlock body = method.getBody();
                Variable thisVariable = method.getThis();
                PageFunctionCompiler.declareBlockVariables((List<RowExpression>)ImmutableList.of((Object)cse), page, scope, body);
                scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
                IfStatement ifStatement = new IfStatement().condition((BytecodeNode)thisVariable.getField(cseFields.getEvaluatedField())).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable).append(compiler.compile(cse, scope, Optional.empty())).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, type)).putField(cseFields.getResultField()).append((BytecodeNode)thisVariable.setField(cseFields.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)true))));
                body.append((BytecodeNode)ifStatement).append((BytecodeNode)thisVariable).getField(cseFields.getResultField()).retObject();
                methods.add((Object)method);
            }
        }
        return methods.build();
    }

    private MethodDefinition generateEvaluateMethod(ClassDefinition classDefinition, RowExpressionCompiler compiler, List<RowExpression> projections, FieldDefinition blockBuilders, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> cseFields) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluate", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.builder().add((Object)properties).add((Object)page).add((Object)position).build());
        method.comment("Projections: %s", new Object[]{Joiner.on((String)", ").join(projections)});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        PageFunctionCompiler.declareBlockVariables(projections, page, scope, body);
        Variable wasNull = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        cseFields.values().forEach(fields -> body.append((BytecodeNode)thisVariable.setField(fields.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)false))));
        Variable outputBlockVariable = scope.createTempVariable(BlockBuilder.class);
        for (int i = 0; i < projections.size(); ++i) {
            body.append((BytecodeNode)outputBlockVariable.set(thisVariable.getField(blockBuilders).invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}))).append(compiler.compile(projections.get(i), scope, Optional.of(outputBlockVariable))).append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)false)).putVariable(wasNull);
        }
        body.ret();
        return method;
    }

    public Supplier<PageFilter> compileFilter(SqlFunctionProperties sqlFunctionProperties, RowExpression filter, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        if (this.filterCache == null) {
            return this.compileFilterInternal(sqlFunctionProperties, filter, isOptimizeCommonSubExpression, classNameSuffix);
        }
        return (Supplier)this.filterCache.getUnchecked((Object)new CacheKey(sqlFunctionProperties, (List)ImmutableList.of((Object)filter), isOptimizeCommonSubExpression));
    }

    private Supplier<PageFilter> compileFilterInternal(SqlFunctionProperties sqlFunctionProperties, RowExpression filter, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        Class<PageFilter> functionClass;
        Objects.requireNonNull(filter, "filter is null");
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(filter);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.defineFilterClass(sqlFunctionProperties, result.getRewrittenExpression(), result.getInputChannels(), callSiteBinder, isOptimizeCommonSubExpression, classNameSuffix);
        try {
            functionClass = CompilerUtils.defineClass(classDefinition, PageFilter.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (PrestoException prestoException) {
            throw prestoException;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, filter.toString(), e.getCause());
        }
        return () -> {
            try {
                return (PageFilter)functionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private static ParameterizedType generateFilterClassName(Optional<String> classNameSuffix) {
        return CompilerUtils.makeClassName(PageFilter.class.getSimpleName(), classNameSuffix);
    }

    private ClassDefinition defineFilterClass(SqlFunctionProperties sqlFunctionProperties, RowExpression filter, InputChannels inputChannels, CallSiteBinder callSiteBinder, boolean isOptimizeCommonSubExpression, Optional<String> classNameSuffix) {
        Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel;
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateFilterClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageFilter.class)});
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, filter, this.metadata, sqlFunctionProperties);
        Object cseFields = ImmutableMap.of();
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, new FieldAndVariableReferenceCompiler(callSiteBinder, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, compiledLambdaMap);
        if (isOptimizeCommonSubExpression && !(commonSubExpressionsByLevel = CommonSubExpressionRewriter.collectCSEByLevel(filter)).isEmpty()) {
            cseFields = CommonSubExpressionRewriter.CommonSubExpressionFields.declareCommonSubExpressionFields(classDefinition, commonSubExpressionsByLevel);
            compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, new FieldAndVariableReferenceCompiler(callSiteBinder, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, compiledLambdaMap);
            this.generateCommonSubExpressionMethods(classDefinition, compiler, commonSubExpressionsByLevel, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
            Map commonSubExpressions = (Map)commonSubExpressionsByLevel.values().stream().flatMap(m -> m.entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            filter = CommonSubExpressionRewriter.rewriteExpressionWithCSE(filter, commonSubExpressions);
            if (log.isDebugEnabled()) {
                log.debug("Extracted %d common sub-expressions", new Object[]{commonSubExpressions.size()});
                commonSubExpressions.entrySet().forEach(entry -> log.debug("\t%s = %s", new Object[]{entry.getValue(), entry.getKey()}));
                log.debug("Rewrote filter: %s", new Object[]{filter});
            }
        }
        this.generateFilterMethod(classDefinition, compiler, filter, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
        FieldDefinition selectedPositions = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "selectedPositions", boolean[].class);
        PageFunctionCompiler.generatePageFilterMethod(classDefinition, selectedPositions);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isDeterministic", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)this.determinismEvaluator.isDeterministic(filter))).retBoolean();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(InputChannels.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputChannels, InputChannels.class), "getInputChannels")).retObject();
        String toStringResult = MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).toString();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(toStringResult, String.class), "toString")).retObject();
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)thisVariable.setField(selectedPositions, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (int)0)));
        CommonSubExpressionRewriter.CommonSubExpressionFields.initializeCommonSubExpressionFields(cseFields.values(), thisVariable, body);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
        return classDefinition;
    }

    private static MethodDefinition generatePageFilterMethod(ClassDefinition classDefinition, FieldDefinition selectedPositionsField) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(SelectedPositions.class), (Iterable)ImmutableList.builder().add((Object)properties).add((Object)page).build());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)new IfStatement("grow selectedPositions if necessary", new Object[0]).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)thisVariable.getField(selectedPositionsField).length(), (BytecodeExpression)positionCount)).ifTrue((BytecodeNode)thisVariable.setField(selectedPositionsField, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (BytecodeExpression)positionCount))));
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.getField(selectedPositionsField));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)selectedPositions.setElement((BytecodeExpression)position, thisVariable.invoke("filter", Boolean.TYPE, new BytecodeExpression[]{properties, page, position}))));
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(PageFilter.class, (String)"positionsArrayToSelectedPositions", SelectedPositions.class, (BytecodeExpression[])new BytecodeExpression[]{selectedPositions, positionCount}).ret());
        return method;
    }

    private MethodDefinition generateFilterMethod(ClassDefinition classDefinition, RowExpressionCompiler compiler, RowExpression filter, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> cseFields) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)properties).add((Object)page).add((Object)position).build());
        method.comment("Filter: %s", new Object[]{filter.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = scope.getThis();
        PageFunctionCompiler.declareBlockVariables((List<RowExpression>)ImmutableList.of((Object)filter), page, scope, body);
        cseFields.values().forEach(fields -> body.append((BytecodeNode)thisVariable.setField(fields.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)false))));
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(compiler.compile(filter, scope, Optional.empty())).putVariable(result).append((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)wasNullVariable), (BytecodeExpression)result).ret());
        return method;
    }

    private static void declareBlockVariables(List<RowExpression> expressions, Parameter page, Scope scope, BytecodeBlock body) {
        for (int channel : PageFunctionCompiler.getInputChannels(expressions)) {
            scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
        }
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private static final class CacheKey {
        private final SqlFunctionProperties sqlFunctionProperties;
        private final List<RowExpression> rowExpressions;
        private final boolean isOptimizeCommonSubExpression;

        private CacheKey(SqlFunctionProperties sqlFunctionProperties, List<RowExpression> rowExpressions, boolean isOptimizeCommonSubExpression) {
            Objects.requireNonNull(rowExpressions, "rowExpressions is null");
            Preconditions.checkArgument((rowExpressions.size() >= 1 ? 1 : 0) != 0, (Object)"Expect at least one RowExpression");
            this.sqlFunctionProperties = Objects.requireNonNull(sqlFunctionProperties, "sqlFunctionProperties is null");
            this.rowExpressions = ImmutableList.copyOf(rowExpressions);
            this.isOptimizeCommonSubExpression = isOptimizeCommonSubExpression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.sqlFunctionProperties, that.sqlFunctionProperties) && Objects.equals(this.rowExpressions, that.rowExpressions) && this.isOptimizeCommonSubExpression == that.isOptimizeCommonSubExpression;
        }

        public int hashCode() {
            return Objects.hash(this.sqlFunctionProperties, this.rowExpressions, this.isOptimizeCommonSubExpression);
        }
    }

    private static class FieldAndVariableReferenceCompiler
    implements RowExpressionVisitor<BytecodeNode, Scope> {
        private final InputReferenceCompiler inputReferenceCompiler;
        private final Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> variableMap;

        public FieldAndVariableReferenceCompiler(CallSiteBinder callSiteBinder, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> variableMap) {
            this.inputReferenceCompiler = new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> scope.getVariable("position"), callSiteBinder);
            this.variableMap = ImmutableMap.copyOf(variableMap);
        }

        public BytecodeNode visitCall(CallExpression call, Scope context) {
            throw new UnsupportedOperationException();
        }

        public BytecodeNode visitInputReference(InputReferenceExpression reference, Scope context) {
            return this.inputReferenceCompiler.visitInputReference(reference, context);
        }

        public BytecodeNode visitConstant(ConstantExpression literal, Scope context) {
            throw new UnsupportedOperationException();
        }

        public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
            throw new UnsupportedOperationException();
        }

        public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
            CommonSubExpressionRewriter.CommonSubExpressionFields fields = this.variableMap.get(reference);
            return new BytecodeBlock().append((BytecodeNode)context.getThis().invoke(fields.getMethodName(), fields.getResultType(), new BytecodeExpression[]{context.getVariable("properties"), context.getVariable("page"), context.getVariable("position")})).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, Primitives.wrap((Class)reference.getType().getJavaType())));
        }

        public BytecodeNode visitSpecialForm(SpecialFormExpression specialForm, Scope context) {
            throw new UnsupportedOperationException();
        }
    }
}

