/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionCallCodeGenerator {
    public BytecodeNode generateCall(FunctionHandle functionHandle, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        FunctionManager functionManager = context.getFunctionManager();
        BuiltInScalarFunctionImplementation function = functionManager.getBuiltInScalarFunctionImplementation(functionHandle);
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        for (int i = 0; i < arguments.size(); ++i) {
            RowExpression argument = arguments.get(i);
            BuiltInScalarFunctionImplementation.ArgumentProperty argumentProperty = function.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == BuiltInScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                argumentsBytecode.add(context.generate(argument, Optional.empty()));
                continue;
            }
            argumentsBytecode.add(context.generate(argument, Optional.empty(), Optional.of(argumentProperty.getLambdaInterface())));
        }
        return context.generateCall(functionManager.getFunctionMetadata(functionHandle).getName().getFunctionName(), function, argumentsBytecode, outputBlockVariable.map(variable -> new BytecodeUtils.OutputBlockVariableAndType((Variable)variable, returnType)));
    }
}

