/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.FreeLambdaReferenceExtractor;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.ScopeReferenceExtractor;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

class AggregationAnalyzer {
    private final Set<FieldId> groupingFields;
    private final List<Expression> expressions;
    private final Map<NodeRef<Expression>, FieldId> columnReferences;
    private final Metadata metadata;
    private final Analysis analysis;
    private final Scope sourceScope;
    private final Optional<Scope> orderByScope;
    private final WarningCollector warningCollector;
    private final FunctionResolution functionResolution;

    public static void verifySourceAggregations(List<Expression> groupByExpressions, Scope sourceScope, Expression expression, Metadata metadata, Analysis analysis, WarningCollector warningCollector) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.empty(), metadata, analysis, warningCollector);
        analyzer.analyze(expression);
    }

    public static void verifyOrderByAggregations(List<Expression> groupByExpressions, Scope sourceScope, Scope orderByScope, Expression expression, Metadata metadata, Analysis analysis, WarningCollector warningCollector) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.of(orderByScope), metadata, analysis, warningCollector);
        analyzer.analyze(expression);
    }

    private AggregationAnalyzer(List<Expression> groupByExpressions, Scope sourceScope, Optional<Scope> orderByScope, Metadata metadata, Analysis analysis, WarningCollector warningCollector) {
        Objects.requireNonNull(groupByExpressions, "groupByExpressions is null");
        Objects.requireNonNull(sourceScope, "sourceScope is null");
        Objects.requireNonNull(orderByScope, "orderByScope is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.sourceScope = sourceScope;
        this.warningCollector = warningCollector;
        this.orderByScope = orderByScope;
        this.metadata = metadata;
        this.analysis = analysis;
        this.functionResolution = new FunctionResolution(metadata.getFunctionManager());
        this.expressions = (List)groupByExpressions.stream().map(e -> ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(analysis.getParameters()), (Expression)e)).collect(ImmutableList.toImmutableList());
        this.columnReferences = analysis.getColumnReferenceFields();
        this.groupingFields = (Set)groupByExpressions.stream().map(NodeRef::of).filter(this.columnReferences::containsKey).map(this.columnReferences::get).collect(ImmutableSet.toImmutableSet());
        this.groupingFields.forEach(fieldId -> Preconditions.checkState((boolean)ScopeReferenceExtractor.isFieldFromScope(fieldId, sourceScope), (String)"Grouping field %s should originate from %s", (Object)fieldId, (Object)sourceScope.getRelationType()));
    }

    private void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "'%s' must be an aggregate expression or appear in GROUP BY clause", expression);
        }
    }

    private boolean hasOrderByReferencesToOutputColumns(Node node) {
        return ScopeReferenceExtractor.hasReferencesToScope(node, this.analysis, this.orderByScope.get());
    }

    private void verifyNoOrderByReferencesToOutputColumns(Node node, SemanticErrorCode errorCode, String errorString) {
        ScopeReferenceExtractor.getReferencesToScope(node, this.analysis, this.orderByScope.get()).findFirst().ifPresent(expression -> {
            throw new SemanticException(errorCode, (Node)expression, errorString, new Object[0]);
        });
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        protected Boolean visitAtTimeZone(AtTimeZone node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitSubqueryExpression(SubqueryExpression node, Void context) {
            ScopeReferenceExtractor.getReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope).filter(expression -> !this.isGroupingKey((Expression)expression)).findFirst().ifPresent(expression -> {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "Subquery uses '%s' which must appear in GROUP BY clause", expression);
            });
            return true;
        }

        protected Boolean visitExists(ExistsPredicate node, Void context) {
            Preconditions.checkState((boolean)(node.getSubquery() instanceof SubqueryExpression));
            return this.process((Node)node.getSubquery(), context);
        }

        protected Boolean visitSubscriptExpression(SubscriptExpression node, Void context) {
            return this.process((Node)node.getBase(), context) != false && this.process((Node)node.getIndex(), context) != false;
        }

        protected Boolean visitArrayConstructor(ArrayConstructor node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return node.getOperands().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        protected Boolean visitExtract(Extract node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            if (AggregationAnalyzer.this.metadata.getFunctionManager().getFunctionMetadata(AggregationAnalyzer.this.analysis.getFunctionHandle(node)).getFunctionKind() == FunctionKind.AGGREGATE) {
                if (AggregationAnalyzer.this.functionResolution.isCountFunction(AggregationAnalyzer.this.analysis.getFunctionHandle(node)) && node.isDistinct()) {
                    AggregationAnalyzer.this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, "COUNT(DISTINCT xxx) can be a very expensive operation when the cardinality is high for xxx. In most scenarios, using approx_distinct instead would be enough"));
                }
                if (!node.getWindow().isPresent()) {
                    List<FunctionCall> aggregateFunctions = ExpressionTreeUtils.extractAggregateFunctions(AggregationAnalyzer.this.analysis.getFunctionHandles(), node.getArguments(), AggregationAnalyzer.this.metadata.getFunctionManager());
                    List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(node.getArguments());
                    if (!aggregateFunctions.isEmpty()) {
                        throw new SemanticException(SemanticErrorCode.NESTED_AGGREGATION, (Node)node, "Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateFunctions);
                    }
                    if (!windowFunctions.isEmpty()) {
                        throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside aggregation '%s': %s", node.getName(), windowFunctions);
                    }
                    if (node.getOrderBy().isPresent()) {
                        List sortKeys = (List)((OrderBy)node.getOrderBy().get()).getSortItems().stream().map(SortItem::getSortKey).collect(ImmutableList.toImmutableList());
                        if (node.isDistinct()) {
                            List fieldIds = (List)node.getArguments().stream().map(NodeRef::of).map(AggregationAnalyzer.this.columnReferences::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                            for (Expression sortKey : sortKeys) {
                                if (node.getArguments().contains(sortKey) || fieldIds.contains(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)sortKey)))) continue;
                                throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_AGGREGATE, (Node)sortKey, "For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments", new Object[0]);
                            }
                        }
                        if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                            for (Expression sortKey : sortKeys) {
                                AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)sortKey, SemanticErrorCode.REFERENCE_TO_OUTPUT_ATTRIBUTE_WITHIN_ORDER_BY_AGGREGATION, "ORDER BY clause in aggregation function must not reference query output columns");
                            }
                        }
                    }
                    if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                        node.getArguments().stream().forEach(argument -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)argument, SemanticErrorCode.REFERENCE_TO_OUTPUT_ATTRIBUTE_WITHIN_ORDER_BY_AGGREGATION, "Invalid reference to output projection attribute from ORDER BY aggregation"));
                    }
                    return true;
                }
            } else {
                if (node.getFilter().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATION_FUNCTION, (Node)node, "Filter is only valid for aggregation functions", node);
                }
                if (node.getOrderBy().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATION_FUNCTION, (Node)node, "ORDER BY is only valid for aggregation functions", new Object[0]);
                }
            }
            if (node.getWindow().isPresent() && !this.process((Node)node.getWindow().get(), context).booleanValue()) {
                return false;
            }
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitLambdaExpression(LambdaExpression node, Void context) {
            return this.process((Node)node.getBody(), context);
        }

        protected Boolean visitBindExpression(BindExpression node, Void context) {
            for (Expression value : node.getValues()) {
                if (this.process((Node)value, context).booleanValue()) continue;
                return false;
            }
            return this.process((Node)node.getFunction(), context);
        }

        public Boolean visitWindow(Window node, Void context) {
            for (Expression expression : node.getPartitionBy()) {
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "PARTITION BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())) {
                Expression expression = sortItem.getSortKey();
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)expression, "ORDER BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            if (node.getFrame().isPresent()) {
                this.process((Node)node.getFrame().get(), context);
            }
            return true;
        }

        public Boolean visitWindowFrame(WindowFrame node, Void context) {
            Expression endValue;
            Optional start = node.getStart().getValue();
            if (start.isPresent() && !this.process((Node)start.get(), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)start.get(), "Window frame start must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            if (node.getEnd().isPresent() && ((FrameBound)node.getEnd().get()).getValue().isPresent() && !this.process((Node)(endValue = (Expression)((FrameBound)node.getEnd().get()).getValue().get()), context).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)endValue, "Window frame end must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            return true;
        }

        protected Boolean visitIdentifier(Identifier node, Void context) {
            if (AggregationAnalyzer.this.analysis.getLambdaArgumentReferences().containsKey(NodeRef.of((Node)node))) {
                return true;
            }
            return this.isGroupingKey((Expression)node);
        }

        protected Boolean visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)node))) {
                return this.isGroupingKey((Expression)node);
            }
            return this.process((Node)node.getBase(), context);
        }

        private boolean isGroupingKey(Expression node) {
            FieldId fieldId = (FieldId)AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node));
            Objects.requireNonNull(fieldId, () -> "No FieldId for " + node);
            if (AggregationAnalyzer.this.orderByScope.isPresent() && ScopeReferenceExtractor.isFieldFromScope(fieldId, (Scope)AggregationAnalyzer.this.orderByScope.get())) {
                return true;
            }
            return AggregationAnalyzer.this.groupingFields.contains(fieldId);
        }

        protected Boolean visitFieldReference(FieldReference node, Void context) {
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                return true;
            }
            FieldId fieldId = (FieldId)Objects.requireNonNull(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node)), "No FieldId for FieldReference");
            boolean inGroup = AggregationAnalyzer.this.groupingFields.contains(fieldId);
            if (!inGroup) {
                Field field = AggregationAnalyzer.this.sourceScope.getRelationType().getFieldByIndex(node.getFieldIndex());
                String column = !field.getName().isPresent() ? Integer.toString(node.getFieldIndex() + 1) : (field.getRelationAlias().isPresent() ? String.format("'%s.%s'", field.getRelationAlias().get(), field.getName().get()) : "'" + field.getName().get() + "'");
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column %s not in GROUP BY clause", column);
            }
            return inGroup;
        }

        protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add(node.getFalseValue().get());
            }
            return expressions.build().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            if (node.getDefaultValue().isPresent() && !this.process((Node)node.getDefaultValue().get(), context).booleanValue()) {
                return false;
            }
            return true;
        }

        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return !node.getDefaultValue().isPresent() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        protected Boolean visitTryExpression(TryExpression node, Void context) {
            return this.process((Node)node.getInnerExpression(), context);
        }

        public Boolean visitRow(Row node, Void context) {
            return node.getItems().stream().allMatch(item -> this.process((Node)item, context));
        }

        public Boolean visitParameter(Parameter node, Void context) {
            if (AggregationAnalyzer.this.analysis.isDescribe()) {
                return true;
            }
            List<Expression> parameters = AggregationAnalyzer.this.analysis.getParameters();
            Preconditions.checkArgument((node.getPosition() < parameters.size() ? 1 : 0) != 0, (String)"Invalid parameter number %s, max values is %s", (int)node.getPosition(), (int)(parameters.size() - 1));
            return this.process((Node)parameters.get(node.getPosition()), context);
        }

        public Boolean visitGroupingOperation(GroupingOperation node, Void context) {
            Optional<Expression> argumentNotInGroupBy;
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                node.getGroupingColumns().forEach(groupingColumn -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)groupingColumn, SemanticErrorCode.REFERENCE_TO_OUTPUT_ATTRIBUTE_WITHIN_ORDER_BY_GROUPING, "Invalid reference to output of SELECT clause from grouping() expression in ORDER BY"));
            }
            if ((argumentNotInGroupBy = node.getGroupingColumns().stream().filter(argument -> !AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)argument)) || !this.isGroupingKey((Expression)argument)).findAny()).isPresent()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)node, "The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to %s.", argumentNotInGroupBy.get());
            }
            return true;
        }

        public Boolean process(Node node, @Nullable Void context) {
            if (!(!AggregationAnalyzer.this.expressions.stream().anyMatch(arg_0 -> ((Node)node).equals(arg_0)) || AggregationAnalyzer.this.orderByScope.isPresent() && AggregationAnalyzer.this.hasOrderByReferencesToOutputColumns(node) || FreeLambdaReferenceExtractor.hasFreeReferencesToLambdaArgument(node, AggregationAnalyzer.this.analysis))) {
                return true;
            }
            return (Boolean)super.process(node, (Object)context);
        }
    }
}

