/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.stats.DistributionStat;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RemoteTaskStats {
    private final IncrementalAverage updateRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage infoRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage statusRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage responseSizeBytes = new IncrementalAverage();
    private final DistributionStat updateWithPlanSize = new DistributionStat();
    private final DistributionStat updateWithoutPlanSize = new DistributionStat();
    private long requestSuccess;
    private long requestFailure;

    public void statusRoundTripMillis(long roundTripMillis) {
        this.statusRoundTripMillis.add(roundTripMillis);
    }

    public void infoRoundTripMillis(long roundTripMillis) {
        this.infoRoundTripMillis.add(roundTripMillis);
    }

    public void updateRoundTripMillis(long roundTripMillis) {
        this.updateRoundTripMillis.add(roundTripMillis);
    }

    public void responseSize(long responseSizeBytes) {
        this.responseSizeBytes.add(responseSizeBytes);
    }

    public void updateSuccess() {
        ++this.requestSuccess;
    }

    public void updateFailure() {
        ++this.requestFailure;
    }

    public void updateWithPlanSize(long bytes) {
        this.updateWithPlanSize.add(bytes);
    }

    public void updateWithoutPlanSize(long bytes) {
        this.updateWithoutPlanSize.add(bytes);
    }

    @Managed
    public double getResponseSizeBytes() {
        return this.responseSizeBytes.getAverage();
    }

    @Managed
    public double getStatusRoundTripMillis() {
        return this.statusRoundTripMillis.getAverage();
    }

    @Managed
    public long getStatusRoundTripCount() {
        return this.statusRoundTripMillis.getCount();
    }

    @Managed
    public double getUpdateRoundTripMillis() {
        return this.updateRoundTripMillis.getAverage();
    }

    @Managed
    public long getUpdateRoundTripCount() {
        return this.updateRoundTripMillis.getCount();
    }

    @Managed
    public double getInfoRoundTripMillis() {
        return this.infoRoundTripMillis.getAverage();
    }

    @Managed
    public long getInfoRoundTripCount() {
        return this.infoRoundTripMillis.getCount();
    }

    @Managed
    public long getRequestSuccess() {
        return this.requestSuccess;
    }

    @Managed
    public long getRequestFailure() {
        return this.requestFailure;
    }

    @Managed
    @Nested
    public DistributionStat getUpdateWithPlanSize() {
        return this.updateWithPlanSize;
    }

    @Managed
    @Nested
    public DistributionStat getUpdateWithoutPlanSize() {
        return this.updateWithoutPlanSize;
    }

    @ThreadSafe
    private static class IncrementalAverage {
        private volatile long count;
        private volatile double average;

        private IncrementalAverage() {
        }

        synchronized void add(long value) {
            ++this.count;
            this.average += ((double)value - this.average) / (double)this.count;
        }

        double getAverage() {
            return this.average;
        }

        long getCount() {
            return this.count;
        }
    }
}

