/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.server.protocol.Query;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.core.Response;

public final class QueryResourceUtil {
    private QueryResourceUtil() {
    }

    public static Response toResponse(Query query, QueryResults queryResults) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetCatalog().ifPresent(catalog -> response.header("X-Presto-Set-Catalog", catalog));
        query.getSetSchema().ifPresent(schema -> response.header("X-Presto-Set-Schema", schema));
        query.getSetSessionProperties().forEach((key, value) -> response.header("X-Presto-Set-Session", (Object)(key + '=' + QueryResourceUtil.urlEncode(value))));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getSetRoles().forEach((key, value) -> response.header("X-Presto-Set-Role", (Object)(key + '=' + QueryResourceUtil.urlEncode(value.toString()))));
        for (Map.Entry<String, String> entry : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = QueryResourceUtil.urlEncode(entry.getKey());
            String encodedValue = QueryResourceUtil.urlEncode(entry.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + '=' + encodedValue));
        }
        for (String name2 : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)QueryResourceUtil.urlEncode(name2));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

