/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.JsonExtract;
import io.airlift.slice.Slice;

public class JsonPath {
    private final JsonExtract.JsonExtractor<Slice> scalarExtractor;
    private final JsonExtract.JsonExtractor<Slice> objectExtractor;
    private final JsonExtract.JsonExtractor<Long> sizeExtractor;

    public JsonPath(String pattern) {
        this.scalarExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.ScalarValueJsonExtractor());
        this.objectExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonValueJsonExtractor());
        this.sizeExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonSizeExtractor());
    }

    public JsonExtract.JsonExtractor<Slice> getScalarExtractor() {
        return this.scalarExtractor;
    }

    public JsonExtract.JsonExtractor<Slice> getObjectExtractor() {
        return this.objectExtractor;
    }

    public JsonExtract.JsonExtractor<Long> getSizeExtractor() {
        return this.sizeExtractor;
    }
}

