/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class Int128ArrayBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 17;
    private static final String NAME = "INT128_ARRAY";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int128ArrayBlockEncodingBuffer.class).instanceSize();
    private byte[] valuesBuffer;
    private int valuesBufferIndex;
    private int estimatedValueBufferMaxCapacity;

    public Int128ArrayBlockEncodingBuffer(ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        throw new UnsupportedOperationException("accumulateSerializedRowSizes is not supported for fixed width types");
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendValuesToBuffer();
        this.appendNulls();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        Int128ArrayBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.bufferedPositionCount);
        this.serializeNullsTo(output);
        if (this.valuesBufferIndex > 0) {
            output.appendBytes(this.valuesBuffer, 0, this.valuesBufferIndex);
        }
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.valuesBufferIndex = 0;
        this.flushed = true;
        this.resetNullsBuffer();
    }

    @Override
    public void noMoreBatches() {
        super.noMoreBatches();
        if (this.flushed && this.valuesBuffer != null) {
            this.bufferAllocator.returnArray(this.valuesBuffer);
            this.valuesBuffer = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + 4 + this.valuesBufferIndex) + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedValueBufferMaxCapacity", this.estimatedValueBufferMaxCapacity).add("valuesBufferCapacity", this.valuesBuffer == null ? 0 : this.valuesBuffer.length).add("valuesBufferIndex", this.valuesBufferIndex).toString();
    }

    @Override
    @VisibleForTesting
    int getEstimatedValueBufferMaxCapacity() {
        return this.estimatedValueBufferMaxCapacity;
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        this.decodedBlock = (Block)this.mapPositionsToNestedBlock(decodedBlockNode).getDecodedBlock();
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction;
        this.setEstimatedNullsBufferMaxCapacity(Int128ArrayBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 1, 17));
        this.estimatedValueBufferMaxCapacity = Int128ArrayBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 16, 17);
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        for (int i = 0; i < positionCount; ++i) {
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + (positionOffsets[i + 1] - positionOffsets[i]) * 17;
        }
    }

    private void appendValuesToBuffer() {
        this.valuesBuffer = Arrays.ensureCapacity((byte[])this.valuesBuffer, (int)(this.valuesBufferIndex + this.batchSize * Unsafe.ARRAY_LONG_INDEX_SCALE * 2), (int)this.estimatedValueBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int[] positions = this.getPositions();
        if (this.decodedBlock.mayHaveNull()) {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int position = positions[i];
                long value = this.decodedBlock.getLong(position, 0);
                this.valuesBufferIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
                value = this.decodedBlock.getLong(position, 8);
                this.valuesBufferIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
                if (!this.decodedBlock.isNull(position)) continue;
                this.valuesBufferIndex -= Unsafe.ARRAY_LONG_INDEX_SCALE * 2;
            }
        } else {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int position = positions[i];
                long value = this.decodedBlock.getLong(position, 0);
                this.valuesBufferIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
                value = this.decodedBlock.getLong(position, 8);
                this.valuesBufferIndex = UncheckedByteArrays.setLongUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
            }
        }
    }
}

