/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.fixedhistogram;

import com.google.common.base.Preconditions;

class FixedHistogramUtils {
    private FixedHistogramUtils() {
    }

    public static void validateParameters(int bucketCount, double min, double max) {
        Preconditions.checkArgument((bucketCount >= 2 ? 1 : 0) != 0, (String)"bucketCount must be at least 2: %s", (int)bucketCount);
        Preconditions.checkArgument((min < max ? 1 : 0) != 0, (String)"min must be smaller than max: %s %s", (Object)min, (Object)max);
    }

    public static int getIndexForValue(int bucketCount, double min, double max, double value) {
        Preconditions.checkArgument((value >= min && value < max ? 1 : 0) != 0, (String)"value must be within range: %s [%s, %s]", (Object)value, (Object)min, (Object)max);
        return Math.min((int)((double)bucketCount * (value - min) / (max - min)), bucketCount - 1);
    }

    public static double getLeftValueForIndex(int bucketCount, double min, double max, int index) {
        return min + (double)index * (max - min) / (double)bucketCount;
    }

    public static double getRightValueForIndex(int bucketCount, double min, double max, int index) {
        return Math.min(max, FixedHistogramUtils.getLeftValueForIndex(bucketCount, min, max, index + 1));
    }
}

