/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.SetOfValues;
import com.facebook.presto.operator.aggregation.arrayagg.SetAggregationStateSerializer;
import com.facebook.presto.operator.aggregation.state.SetAggregationState;
import com.facebook.presto.operator.aggregation.state.SetAggregationStateFactory;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class SetUnionFunction
extends SqlAggregationFunction {
    public static final SetUnionFunction SET_UNION = new SetUnionFunction();
    private static final String NAME = "set_union";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "input", Type.class, ArrayType.class, SetAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "combine", SetAggregationState.class, SetAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "output", SetAggregationState.class, BlockBuilder.class);

    public SetUnionFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)")));
    }

    public String getDescription() {
        return "Given a column of array type, return an array of all the unique values contained in each of the arrays in the column";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Type elementType = boundVariables.getTypeVariable("T");
        ArrayType arrayType = (ArrayType)typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
        DynamicClassLoader classLoader = new DynamicClassLoader(SetUnionFunction.class.getClassLoader());
        SetAggregationStateSerializer stateSerializer = new SetAggregationStateSerializer(arrayType);
        SetAggregationStateFactory stateFactory = new SetAggregationStateFactory(elementType);
        Class<SetAggregationState> stateInterface = SetAggregationState.class;
        ImmutableList inputParameterMetadata = ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, elementType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, arrayType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)elementType.getTypeSignature())), (List<AggregationMetadata.ParameterMetadata>)inputParameterMetadata, INPUT_FUNCTION.bindTo(elementType).bindTo(arrayType), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, stateFactory)), (Type)arrayType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)elementType), (List<Type>)ImmutableList.of((Object)stateSerializer.getSerializedType()), (Type)arrayType, true, true, factory);
    }

    public static void input(Type elementType, ArrayType arrayType, SetAggregationState state, Block inputBlock, int position) {
        SetOfValues set = state.get();
        if (set == null) {
            set = new SetOfValues(elementType);
            state.set(set);
        }
        long startSize = set.estimatedInMemorySize();
        Block arrayBlock = arrayType.getObject(inputBlock, position);
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            set.add(arrayBlock, i);
        }
        state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
    }

    public static void combine(SetAggregationState state, SetAggregationState otherState) {
        if (state.get() != null && otherState.get() != null) {
            SetOfValues otherSet = otherState.get();
            Block otherValues = otherSet.getvalues();
            SetOfValues set = state.get();
            long startSize = set.estimatedInMemorySize();
            for (int i = 0; i < otherValues.getPositionCount(); ++i) {
                set.add(otherValues, i);
            }
            state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(SetAggregationState state, BlockBuilder out) {
        SetOfValues set = state.get();
        if (set == null) {
            out.appendNull();
        } else {
            set.serialize(out);
        }
    }
}

