/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.PipelineStatus;
import com.facebook.presto.operator.TaskContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class PipelineContext {
    private final TaskContext taskContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final int pipelineId;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final boolean partitioned;
    private final List<DriverContext> drivers = new CopyOnWriteArrayList<DriverContext>();
    private final AtomicInteger totalSplits = new AtomicInteger();
    private final AtomicInteger completedDrivers = new AtomicInteger();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionEndTime = new AtomicReference();
    private final Distribution queuedTime = new Distribution();
    private final Distribution elapsedTime = new Distribution();
    private final AtomicLong totalScheduledTime = new AtomicLong();
    private final AtomicLong totalCpuTime = new AtomicLong();
    private final AtomicLong totalBlockedTime = new AtomicLong();
    private final AtomicLong totalAllocation = new AtomicLong();
    private final CounterStat rawInputDataSize = new CounterStat();
    private final CounterStat rawInputPositions = new CounterStat();
    private final CounterStat processedInputDataSize = new CounterStat();
    private final CounterStat processedInputPositions = new CounterStat();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong physicalWrittenDataSize = new AtomicLong();
    private final ConcurrentMap<Integer, OperatorStats> operatorSummaries = new ConcurrentHashMap<Integer, OperatorStats>();
    private final MemoryTrackingContext pipelineMemoryContext;

    public PipelineContext(int pipelineId, TaskContext taskContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, MemoryTrackingContext pipelineMemoryContext, boolean inputPipeline, boolean outputPipeline, boolean partitioned) {
        this.pipelineId = pipelineId;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        this.partitioned = partitioned;
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.pipelineMemoryContext = Objects.requireNonNull(pipelineMemoryContext, "pipelineMemoryContext is null");
        pipelineMemoryContext.initializeLocalMemoryContexts(ExchangeOperator.class.getSimpleName());
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public TaskId getTaskId() {
        return this.taskContext.getTaskId();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    public DriverContext addDriverContext() {
        return this.addDriverContext(Lifespan.taskWide());
    }

    public DriverContext addDriverContext(Lifespan lifespan) {
        DriverContext driverContext = new DriverContext(this, this.notificationExecutor, this.yieldExecutor, this.pipelineMemoryContext.newMemoryTrackingContext(), lifespan);
        this.drivers.add(driverContext);
        return driverContext;
    }

    public Session getSession() {
        return this.taskContext.getSession();
    }

    public void splitsAdded(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        this.totalSplits.addAndGet(count);
    }

    public void driverFinished(DriverContext driverContext) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        if (!this.drivers.remove(driverContext)) {
            throw new IllegalArgumentException("Unknown driver " + driverContext);
        }
        this.lastExecutionEndTime.set(DateTime.now());
        DriverStats driverStats = driverContext.getDriverStats();
        this.completedDrivers.getAndIncrement();
        this.queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
        this.elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalScheduledTime.getAndAdd(driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalCpuTime.getAndAdd(driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalBlockedTime.getAndAdd(driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalAllocation.getAndAdd(driverStats.getTotalAllocation().toBytes());
        List<OperatorStats> operators = driverStats.getOperatorStats();
        for (OperatorStats operator : operators) {
            this.operatorSummaries.compute(operator.getOperatorId(), (operatorId, summaryStats) -> summaryStats == null ? operator : summaryStats.add(operator));
        }
        this.rawInputDataSize.update(driverStats.getRawInputDataSize().toBytes());
        this.rawInputPositions.update(driverStats.getRawInputPositions());
        this.processedInputDataSize.update(driverStats.getProcessedInputDataSize().toBytes());
        this.processedInputPositions.update(driverStats.getProcessedInputPositions());
        this.outputDataSize.update(driverStats.getOutputDataSize().toBytes());
        this.outputPositions.update(driverStats.getOutputPositions());
        this.physicalWrittenDataSize.getAndAdd(driverStats.getPhysicalWrittenDataSize().toBytes());
    }

    public void start() {
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.lastExecutionStartTime.set(now);
        this.taskContext.start();
    }

    public void failed(Throwable cause) {
        this.taskContext.failed(cause);
    }

    public boolean isDone() {
        return this.taskContext.isDone();
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        return this.taskContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.taskContext.freeSpill(bytes);
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return this.pipelineMemoryContext.localSystemMemoryContext();
    }

    public void moreMemoryAvailable() {
        this.drivers.forEach(DriverContext::moreMemoryAvailable);
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.taskContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.taskContext.isCpuTimerEnabled();
    }

    public boolean isPerOperatorAllocationTrackingEnabled() {
        return this.taskContext.isPerOperatorAllocationTrackingEnabled();
    }

    public boolean isAllocationTrackingEnabled() {
        return this.taskContext.isAllocationTrackingEnabled();
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputPositions());
        }
        return stat;
    }

    public long getPhysicalWrittenDataSize() {
        return this.drivers.stream().mapToLong(DriverContext::getPphysicalWrittenDataSize).sum();
    }

    public PipelineStatus getPipelineStatus() {
        return PipelineContext.getPipelineStatus(this.drivers.iterator(), this.totalSplits.get(), this.completedDrivers.get(), this.partitioned);
    }

    public PipelineStats getPipelineStats() {
        if (this.taskContext.getState().isDone()) {
            DateTime now = DateTime.now();
            this.executionStartTime.compareAndSet(null, now);
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.lastExecutionEndTime.compareAndSet(null, now);
        }
        int completedDrivers = this.completedDrivers.get();
        ImmutableList driverContexts = ImmutableList.copyOf(this.drivers);
        int totalSplits = this.totalSplits.get();
        PipelineStatus pipelineStatus = PipelineContext.getPipelineStatus(driverContexts.iterator(), totalSplits, completedDrivers, this.partitioned);
        int totalDrivers = completedDrivers + driverContexts.size();
        Distribution queuedTime = new Distribution(this.queuedTime);
        Distribution elapsedTime = new Distribution(this.elapsedTime);
        long totalScheduledTime = this.totalScheduledTime.get();
        long totalCpuTime = this.totalCpuTime.get();
        long totalBlockedTime = this.totalBlockedTime.get();
        long totalAllocation = this.totalAllocation.get();
        long rawInputDataSize = this.rawInputDataSize.getTotalCount();
        long rawInputPositions = this.rawInputPositions.getTotalCount();
        long processedInputDataSize = this.processedInputDataSize.getTotalCount();
        long processedInputPositions = this.processedInputPositions.getTotalCount();
        long outputDataSize = this.outputDataSize.getTotalCount();
        long outputPositions = this.outputPositions.getTotalCount();
        long physicalWrittenDataSize = this.physicalWrittenDataSize.get();
        ArrayList<DriverStats> drivers = new ArrayList<DriverStats>();
        ArrayListMultimap runningOperators = ArrayListMultimap.create();
        for (Object driverContext : driverContexts) {
            DriverStats driverStats = ((DriverContext)driverContext).getDriverStats();
            drivers.add(driverStats);
            queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
            elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
            totalScheduledTime += driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            totalAllocation += driverStats.getTotalAllocation().toBytes();
            ImmutableList operators = ImmutableList.copyOf((Iterable)Iterables.transform(((DriverContext)driverContext).getOperatorContexts(), OperatorContext::getOperatorStats));
            for (OperatorStats operator : operators) {
                runningOperators.put((Object)operator.getOperatorId(), (Object)operator);
            }
            rawInputDataSize += driverStats.getRawInputDataSize().toBytes();
            rawInputPositions += driverStats.getRawInputPositions();
            processedInputDataSize += driverStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += driverStats.getProcessedInputPositions();
            outputDataSize += driverStats.getOutputDataSize().toBytes();
            outputPositions += driverStats.getOutputPositions();
            physicalWrittenDataSize += driverStats.getPhysicalWrittenDataSize().toBytes();
        }
        TreeMap<Integer, OperatorStats> operatorSummaries = new TreeMap<Integer, OperatorStats>(this.operatorSummaries);
        for (Map.Entry entry : runningOperators.entries()) {
            OperatorStats current = operatorSummaries.get(entry.getKey());
            current = current == null ? (OperatorStats)entry.getValue() : current.add((OperatorStats)entry.getValue());
            operatorSummaries.put((Integer)entry.getKey(), current);
        }
        Set runningDriverStats = (Set)drivers.stream().filter(driver -> driver.getEndTime() == null && driver.getStartTime() != null).collect(ImmutableSet.toImmutableSet());
        ImmutableSet blockedReasons = (ImmutableSet)runningDriverStats.stream().flatMap(driver -> driver.getBlockedReasons().stream()).collect(ImmutableSet.toImmutableSet());
        boolean fullyBlocked = !runningDriverStats.isEmpty() && runningDriverStats.stream().allMatch(DriverStats::isFullyBlocked);
        return new PipelineStats(this.pipelineId, this.executionStartTime.get(), this.lastExecutionStartTime.get(), this.lastExecutionEndTime.get(), this.inputPipeline, this.outputPipeline, totalDrivers, pipelineStatus.getQueuedDrivers(), pipelineStatus.getQueuedPartitionedDrivers(), pipelineStatus.getRunningDrivers(), pipelineStatus.getRunningPartitionedDrivers(), pipelineStatus.getBlockedDrivers(), completedDrivers, DataSize.succinctBytes((long)this.pipelineMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.pipelineMemoryContext.getRevocableMemory()), DataSize.succinctBytes((long)this.pipelineMemoryContext.getSystemMemory()), queuedTime.snapshot(), elapsedTime.snapshot(), Duration.succinctNanos((long)totalScheduledTime), Duration.succinctNanos((long)totalCpuTime), Duration.succinctNanos((long)totalBlockedTime), fullyBlocked, (Set<BlockedReason>)blockedReasons, DataSize.succinctBytes((long)totalAllocation), DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), (List<OperatorStats>)ImmutableList.copyOf(operatorSummaries.values()), drivers);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitPipelineContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.drivers.stream().map(driver -> driver.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public MemoryTrackingContext getPipelineMemoryContext() {
        return this.pipelineMemoryContext;
    }

    private static PipelineStatus getPipelineStatus(Iterator<DriverContext> driverContextsIterator, int totalSplits, int completedDrivers, boolean partitioned) {
        int queuedDrivers;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int physicallyQueuedDrivers = 0;
        while (driverContextsIterator.hasNext()) {
            DriverContext driverContext = driverContextsIterator.next();
            if (!driverContext.isExecutionStarted()) {
                ++physicallyQueuedDrivers;
                continue;
            }
            if (driverContext.isFullyBlocked()) {
                ++blockedDrivers;
                continue;
            }
            ++runningDrivers;
        }
        if (partitioned) {
            queuedDrivers = totalSplits - runningDrivers - blockedDrivers - completedDrivers;
            if (queuedDrivers < 0) {
                queuedDrivers = 0;
            }
        } else {
            queuedDrivers = physicallyQueuedDrivers;
        }
        return new PipelineStatus(queuedDrivers, runningDrivers, blockedDrivers, partitioned ? queuedDrivers : 0, partitioned ? runningDrivers : 0);
    }
}

