/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionHandle;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SpecializedFunctionKey;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregation;
import com.facebook.presto.operator.aggregation.ApproximateDoublePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.ApproximateRealPercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateRealPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.ApproximateSetAggregation;
import com.facebook.presto.operator.aggregation.ArbitraryAggregationFunction;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.BitwiseAndAggregation;
import com.facebook.presto.operator.aggregation.BitwiseOrAggregation;
import com.facebook.presto.operator.aggregation.BooleanAndAggregation;
import com.facebook.presto.operator.aggregation.BooleanOrAggregation;
import com.facebook.presto.operator.aggregation.CentralMomentsAggregation;
import com.facebook.presto.operator.aggregation.ChecksumAggregationFunction;
import com.facebook.presto.operator.aggregation.ClassificationFallOutAggregation;
import com.facebook.presto.operator.aggregation.ClassificationMissRateAggregation;
import com.facebook.presto.operator.aggregation.ClassificationPrecisionAggregation;
import com.facebook.presto.operator.aggregation.ClassificationRecallAggregation;
import com.facebook.presto.operator.aggregation.ClassificationThresholdsAggregation;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.CountColumn;
import com.facebook.presto.operator.aggregation.CountIfAggregation;
import com.facebook.presto.operator.aggregation.DecimalAverageAggregation;
import com.facebook.presto.operator.aggregation.DecimalSumAggregation;
import com.facebook.presto.operator.aggregation.DefaultApproximateCountDistinctAggregation;
import com.facebook.presto.operator.aggregation.DoubleCorrelationAggregation;
import com.facebook.presto.operator.aggregation.DoubleCovarianceAggregation;
import com.facebook.presto.operator.aggregation.DoubleHistogramAggregation;
import com.facebook.presto.operator.aggregation.DoubleRegressionAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.EntropyAggregation;
import com.facebook.presto.operator.aggregation.GeometricMeanAggregations;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.IntervalDayToSecondAverageAggregation;
import com.facebook.presto.operator.aggregation.IntervalDayToSecondSumAggregation;
import com.facebook.presto.operator.aggregation.IntervalYearToMonthAverageAggregation;
import com.facebook.presto.operator.aggregation.IntervalYearToMonthSumAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.MapAggregationFunction;
import com.facebook.presto.operator.aggregation.MapUnionAggregation;
import com.facebook.presto.operator.aggregation.MaxAggregationFunction;
import com.facebook.presto.operator.aggregation.MaxDataSizeForStats;
import com.facebook.presto.operator.aggregation.MaxNAggregationFunction;
import com.facebook.presto.operator.aggregation.MergeHyperLogLogAggregation;
import com.facebook.presto.operator.aggregation.MergeQuantileDigestFunction;
import com.facebook.presto.operator.aggregation.MergeTDigestFunction;
import com.facebook.presto.operator.aggregation.MinAggregationFunction;
import com.facebook.presto.operator.aggregation.MinNAggregationFunction;
import com.facebook.presto.operator.aggregation.QuantileDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.RealAverageAggregation;
import com.facebook.presto.operator.aggregation.RealCorrelationAggregation;
import com.facebook.presto.operator.aggregation.RealCovarianceAggregation;
import com.facebook.presto.operator.aggregation.RealGeometricMeanAggregations;
import com.facebook.presto.operator.aggregation.RealHistogramAggregation;
import com.facebook.presto.operator.aggregation.RealRegressionAggregation;
import com.facebook.presto.operator.aggregation.RealSumAggregation;
import com.facebook.presto.operator.aggregation.ReduceAggregationFunction;
import com.facebook.presto.operator.aggregation.SumDataSizeForStats;
import com.facebook.presto.operator.aggregation.TDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.VarianceAggregation;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationFunction;
import com.facebook.presto.operator.aggregation.arrayagg.SetAggregationFunction;
import com.facebook.presto.operator.aggregation.arrayagg.SetUnionFunction;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyAggregation;
import com.facebook.presto.operator.aggregation.histogram.Histogram;
import com.facebook.presto.operator.aggregation.minmaxby.MaxByAggregationFunction;
import com.facebook.presto.operator.aggregation.minmaxby.MaxByNAggregationFunction;
import com.facebook.presto.operator.aggregation.minmaxby.MinByAggregationFunction;
import com.facebook.presto.operator.aggregation.minmaxby.MinByNAggregationFunction;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationFunction;
import com.facebook.presto.operator.scalar.ArrayAllMatchFunction;
import com.facebook.presto.operator.scalar.ArrayAnyMatchFunction;
import com.facebook.presto.operator.scalar.ArrayCardinalityFunction;
import com.facebook.presto.operator.scalar.ArrayCombinationsFunction;
import com.facebook.presto.operator.scalar.ArrayConcatFunction;
import com.facebook.presto.operator.scalar.ArrayConstructor;
import com.facebook.presto.operator.scalar.ArrayContains;
import com.facebook.presto.operator.scalar.ArrayDistinctFromOperator;
import com.facebook.presto.operator.scalar.ArrayDistinctFunction;
import com.facebook.presto.operator.scalar.ArrayElementAtFunction;
import com.facebook.presto.operator.scalar.ArrayEqualOperator;
import com.facebook.presto.operator.scalar.ArrayExceptFunction;
import com.facebook.presto.operator.scalar.ArrayFilterFunction;
import com.facebook.presto.operator.scalar.ArrayFlattenFunction;
import com.facebook.presto.operator.scalar.ArrayFunctions;
import com.facebook.presto.operator.scalar.ArrayGreaterThanOperator;
import com.facebook.presto.operator.scalar.ArrayGreaterThanOrEqualOperator;
import com.facebook.presto.operator.scalar.ArrayHashCodeOperator;
import com.facebook.presto.operator.scalar.ArrayIndeterminateOperator;
import com.facebook.presto.operator.scalar.ArrayIntersectFunction;
import com.facebook.presto.operator.scalar.ArrayJoin;
import com.facebook.presto.operator.scalar.ArrayLessThanOperator;
import com.facebook.presto.operator.scalar.ArrayLessThanOrEqualOperator;
import com.facebook.presto.operator.scalar.ArrayMaxFunction;
import com.facebook.presto.operator.scalar.ArrayMinFunction;
import com.facebook.presto.operator.scalar.ArrayNgramsFunction;
import com.facebook.presto.operator.scalar.ArrayNoneMatchFunction;
import com.facebook.presto.operator.scalar.ArrayNotEqualOperator;
import com.facebook.presto.operator.scalar.ArrayPositionFunction;
import com.facebook.presto.operator.scalar.ArrayReduceFunction;
import com.facebook.presto.operator.scalar.ArrayRemoveFunction;
import com.facebook.presto.operator.scalar.ArrayReverseFunction;
import com.facebook.presto.operator.scalar.ArrayShuffleFunction;
import com.facebook.presto.operator.scalar.ArraySliceFunction;
import com.facebook.presto.operator.scalar.ArraySortComparatorFunction;
import com.facebook.presto.operator.scalar.ArraySortFunction;
import com.facebook.presto.operator.scalar.ArraySubscriptOperator;
import com.facebook.presto.operator.scalar.ArrayToArrayCast;
import com.facebook.presto.operator.scalar.ArrayToElementConcatFunction;
import com.facebook.presto.operator.scalar.ArrayToJsonCast;
import com.facebook.presto.operator.scalar.ArrayTransformFunction;
import com.facebook.presto.operator.scalar.ArrayUnionFunction;
import com.facebook.presto.operator.scalar.ArraysOverlapFunction;
import com.facebook.presto.operator.scalar.BitwiseFunctions;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.CastFromUnknownOperator;
import com.facebook.presto.operator.scalar.CharacterStringCasts;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.operator.scalar.ConcatFunction;
import com.facebook.presto.operator.scalar.DataSizeFunctions;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.ElementToArrayConcatFunction;
import com.facebook.presto.operator.scalar.EmptyMapConstructor;
import com.facebook.presto.operator.scalar.FailureFunction;
import com.facebook.presto.operator.scalar.Greatest;
import com.facebook.presto.operator.scalar.HmacFunctions;
import com.facebook.presto.operator.scalar.HyperLogLogFunctions;
import com.facebook.presto.operator.scalar.IdentityCast;
import com.facebook.presto.operator.scalar.IpPrefixFunctions;
import com.facebook.presto.operator.scalar.JoniRegexpCasts;
import com.facebook.presto.operator.scalar.JoniRegexpFunctions;
import com.facebook.presto.operator.scalar.JoniRegexpReplaceLambdaFunction;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.JsonOperators;
import com.facebook.presto.operator.scalar.JsonStringToArrayCast;
import com.facebook.presto.operator.scalar.JsonStringToMapCast;
import com.facebook.presto.operator.scalar.JsonStringToRowCast;
import com.facebook.presto.operator.scalar.JsonToArrayCast;
import com.facebook.presto.operator.scalar.JsonToMapCast;
import com.facebook.presto.operator.scalar.JsonToRowCast;
import com.facebook.presto.operator.scalar.Least;
import com.facebook.presto.operator.scalar.MapCardinalityFunction;
import com.facebook.presto.operator.scalar.MapConcatFunction;
import com.facebook.presto.operator.scalar.MapConstructor;
import com.facebook.presto.operator.scalar.MapDistinctFromOperator;
import com.facebook.presto.operator.scalar.MapElementAtFunction;
import com.facebook.presto.operator.scalar.MapEntriesFunction;
import com.facebook.presto.operator.scalar.MapEqualOperator;
import com.facebook.presto.operator.scalar.MapFilterFunction;
import com.facebook.presto.operator.scalar.MapFromEntriesFunction;
import com.facebook.presto.operator.scalar.MapHashCodeOperator;
import com.facebook.presto.operator.scalar.MapIndeterminateOperator;
import com.facebook.presto.operator.scalar.MapKeys;
import com.facebook.presto.operator.scalar.MapNotEqualOperator;
import com.facebook.presto.operator.scalar.MapSubscriptOperator;
import com.facebook.presto.operator.scalar.MapToJsonCast;
import com.facebook.presto.operator.scalar.MapToMapCast;
import com.facebook.presto.operator.scalar.MapTransformKeyFunction;
import com.facebook.presto.operator.scalar.MapTransformValueFunction;
import com.facebook.presto.operator.scalar.MapValues;
import com.facebook.presto.operator.scalar.MapZipWithFunction;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.MultimapFromEntriesFunction;
import com.facebook.presto.operator.scalar.QuantileDigestFunctions;
import com.facebook.presto.operator.scalar.Re2JCastToRegexpFunction;
import com.facebook.presto.operator.scalar.Re2JRegexpFunctions;
import com.facebook.presto.operator.scalar.Re2JRegexpReplaceLambdaFunction;
import com.facebook.presto.operator.scalar.RepeatFunction;
import com.facebook.presto.operator.scalar.RowDistinctFromOperator;
import com.facebook.presto.operator.scalar.RowEqualOperator;
import com.facebook.presto.operator.scalar.RowGreaterThanOperator;
import com.facebook.presto.operator.scalar.RowGreaterThanOrEqualOperator;
import com.facebook.presto.operator.scalar.RowHashCodeOperator;
import com.facebook.presto.operator.scalar.RowIndeterminateOperator;
import com.facebook.presto.operator.scalar.RowLessThanOperator;
import com.facebook.presto.operator.scalar.RowLessThanOrEqualOperator;
import com.facebook.presto.operator.scalar.RowNotEqualOperator;
import com.facebook.presto.operator.scalar.RowToJsonCast;
import com.facebook.presto.operator.scalar.RowToRowCast;
import com.facebook.presto.operator.scalar.SequenceFunction;
import com.facebook.presto.operator.scalar.SessionFunctions;
import com.facebook.presto.operator.scalar.SplitToMapFunction;
import com.facebook.presto.operator.scalar.SplitToMultimapFunction;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.operator.scalar.TDigestFunctions;
import com.facebook.presto.operator.scalar.TryCastFunction;
import com.facebook.presto.operator.scalar.TryFunction;
import com.facebook.presto.operator.scalar.TypeOfFunction;
import com.facebook.presto.operator.scalar.UrlFunctions;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.operator.scalar.WilsonInterval;
import com.facebook.presto.operator.scalar.WordStemFunction;
import com.facebook.presto.operator.scalar.ZipFunction;
import com.facebook.presto.operator.scalar.ZipWithFunction;
import com.facebook.presto.operator.scalar.sql.ArrayArithmeticFunctions;
import com.facebook.presto.operator.scalar.sql.MapNormalizeFunction;
import com.facebook.presto.operator.window.AggregateWindowFunction;
import com.facebook.presto.operator.window.CumulativeDistributionFunction;
import com.facebook.presto.operator.window.DenseRankFunction;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.LagFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.LeadFunction;
import com.facebook.presto.operator.window.NTileFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.PercentRankFunction;
import com.facebook.presto.operator.window.RankFunction;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.SqlWindowFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.CharOperators;
import com.facebook.presto.type.ColorOperators;
import com.facebook.presto.type.DateOperators;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.DecimalCasts;
import com.facebook.presto.type.DecimalInequalityOperators;
import com.facebook.presto.type.DecimalOperators;
import com.facebook.presto.type.DecimalSaturatedFloorCasts;
import com.facebook.presto.type.DecimalToDecimalCasts;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.HyperLogLogOperators;
import com.facebook.presto.type.IntegerOperators;
import com.facebook.presto.type.IntervalDayTimeOperators;
import com.facebook.presto.type.IntervalYearMonthOperators;
import com.facebook.presto.type.IpAddressOperators;
import com.facebook.presto.type.IpPrefixOperators;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.type.QuantileDigestOperators;
import com.facebook.presto.type.RealOperators;
import com.facebook.presto.type.SmallintOperators;
import com.facebook.presto.type.TDigestOperators;
import com.facebook.presto.type.TimeOperators;
import com.facebook.presto.type.TimeWithTimeZoneOperators;
import com.facebook.presto.type.TimestampOperators;
import com.facebook.presto.type.TimestampWithTimeZoneOperators;
import com.facebook.presto.type.TinyintOperators;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownOperators;
import com.facebook.presto.type.VarbinaryOperators;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.type.khyperloglog.KHyperLogLogAggregationFunction;
import com.facebook.presto.type.khyperloglog.KHyperLogLogFunctions;
import com.facebook.presto.type.khyperloglog.KHyperLogLogOperators;
import com.facebook.presto.type.khyperloglog.MergeKHyperLogLogAggregationFunction;
import com.facebook.presto.type.setdigest.BuildSetDigestAggregation;
import com.facebook.presto.type.setdigest.MergeSetDigestAggregation;
import com.facebook.presto.type.setdigest.SetDigestFunctions;
import com.facebook.presto.type.setdigest.SetDigestOperators;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BuiltInFunctionNamespaceManager
implements FunctionNamespaceManager<SqlFunction> {
    public static final CatalogSchemaName DEFAULT_NAMESPACE = new CatalogSchemaName("presto", "default");
    public static final String ID = "builtin";
    private final TypeManager typeManager;
    private final LoadingCache<Signature, SpecializedFunctionKey> specializedFunctionKeyCache;
    private final LoadingCache<SpecializedFunctionKey, ScalarFunctionImplementation> specializedScalarCache;
    private final LoadingCache<SpecializedFunctionKey, InternalAggregationFunction> specializedAggregationCache;
    private final LoadingCache<SpecializedFunctionKey, WindowFunctionSupplier> specializedWindowCache;
    private final MagicLiteralFunction magicLiteralFunction;
    private volatile FunctionMap functions = new FunctionMap();

    public BuiltInFunctionNamespaceManager(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig, FunctionManager functionManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.magicLiteralFunction = new MagicLiteralFunction(blockEncodingSerde);
        this.specializedFunctionKeyCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::doGetSpecializedFunctionKey));
        this.specializedScalarCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> {
            Preconditions.checkArgument((key.getFunction() instanceof SqlScalarFunction || key.getFunction() instanceof SqlInvokedFunction ? 1 : 0) != 0, (String)"Unsupported scalar function class: %s", key.getFunction().getClass());
            return key.getFunction() instanceof SqlScalarFunction ? ((SqlScalarFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, functionManager) : new SqlInvokedScalarFunctionImplementation(((SqlInvokedFunction)key.getFunction()).getBody());
        }));
        this.specializedAggregationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> ((SqlAggregationFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, functionManager)));
        this.specializedWindowCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> {
            if (key.getFunction() instanceof SqlAggregationFunction) {
                return AggregateWindowFunction.supplier(key.getFunction().getSignature(), (InternalAggregationFunction)this.specializedAggregationCache.getUnchecked(key));
            }
            return ((SqlWindowFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, functionManager);
        }));
        FunctionListBuilder builder = new FunctionListBuilder().window(RowNumberFunction.class).window(RankFunction.class).window(DenseRankFunction.class).window(PercentRankFunction.class).window(CumulativeDistributionFunction.class).window(NTileFunction.class).window(FirstValueFunction.class).window(LastValueFunction.class).window(NthValueFunction.class).window(LagFunction.class).window(LeadFunction.class).aggregate(ApproximateCountDistinctAggregation.class).aggregate(DefaultApproximateCountDistinctAggregation.class).aggregate(SumDataSizeForStats.class).aggregate(MaxDataSizeForStats.class).aggregates(CountAggregation.class).aggregates(VarianceAggregation.class).aggregates(CentralMomentsAggregation.class).aggregates(ApproximateLongPercentileAggregations.class).aggregates(ApproximateLongPercentileArrayAggregations.class).aggregates(ApproximateDoublePercentileAggregations.class).aggregates(ApproximateDoublePercentileArrayAggregations.class).aggregates(ApproximateRealPercentileAggregations.class).aggregates(ApproximateRealPercentileArrayAggregations.class).aggregates(CountIfAggregation.class).aggregates(BooleanAndAggregation.class).aggregates(BooleanOrAggregation.class).aggregates(DoubleSumAggregation.class).aggregates(RealSumAggregation.class).aggregates(LongSumAggregation.class).aggregates(IntervalDayToSecondSumAggregation.class).aggregates(IntervalYearToMonthSumAggregation.class).aggregates(AverageAggregations.class).function(RealAverageAggregation.REAL_AVERAGE_AGGREGATION).aggregates(IntervalDayToSecondAverageAggregation.class).aggregates(IntervalYearToMonthAverageAggregation.class).aggregates(DifferentialEntropyAggregation.class).aggregates(EntropyAggregation.class).aggregates(GeometricMeanAggregations.class).aggregates(RealGeometricMeanAggregations.class).aggregates(MergeHyperLogLogAggregation.class).aggregates(ApproximateSetAggregation.class).functions(QuantileDigestAggregationFunction.QDIGEST_AGG, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT_AND_ERROR).function(MergeQuantileDigestFunction.MERGE).aggregates(DoubleHistogramAggregation.class).aggregates(RealHistogramAggregation.class).aggregates(DoubleCovarianceAggregation.class).aggregates(RealCovarianceAggregation.class).aggregates(DoubleRegressionAggregation.class).aggregates(RealRegressionAggregation.class).aggregates(DoubleCorrelationAggregation.class).aggregates(RealCorrelationAggregation.class).aggregates(BitwiseOrAggregation.class).aggregates(BitwiseAndAggregation.class).aggregates(ClassificationMissRateAggregation.class).aggregates(ClassificationFallOutAggregation.class).aggregates(ClassificationPrecisionAggregation.class).aggregates(ClassificationRecallAggregation.class).aggregates(ClassificationThresholdsAggregation.class).scalar(RepeatFunction.class).scalars(SequenceFunction.class).scalars(SessionFunctions.class).scalars(StringFunctions.class).scalars(WordStemFunction.class).scalar(SplitToMapFunction.ResolveDuplicateKeys.class).scalar(SplitToMapFunction.FailOnDuplicateKeys.class).scalar(SplitToMultimapFunction.class).scalars(VarbinaryFunctions.class).scalars(UrlFunctions.class).scalars(MathFunctions.class).scalar(MathFunctions.Abs.class).scalar(MathFunctions.Sign.class).scalar(MathFunctions.Round.class).scalar(MathFunctions.RoundN.class).scalar(MathFunctions.Truncate.class).scalar(MathFunctions.TruncateN.class).scalar(MathFunctions.Ceiling.class).scalar(MathFunctions.Floor.class).scalars(BitwiseFunctions.class).scalars(DateTimeFunctions.class).scalars(JsonFunctions.class).scalars(ColorFunctions.class).scalars(ColorOperators.class).scalar(ColorOperators.ColorDistinctFromOperator.class).scalars(HyperLogLogFunctions.class).scalars(QuantileDigestFunctions.class).scalars(UnknownOperators.class).scalar(UnknownOperators.UnknownDistinctFromOperator.class).scalars(BooleanOperators.class).scalar(BooleanOperators.BooleanDistinctFromOperator.class).scalars(BigintOperators.class).scalar(BigintOperators.BigintDistinctFromOperator.class).scalars(IntegerOperators.class).scalar(IntegerOperators.IntegerDistinctFromOperator.class).scalars(SmallintOperators.class).scalar(SmallintOperators.SmallintDistinctFromOperator.class).scalars(TinyintOperators.class).scalar(TinyintOperators.TinyintDistinctFromOperator.class).scalars(DoubleOperators.class).scalar(DoubleOperators.DoubleDistinctFromOperator.class).scalars(RealOperators.class).scalar(RealOperators.RealDistinctFromOperator.class).scalars(VarcharOperators.class).scalar(VarcharOperators.VarcharDistinctFromOperator.class).scalars(VarbinaryOperators.class).scalar(VarbinaryOperators.VarbinaryDistinctFromOperator.class).scalars(DateOperators.class).scalar(DateOperators.DateDistinctFromOperator.class).scalars(TimeOperators.class).scalar(TimeOperators.TimeDistinctFromOperator.class).scalars(TimestampOperators.class).scalar(TimestampOperators.TimestampDistinctFromOperator.class).scalars(IntervalDayTimeOperators.class).scalar(IntervalDayTimeOperators.IntervalDayTimeDistinctFromOperator.class).scalars(IntervalYearMonthOperators.class).scalar(IntervalYearMonthOperators.IntervalYearMonthDistinctFromOperator.class).scalars(TimeWithTimeZoneOperators.class).scalar(TimeWithTimeZoneOperators.TimeWithTimeZoneDistinctFromOperator.class).scalars(TimestampWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.TimestampWithTimeZoneDistinctFromOperator.class).scalars(DateTimeOperators.class).scalars(HyperLogLogOperators.class).scalars(QuantileDigestOperators.class).scalars(IpAddressOperators.class).scalar(IpAddressOperators.IpAddressDistinctFromOperator.class).scalars(IpPrefixFunctions.class).scalars(IpPrefixOperators.class).scalar(IpPrefixOperators.IpPrefixDistinctFromOperator.class).scalars(LikeFunctions.class).scalars(ArrayFunctions.class).scalars(HmacFunctions.class).scalars(DataSizeFunctions.class).scalar(ArrayCardinalityFunction.class).scalar(ArrayContains.class).scalar(ArrayFilterFunction.class).scalar(ArrayPositionFunction.class).scalars(CombineHashFunction.class).scalars(JsonOperators.class).scalar(JsonOperators.JsonDistinctFromOperator.class).scalars(FailureFunction.class).scalars(JoniRegexpCasts.class).scalars(CharacterStringCasts.class).scalars(CharOperators.class).scalar(CharOperators.CharDistinctFromOperator.class).scalar(DecimalOperators.Negation.class).scalar(DecimalOperators.HashCode.class).scalar(DecimalOperators.Indeterminate.class).scalar(DecimalOperators.XxHash64Operator.class).functions(IdentityCast.IDENTITY_CAST, CastFromUnknownOperator.CAST_FROM_UNKNOWN).scalar(ArrayLessThanOperator.class).scalar(ArrayLessThanOrEqualOperator.class).scalar(ArrayRemoveFunction.class).scalar(ArrayGreaterThanOperator.class).scalar(ArrayGreaterThanOrEqualOperator.class).scalar(ArrayElementAtFunction.class).scalar(ArraySortFunction.class).scalar(ArraySortComparatorFunction.class).scalar(ArrayShuffleFunction.class).scalar(ArrayReverseFunction.class).scalar(ArrayMinFunction.class).scalar(ArrayMaxFunction.class).scalar(ArrayDistinctFunction.class).scalar(ArrayNotEqualOperator.class).scalar(ArrayEqualOperator.class).scalar(ArrayHashCodeOperator.class).scalar(ArrayIntersectFunction.class).scalar(ArraysOverlapFunction.class).scalar(ArrayDistinctFromOperator.class).scalar(ArrayUnionFunction.class).scalar(ArrayExceptFunction.class).scalar(ArraySliceFunction.class).scalar(ArrayIndeterminateOperator.class).scalar(ArrayCombinationsFunction.class).scalar(ArrayNgramsFunction.class).scalar(ArrayAllMatchFunction.class).scalar(ArrayAnyMatchFunction.class).scalar(ArrayNoneMatchFunction.class).scalar(MapDistinctFromOperator.class).scalar(MapEqualOperator.class).scalar(MapEntriesFunction.class).scalar(MapFromEntriesFunction.class).scalar(MultimapFromEntriesFunction.class).scalar(MapNotEqualOperator.class).scalar(MapKeys.class).scalar(MapValues.class).scalar(MapCardinalityFunction.class).scalar(EmptyMapConstructor.class).scalar(MapIndeterminateOperator.class).scalar(TypeOfFunction.class).scalar(TryFunction.class).functions(ZipWithFunction.ZIP_WITH_FUNCTION, MapZipWithFunction.MAP_ZIP_WITH_FUNCTION).functions(ZipFunction.ZIP_FUNCTIONS).functions(ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST).functions(ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).function(MapHashCodeOperator.MAP_HASH_CODE).function(MapElementAtFunction.MAP_ELEMENT_AT).function(MapConcatFunction.MAP_CONCAT_FUNCTION).function(MapToMapCast.MAP_TO_MAP_CAST).function(ArrayFlattenFunction.ARRAY_FLATTEN_FUNCTION).function(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, JsonStringToArrayCast.JSON_STRING_TO_ARRAY).function(SetAggregationFunction.SET_AGG).function(SetUnionFunction.SET_UNION).function(new ArrayAggregationFunction(featuresConfig.isLegacyArrayAgg(), featuresConfig.getArrayAggGroupImplementation())).functions(new MapSubscriptOperator(featuresConfig.isLegacyMapSubscript())).functions(MapConstructor.MAP_CONSTRUCTOR, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, JsonStringToMapCast.JSON_STRING_TO_MAP).functions(MapAggregationFunction.MAP_AGG, MapUnionAggregation.MAP_UNION).function(ReduceAggregationFunction.REDUCE_AGG).function(new MultimapAggregationFunction(featuresConfig.getMultimapAggGroupImplementation())).functions(DecimalCasts.DECIMAL_TO_VARCHAR_CAST, DecimalCasts.DECIMAL_TO_INTEGER_CAST, DecimalCasts.DECIMAL_TO_BIGINT_CAST, DecimalCasts.DECIMAL_TO_DOUBLE_CAST, DecimalCasts.DECIMAL_TO_REAL_CAST, DecimalCasts.DECIMAL_TO_BOOLEAN_CAST, DecimalCasts.DECIMAL_TO_TINYINT_CAST, DecimalCasts.DECIMAL_TO_SMALLINT_CAST).functions(DecimalCasts.VARCHAR_TO_DECIMAL_CAST, DecimalCasts.INTEGER_TO_DECIMAL_CAST, DecimalCasts.BIGINT_TO_DECIMAL_CAST, DecimalCasts.DOUBLE_TO_DECIMAL_CAST, DecimalCasts.REAL_TO_DECIMAL_CAST, DecimalCasts.BOOLEAN_TO_DECIMAL_CAST, DecimalCasts.TINYINT_TO_DECIMAL_CAST, DecimalCasts.SMALLINT_TO_DECIMAL_CAST).functions(DecimalCasts.JSON_TO_DECIMAL_CAST, DecimalCasts.DECIMAL_TO_JSON_CAST).functions(DecimalOperators.DECIMAL_ADD_OPERATOR, DecimalOperators.DECIMAL_SUBTRACT_OPERATOR, DecimalOperators.DECIMAL_MULTIPLY_OPERATOR, DecimalOperators.DECIMAL_DIVIDE_OPERATOR, DecimalOperators.DECIMAL_MODULUS_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_EQUAL_OPERATOR, DecimalInequalityOperators.DECIMAL_NOT_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_LESS_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_GREATER_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR).function(DecimalSaturatedFloorCasts.DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST).function(DecimalInequalityOperators.DECIMAL_BETWEEN_OPERATOR).function(DecimalInequalityOperators.DECIMAL_DISTINCT_FROM_OPERATOR).function(new Histogram(featuresConfig.getHistogramGroupImplementation())).function(ChecksumAggregationFunction.CHECKSUM_AGGREGATION).function(IdentityCast.IDENTITY_CAST).function(ArbitraryAggregationFunction.ARBITRARY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxByAggregationFunction.MAX_BY, MinByAggregationFunction.MIN_BY, MaxByNAggregationFunction.MAX_BY_N_AGGREGATION, MinByNAggregationFunction.MIN_BY_N_AGGREGATION).functions(MaxAggregationFunction.MAX_AGGREGATION, MinAggregationFunction.MIN_AGGREGATION, MaxNAggregationFunction.MAX_N_AGGREGATION, MinNAggregationFunction.MIN_N_AGGREGATION).function(CountColumn.COUNT_COLUMN).functions(RowHashCodeOperator.ROW_HASH_CODE, RowToJsonCast.ROW_TO_JSON, JsonToRowCast.JSON_TO_ROW, JsonStringToRowCast.JSON_STRING_TO_ROW, RowDistinctFromOperator.ROW_DISTINCT_FROM, RowEqualOperator.ROW_EQUAL, RowGreaterThanOperator.ROW_GREATER_THAN, RowGreaterThanOrEqualOperator.ROW_GREATER_THAN_OR_EQUAL, RowLessThanOperator.ROW_LESS_THAN, RowLessThanOrEqualOperator.ROW_LESS_THAN_OR_EQUAL, RowNotEqualOperator.ROW_NOT_EQUAL, RowToRowCast.ROW_TO_ROW_CAST, RowIndeterminateOperator.ROW_INDETERMINATE).functions(ConcatFunction.VARCHAR_CONCAT, ConcatFunction.VARBINARY_CONCAT).function(DecimalToDecimalCasts.DECIMAL_TO_DECIMAL_CAST).function(Re2JCastToRegexpFunction.castVarcharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(Re2JCastToRegexpFunction.castCharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(DecimalAverageAggregation.DECIMAL_AVERAGE_AGGREGATION).function(DecimalSumAggregation.DECIMAL_SUM_AGGREGATION).function(MathFunctions.DECIMAL_MOD_FUNCTION).functions(ArrayTransformFunction.ARRAY_TRANSFORM_FUNCTION, ArrayReduceFunction.ARRAY_REDUCE_FUNCTION).functions(MapFilterFunction.MAP_FILTER_FUNCTION, MapTransformKeyFunction.MAP_TRANSFORM_KEY_FUNCTION, MapTransformValueFunction.MAP_TRANSFORM_VALUE_FUNCTION).function(TryCastFunction.TRY_CAST).aggregate(MergeSetDigestAggregation.class).aggregate(BuildSetDigestAggregation.class).scalars(SetDigestFunctions.class).scalars(SetDigestOperators.class).aggregates(MergeKHyperLogLogAggregationFunction.class).aggregates(KHyperLogLogAggregationFunction.class).scalars(KHyperLogLogFunctions.class).scalars(KHyperLogLogOperators.class).scalars(WilsonInterval.class).scalars(TDigestOperators.class).scalars(TDigestFunctions.class).functions(TDigestAggregationFunction.TDIGEST_AGG, TDigestAggregationFunction.TDIGEST_AGG_WITH_WEIGHT, TDigestAggregationFunction.TDIGEST_AGG_WITH_WEIGHT_AND_COMPRESSION).function(MergeTDigestFunction.MERGE).sqlInvokedScalar(MapNormalizeFunction.class).sqlInvokedScalars(ArrayArithmeticFunctions.class);
        switch (featuresConfig.getRegexLibrary()) {
            case JONI: {
                builder.scalars(JoniRegexpFunctions.class);
                builder.scalar(JoniRegexpReplaceLambdaFunction.class);
                break;
            }
            case RE2J: {
                builder.scalars(Re2JRegexpFunctions.class);
                builder.scalar(Re2JRegexpReplaceLambdaFunction.class);
            }
        }
        if (featuresConfig.isLegacyLogFunction()) {
            builder.scalar(MathFunctions.LegacyLogFunction.class);
        }
        this.registerBuiltInFunctions(builder.getFunctions());
    }

    public synchronized void registerBuiltInFunctions(List<? extends SqlFunction> functions) {
        for (SqlFunction sqlFunction : functions) {
            for (SqlFunction existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!sqlFunction.getSignature().equals((Object)existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)sqlFunction.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot create function in built-in function namespace: %s", function.getSignature().getName()));
    }

    public void alterFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot alter function in built-in function namespace: %s", functionName));
    }

    public void dropFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot drop function in built-in function namespace: %s", functionName));
    }

    public String getName() {
        return ID;
    }

    public FunctionNamespaceTransactionHandle beginTransaction() {
        return new EmptyTransactionHandle();
    }

    public void commit(FunctionNamespaceTransactionHandle transactionHandle) {
    }

    public void abort(FunctionNamespaceTransactionHandle transactionHandle) {
    }

    public Collection<SqlFunction> listFunctions() {
        return this.functions.list();
    }

    public Collection<SqlFunction> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedFunctionName functionName) {
        return this.functions.get(functionName);
    }

    public FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        return new BuiltInFunctionHandle(signature);
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        SpecializedFunctionKey functionKey;
        Preconditions.checkArgument((boolean)(functionHandle instanceof BuiltInFunctionHandle), (Object)"Expect BuiltInFunctionHandle");
        Signature signature = ((BuiltInFunctionHandle)functionHandle).getSignature();
        try {
            functionKey = (SpecializedFunctionKey)this.specializedFunctionKeyCache.getUnchecked((Object)signature);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
        SqlFunction function = functionKey.getFunction();
        FunctionImplementationType implementationType = function instanceof SqlInvokedFunction ? FunctionImplementationType.SQL : FunctionImplementationType.BUILTIN;
        Optional argumentNames = function instanceof SqlInvokedFunction ? Optional.of(((SqlInvokedFunction)function).getParameters().stream().map(Parameter::getName).collect(ImmutableList.toImmutableList())) : Optional.empty();
        Optional operatorType = OperatorType.tryGetOperatorType((QualifiedFunctionName)signature.getName());
        if (operatorType.isPresent()) {
            Preconditions.checkArgument((implementationType == FunctionImplementationType.BUILTIN ? 1 : 0) != 0, (String)"Operator must be implemented as built-in, found: %s", (Object)implementationType);
            return new FunctionMetadata((OperatorType)operatorType.get(), signature.getArgumentTypes(), signature.getReturnType(), signature.getKind(), FunctionImplementationType.BUILTIN, function.isDeterministic(), function.isCalledOnNullInput());
        }
        return new FunctionMetadata(signature.getName(), signature.getArgumentTypes(), argumentNames, signature.getReturnType(), signature.getKind(), implementationType, function.isDeterministic(), function.isCalledOnNullInput());
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof BuiltInFunctionHandle), (Object)"Expect BuiltInFunctionHandle");
        Signature signature = ((BuiltInFunctionHandle)functionHandle).getSignature();
        Preconditions.checkArgument((signature.getKind() == FunctionKind.WINDOW || signature.getKind() == FunctionKind.AGGREGATE ? 1 : 0) != 0, (String)"%s is not a window function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (WindowFunctionSupplier)this.specializedWindowCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof BuiltInFunctionHandle), (Object)"Expect BuiltInFunctionHandle");
        Signature signature = ((BuiltInFunctionHandle)functionHandle).getSignature();
        Preconditions.checkArgument((signature.getKind() == FunctionKind.AGGREGATE ? 1 : 0) != 0, (String)"%s is not an aggregate function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (InternalAggregationFunction)this.specializedAggregationCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof BuiltInFunctionHandle), (Object)"Expect BuiltInFunctionHandle");
        return this.getScalarFunctionImplementation(((BuiltInFunctionHandle)functionHandle).getSignature());
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getKind() == FunctionKind.SCALAR ? 1 : 0) != 0, (String)"%s is not a scalar function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (ScalarFunctionImplementation)this.specializedScalarCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private SpecializedFunctionKey getSpecializedFunctionKey(Signature signature) {
        try {
            return (SpecializedFunctionKey)this.specializedFunctionKeyCache.getUnchecked((Object)signature);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private SpecializedFunctionKey doGetSpecializedFunctionKey(Signature signature) {
        Collection<SqlFunction> candidates = this.getFunctions(null, signature.getName());
        Type returnType = this.typeManager.getType(signature.getReturnType());
        List<TypeSignatureProvider> argumentTypeSignatureProviders = TypeSignatureProvider.fromTypeSignatures(signature.getArgumentTypes());
        for (SqlFunction sqlFunction : candidates) {
            Optional<BoundVariables> boundVariables = new SignatureBinder(this.typeManager, sqlFunction.getSignature(), false).bindVariables(argumentTypeSignatureProviders, returnType);
            if (!boundVariables.isPresent()) continue;
            return new SpecializedFunctionKey(sqlFunction, boundVariables.get(), argumentTypeSignatureProviders.size());
        }
        List<Type> argumentTypes = TypeUtils.resolveTypes(signature.getArgumentTypes(), this.typeManager);
        for (SqlFunction candidate : candidates) {
            Signature boundSignature;
            SignatureBinder binder = new SignatureBinder(this.typeManager, candidate.getSignature(), true);
            Optional<BoundVariables> boundVariables = binder.bindVariables(argumentTypeSignatureProviders, returnType);
            if (!boundVariables.isPresent() || !this.typeManager.isTypeOnlyCoercion(this.typeManager.getType((boundSignature = SignatureBinder.applyBoundVariables(candidate.getSignature(), boundVariables.get(), argumentTypes.size())).getReturnType()), returnType)) continue;
            boolean nonTypeOnlyCoercion = false;
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Type expectedType = this.typeManager.getType((TypeSignature)boundSignature.getArgumentTypes().get(i));
                if (this.typeManager.isTypeOnlyCoercion(argumentTypes.get(i), expectedType)) continue;
                nonTypeOnlyCoercion = true;
                break;
            }
            if (nonTypeOnlyCoercion) continue;
            return new SpecializedFunctionKey(candidate, boundVariables.get(), argumentTypes.size());
        }
        if (signature.getNameSuffix().startsWith("$literal$")) {
            List list = signature.getArgumentTypes();
            String typeName = signature.getNameSuffix().substring("$literal$".length());
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", (Object)list);
            Type parameterType = this.typeManager.getType((TypeSignature)list.get(0));
            Objects.requireNonNull(parameterType, String.format("Type %s not found", list.get(0)));
            return new SpecializedFunctionKey(this.magicLiteralFunction, BoundVariables.builder().setTypeVariable("T", parameterType).setTypeVariable("R", type).build(), 1);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    private static class MagicLiteralFunction
    extends SqlScalarFunction {
        private final BlockEncodingSerde blockEncodingSerde;

        MagicLiteralFunction(BlockEncodingSerde blockEncodingSerde) {
            super(new Signature(QualifiedFunctionName.of((CatalogSchemaName)DEFAULT_NAMESPACE, (String)"$literal$"), FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"R"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}));
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public final SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.HIDDEN;
        }

        public boolean isDeterministic() {
            return true;
        }

        public String getDescription() {
            return "magic literal";
        }

        @Override
        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
            Type parameterType = boundVariables.getTypeVariable("T");
            Type type = boundVariables.getTypeVariable("R");
            MethodHandle methodHandle = null;
            if (parameterType.getJavaType() == type.getJavaType()) {
                methodHandle = MethodHandles.identity(parameterType.getJavaType());
            }
            if (parameterType.getJavaType() == Slice.class && type.getJavaType() == Block.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK.bindTo(this.blockEncodingSerde);
            }
            Preconditions.checkArgument((methodHandle != null ? 1 : 0) != 0, (String)"Expected type %s to use (or can be converted into) Java type %s, but Java type is %s", (Object)type, (Object)parameterType.getJavaType(), (Object)type.getJavaType());
            return new BuiltInScalarFunctionImplementation(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
        }
    }

    private static class FunctionMap {
        private final Multimap<QualifiedFunctionName, SqlFunction> functions;

        public FunctionMap() {
            this.functions = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<? extends SqlFunction> functions) {
            this.functions = ImmutableListMultimap.builder().putAll(map.functions).putAll((Multimap)Multimaps.index(functions, function -> function.getSignature().getName())).build();
            for (Map.Entry entry : this.functions.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(function -> function.getSignature().getKind()).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<SqlFunction> list() {
            return ImmutableList.copyOf((Collection)this.functions.values());
        }

        public Collection<SqlFunction> get(QualifiedFunctionName name) {
            return this.functions.get((Object)name);
        }
    }

    private static class EmptyTransactionHandle
    implements FunctionNamespaceTransactionHandle {
        private EmptyTransactionHandle() {
        }
    }
}

