/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.BasicStageExecutionStats;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.ExchangeLocationsConsumer;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.ExecutionSchedule;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SectionExecution;
import com.facebook.presto.execution.scheduler.SectionExecutionFactory;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.SqlQuerySchedulerInterface;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.SchedulingOrderVisitor;
import com.facebook.presto.sql.planner.SplitSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

@Deprecated
public class LegacySqlQueryScheduler
implements SqlQuerySchedulerInterface {
    private static final Logger log = Logger.get(LegacySqlQueryScheduler.class);
    private final LocationFactory locationFactory;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final QueryStateMachine queryStateMachine;
    private final AtomicReference<SubPlan> plan = new AtomicReference();
    private final StreamingPlanSection sectionedPlan;
    private final StageId rootStageId;
    private final boolean summarizeTaskInfo;
    private final int maxConcurrentMaterializations;
    private final Session session;
    private final FunctionManager functionManager;
    private final List<PlanOptimizer> runtimePlanOptimizers;
    private final WarningCollector warningCollector;
    private final PlanNodeIdAllocator idAllocator;
    private final PlanVariableAllocator variableAllocator;
    private final SectionExecutionFactory sectionExecutionFactory;
    private final RemoteTaskFactory remoteTaskFactory;
    private final SplitSourceFactory splitSourceFactory;
    private final Set<StageId> runtimeOptimizedStages = Collections.synchronizedSet(new HashSet());
    private final Map<StageId, StageExecutionAndScheduler> stageExecutions = new ConcurrentHashMap<StageId, StageExecutionAndScheduler>();
    private final ExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean scheduling = new AtomicBoolean();

    public static LegacySqlQueryScheduler createSqlQueryScheduler(LocationFactory locationFactory, ExecutionPolicy executionPolicy, ExecutorService queryExecutor, SplitSchedulerStats schedulerStats, SectionExecutionFactory sectionExecutionFactory, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session, FunctionManager functionManager, QueryStateMachine queryStateMachine, SubPlan plan, OutputBuffers rootOutputBuffers, boolean summarizeTaskInfo, List<PlanOptimizer> runtimePlanOptimizers, WarningCollector warningCollector, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator) {
        LegacySqlQueryScheduler sqlQueryScheduler = new LegacySqlQueryScheduler(locationFactory, executionPolicy, queryExecutor, schedulerStats, sectionExecutionFactory, remoteTaskFactory, splitSourceFactory, session, functionManager, queryStateMachine, plan, summarizeTaskInfo, rootOutputBuffers, runtimePlanOptimizers, warningCollector, idAllocator, variableAllocator);
        sqlQueryScheduler.initialize();
        return sqlQueryScheduler;
    }

    private LegacySqlQueryScheduler(LocationFactory locationFactory, ExecutionPolicy executionPolicy, ExecutorService queryExecutor, SplitSchedulerStats schedulerStats, SectionExecutionFactory sectionExecutionFactory, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session, FunctionManager functionManager, QueryStateMachine queryStateMachine, SubPlan plan, boolean summarizeTaskInfo, OutputBuffers rootOutputBuffers, List<PlanOptimizer> runtimePlanOptimizers, WarningCollector warningCollector, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator) {
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionPolicy = Objects.requireNonNull(executionPolicy, "schedulerPolicyFactory is null");
        this.executor = queryExecutor;
        this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
        this.plan.compareAndSet(null, Objects.requireNonNull(plan, "plan is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.runtimePlanOptimizers = Objects.requireNonNull(runtimePlanOptimizers, "runtimePlanOptimizers is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.sectionExecutionFactory = Objects.requireNonNull(sectionExecutionFactory, "sectionExecutionFactory is null");
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.splitSourceFactory = Objects.requireNonNull(splitSourceFactory, "splitSourceFactory is null");
        this.sectionedPlan = StreamingPlanSection.extractStreamingSections(plan);
        this.summarizeTaskInfo = summarizeTaskInfo;
        OutputBuffers.OutputBufferId rootBufferId = (OutputBuffers.OutputBufferId)Iterables.getOnlyElement(rootOutputBuffers.getBuffers().keySet());
        List<StageExecutionAndScheduler> stageExecutions = this.createStageExecutions(sectionExecutionFactory, (fragmentId, tasks, noMoreExchangeLocations) -> LegacySqlQueryScheduler.updateQueryOutputLocations(queryStateMachine, rootBufferId, tasks, noMoreExchangeLocations), this.sectionedPlan, Optional.of(new int[1]), rootOutputBuffers, remoteTaskFactory, splitSourceFactory, session);
        this.rootStageId = ((StageExecutionAndScheduler)Iterables.getLast(stageExecutions)).getStageExecution().getStageExecutionId().getStageId();
        stageExecutions.stream().forEach(execution -> this.stageExecutions.put(execution.getStageExecution().getStageExecutionId().getStageId(), (StageExecutionAndScheduler)execution));
        this.maxConcurrentMaterializations = SystemSessionProperties.getMaxConcurrentMaterializations(session);
    }

    private void initialize() {
        SqlStageExecution rootStage = this.stageExecutions.get(this.rootStageId).getStageExecution();
        rootStage.addStateChangeListener(state -> {
            if (state == StageExecutionState.FINISHED) {
                this.queryStateMachine.transitionToFinishing();
            } else if (state == StageExecutionState.CANCELED) {
                this.queryStateMachine.transitionToCanceled();
            }
        });
        for (StageExecutionAndScheduler stageExecutionInfo : this.stageExecutions.values()) {
            SqlStageExecution stageExecution = stageExecutionInfo.getStageExecution();
            stageExecution.addStateChangeListener(state -> {
                if (this.queryStateMachine.isDone()) {
                    return;
                }
                if (state == StageExecutionState.FAILED) {
                    this.queryStateMachine.transitionToFailed(stageExecution.getStageExecutionInfo().getFailureCause().get().toException());
                } else if (state == StageExecutionState.ABORTED) {
                    this.queryStateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query stage was aborted"));
                } else if (state == StageExecutionState.FINISHED) {
                    this.startScheduling();
                } else if (this.queryStateMachine.getQueryState() == QueryState.STARTING && stageExecution.hasTasks()) {
                    this.queryStateMachine.transitionToRunning();
                }
            });
            stageExecution.addFinalStageInfoListener(status -> this.queryStateMachine.updateQueryInfo(Optional.of(this.getStageInfo())));
        }
        this.queryStateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                this.queryStateMachine.updateQueryInfo(Optional.of(this.getStageInfo()));
            }
        });
    }

    private static void updateQueryOutputLocations(QueryStateMachine queryStateMachine, OutputBuffers.OutputBufferId rootBufferId, Set<RemoteTask> tasks, boolean noMoreExchangeLocations) {
        Map bufferLocations = (Map)tasks.stream().collect(ImmutableMap.toImmutableMap(task -> LegacySqlQueryScheduler.getBufferLocation(task, rootBufferId), RemoteTask::getTaskId));
        queryStateMachine.updateOutputLocations(bufferLocations, noMoreExchangeLocations);
    }

    private static URI getBufferLocation(RemoteTask remoteTask, OutputBuffers.OutputBufferId rootBufferId) {
        URI location = remoteTask.getTaskStatus().getSelf();
        return HttpUriBuilder.uriBuilderFrom((URI)location).appendPath("results").appendPath(rootBufferId.toString()).build();
    }

    private List<StageExecutionAndScheduler> createStageExecutions(SectionExecutionFactory sectionExecutionFactory, ExchangeLocationsConsumer locationsConsumer, StreamingPlanSection section, Optional<int[]> bucketToPartition, OutputBuffers outputBuffers, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, Session session) {
        ImmutableList.Builder stages = ImmutableList.builder();
        for (StreamingPlanSection childSection : section.getChildren()) {
            ExchangeLocationsConsumer childLocationsConsumer = (fragmentId, tasks, noMoreExhchangeLocations) -> {};
            stages.addAll(this.createStageExecutions(sectionExecutionFactory, childLocationsConsumer, childSection, Optional.empty(), OutputBuffers.createDiscardingOutputBuffers(), remoteTaskFactory, splitSourceFactory, session));
        }
        List<StageExecutionAndScheduler> sectionStages = sectionExecutionFactory.createSectionExecutions(session, section, locationsConsumer, bucketToPartition, outputBuffers, this.summarizeTaskInfo, remoteTaskFactory, splitSourceFactory, 0).getSectionStages();
        stages.addAll(sectionStages);
        return stages.build();
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.startScheduling();
        }
    }

    private void startScheduling() {
        Objects.requireNonNull(this.stageExecutions);
        if (this.scheduling.get()) {
            return;
        }
        this.executor.submit(this::schedule);
    }

    private void schedule() {
        if (!this.scheduling.compareAndSet(false, true)) {
            return;
        }
        ArrayList scheduledStageExecutions = new ArrayList();
        try {
            SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});
            Object object = null;
            try {
                HashSet<StageId> completedStages = new HashSet<StageId>();
                LinkedList<ExecutionSchedule> sectionExecutionSchedules = new LinkedList<ExecutionSchedule>();
                block34: while (!Thread.currentThread().isInterrupted()) {
                    sectionExecutionSchedules.removeIf(ExecutionSchedule::isFinished);
                    List<StreamingPlanSection> sectionsReadyForExecution = this.getSectionsReadyForExecution();
                    if (sectionsReadyForExecution.isEmpty() && sectionExecutionSchedules.isEmpty()) break;
                    List<List<StageExecutionAndScheduler>> sectionStageExecutions = this.getStageExecutions(sectionsReadyForExecution);
                    sectionStageExecutions.forEach(scheduledStageExecutions::addAll);
                    sectionStageExecutions.stream().map(executionInfos -> (ImmutableList)executionInfos.stream().collect(ImmutableList.toImmutableList())).map(this.executionPolicy::createExecutionSchedule).forEach(sectionExecutionSchedules::add);
                    while (sectionExecutionSchedules.stream().noneMatch(ExecutionSchedule::isFinished)) {
                        Object stageExecutionAndScheduler22;
                        ArrayList blockedStages = new ArrayList();
                        List executionsToSchedule = (List)sectionExecutionSchedules.stream().flatMap(schedule -> schedule.getStagesToSchedule().stream()).collect(ImmutableList.toImmutableList());
                        block36: for (Object stageExecutionAndScheduler22 : executionsToSchedule) {
                            SqlStageExecution sqlStageExecution = ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageExecution();
                            StageId stageId = sqlStageExecution.getStageExecutionId().getStageId();
                            sqlStageExecution.beginScheduling();
                            ScheduleResult result = ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageScheduler().schedule();
                            if (result.isFinished()) {
                                sqlStageExecution.schedulingComplete();
                            } else if (!result.getBlocked().isDone()) {
                                blockedStages.add(result.getBlocked());
                            }
                            ((StageExecutionAndScheduler)stageExecutionAndScheduler22).getStageLinkage().processScheduleResults(sqlStageExecution.getState(), result.getNewTasks());
                            this.schedulerStats.getSplitsScheduledPerIteration().add((long)result.getSplitsScheduled());
                            if (!result.getBlockedReason().isPresent()) continue;
                            switch (result.getBlockedReason().get()) {
                                case WRITER_SCALING: {
                                    continue block36;
                                }
                                case WAITING_FOR_SOURCE: {
                                    this.schedulerStats.getWaitingForSource().update(1L);
                                    continue block36;
                                }
                                case SPLIT_QUEUES_FULL: {
                                    this.schedulerStats.getSplitQueuesFull().update(1L);
                                    continue block36;
                                }
                                case MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE: {
                                    this.schedulerStats.getMixedSplitQueuesFullAndWaitingForSource().update(1L);
                                    continue block36;
                                }
                                case NO_ACTIVE_DRIVER_GROUP: {
                                    this.schedulerStats.getNoActiveDriverGroup().update(1L);
                                    continue block36;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown blocked reason: " + (Object)((Object)result.getBlockedReason().get()));
                        }
                        boolean stageFinishedExecution = false;
                        stageExecutionAndScheduler22 = scheduledStageExecutions.iterator();
                        while (stageExecutionAndScheduler22.hasNext()) {
                            StageExecutionAndScheduler stageExecutionAndScheduler = (StageExecutionAndScheduler)stageExecutionAndScheduler22.next();
                            SqlStageExecution stageExecution = stageExecutionAndScheduler.getStageExecution();
                            StageId stageId = stageExecution.getStageExecutionId().getStageId();
                            if (completedStages.contains(stageId) || !stageExecution.getState().isDone()) continue;
                            stageExecutionAndScheduler.getStageLinkage().processScheduleResults(stageExecution.getState(), (Set<RemoteTask>)ImmutableSet.of());
                            completedStages.add(stageId);
                            stageFinishedExecution = true;
                        }
                        if (stageFinishedExecution) continue block34;
                        if (blockedStages.isEmpty()) continue;
                        Throwable throwable = null;
                        try (TimeStat.BlockTimer timer = this.schedulerStats.getSleepTime().time();){
                            MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete(blockedStages), (int)1, (TimeUnit)TimeUnit.SECONDS);
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                        for (ListenableFuture listenableFuture : blockedStages) {
                            listenableFuture.cancel(true);
                        }
                    }
                }
                for (StageExecutionAndScheduler stageExecutionInfo : scheduledStageExecutions) {
                    StageExecutionState state = stageExecutionInfo.getStageExecution().getState();
                    if (state == StageExecutionState.SCHEDULED || state == StageExecutionState.RUNNING || state.isDone()) continue;
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Scheduling is complete, but stage execution %s is in state %s", new Object[]{stageExecutionInfo.getStageExecution().getStageExecutionId(), state}));
                }
                this.scheduling.set(false);
                if (!this.getSectionsReadyForExecution().isEmpty()) {
                    this.startScheduling();
                }
            }
            catch (Throwable completedStages) {
                object = completedStages;
                throw completedStages;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable completedStages) {
                            ((Throwable)object).addSuppressed(completedStages);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            this.scheduling.set(false);
            this.queryStateMachine.transitionToFailed(t);
            throw t;
        }
        finally {
            RuntimeException closeError = new RuntimeException();
            for (StageExecutionAndScheduler stageExecutionInfo : scheduledStageExecutions) {
                try {
                    stageExecutionInfo.getStageScheduler().close();
                }
                catch (Throwable t) {
                    this.queryStateMachine.transitionToFailed(t);
                    if (closeError == t) continue;
                    closeError.addSuppressed(t);
                }
            }
            if (closeError.getSuppressed().length > 0) {
                throw closeError;
            }
        }
    }

    private List<StreamingPlanSection> getSectionsReadyForExecution() {
        long runningPlanSections = Streams.stream((Iterable)Traverser.forTree(StreamingPlanSection::getChildren).depthFirstPreOrder((Object)this.sectionedPlan)).map(section -> this.getStageExecution(section.getPlan().getFragment().getId()).getState()).filter(state -> !state.isDone() && state != StageExecutionState.PLANNED).count();
        return (List)Streams.stream((Iterable)Traverser.forTree(StreamingPlanSection::getChildren).depthFirstPreOrder((Object)this.sectionedPlan)).filter(this::isReadyForExecution).limit((long)this.maxConcurrentMaterializations - runningPlanSections).map(this::tryCostBasedOptimize).collect(ImmutableList.toImmutableList());
    }

    private StreamingPlanSection tryCostBasedOptimize(StreamingPlanSection section) {
        if (!SystemSessionProperties.isRuntimeOptimizerEnabled(this.session) || section.getChildren().isEmpty()) {
            return section;
        }
        HashMap<PlanFragment, PlanFragment> oldToNewFragment = new HashMap<PlanFragment, PlanFragment>();
        Streams.stream((Iterable)Traverser.forTree(StreamingSubPlan::getChildren).depthFirstPreOrder((Object)section.getPlan())).forEach(currentSubPlan -> {
            Optional<PlanFragment> newPlanFragment = this.performRuntimeOptimizations((StreamingSubPlan)currentSubPlan);
            if (newPlanFragment.isPresent()) {
                oldToNewFragment.put(currentSubPlan.getFragment(), newPlanFragment.get());
            }
        });
        if (oldToNewFragment.isEmpty()) {
            return section;
        }
        oldToNewFragment.forEach((oldFragment, newFragment) -> this.runtimeOptimizedStages.add(this.getStageId(oldFragment.getId())));
        this.updatePlan(oldToNewFragment);
        this.updateStageExecutions(section, oldToNewFragment);
        log.debug("Invoked CBO during runtime, optimized stage IDs: " + oldToNewFragment.keySet().stream().map(PlanFragment::getId).map(PlanFragmentId::toString).collect(Collectors.joining(", ")));
        return section;
    }

    private Optional<PlanFragment> performRuntimeOptimizations(StreamingSubPlan subPlan) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        for (PlanOptimizer optimizer : this.runtimePlanOptimizers) {
            newRoot = optimizer.optimize(newRoot, this.session, this.variableAllocator.getTypes(), this.variableAllocator, this.idAllocator, this.warningCollector);
        }
        if (newRoot != fragment.getRoot()) {
            return Optional.of(new PlanFragment(fragment.getId(), newRoot, fragment.getVariables(), fragment.getPartitioning(), SchedulingOrderVisitor.scheduleOrder(newRoot), fragment.getPartitioningScheme(), fragment.getStageExecutionDescriptor(), fragment.isOutputTableWriterFragment(), fragment.getStatsAndCosts(), Optional.of(PlanPrinter.jsonFragmentPlan(newRoot, fragment.getVariables(), this.functionManager, this.session))));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStageExecutions(StreamingPlanSection section, Map<PlanFragment, PlanFragment> oldToNewFragment) {
        ExchangeLocationsConsumer locationsConsumer;
        OutputBuffers outputBuffers;
        Optional<int[]> bucketToPartition;
        StreamingPlanSection newSection = new StreamingPlanSection(this.rewriteStreamingSubPlan(section.getPlan(), oldToNewFragment), section.getChildren());
        PlanFragment sectionRootFragment = newSection.getPlan().getFragment();
        if (LegacySqlQueryScheduler.isRootFragment(sectionRootFragment)) {
            bucketToPartition = Optional.of(new int[1]);
            outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(sectionRootFragment.getPartitioningScheme().getPartitioning().getHandle()).withBuffer(new OutputBuffers.OutputBufferId(0), 0).withNoMoreBufferIds();
            OutputBuffers.OutputBufferId rootBufferId = (OutputBuffers.OutputBufferId)Iterables.getOnlyElement(outputBuffers.getBuffers().keySet());
            locationsConsumer = (fragmentId, tasks, noMoreExchangeLocations) -> LegacySqlQueryScheduler.updateQueryOutputLocations(this.queryStateMachine, rootBufferId, tasks, noMoreExchangeLocations);
        } else {
            bucketToPartition = Optional.empty();
            outputBuffers = OutputBuffers.createDiscardingOutputBuffers();
            locationsConsumer = (fragmentId, tasks, noMoreExchangeLocations) -> {};
        }
        SectionExecution sectionExecution = this.sectionExecutionFactory.createSectionExecutions(this.session, newSection, locationsConsumer, bucketToPartition, outputBuffers, this.summarizeTaskInfo, this.remoteTaskFactory, this.splitSourceFactory, 0);
        this.addStateChangeListeners(sectionExecution);
        Map updatedStageExecutions = (Map)sectionExecution.getSectionStages().stream().collect(ImmutableMap.toImmutableMap(execution -> execution.getStageExecution().getStageExecutionId().getStageId(), Function.identity()));
        LegacySqlQueryScheduler legacySqlQueryScheduler = this;
        synchronized (legacySqlQueryScheduler) {
            this.stageExecutions.putAll(updatedStageExecutions);
        }
    }

    private void updatePlan(Map<PlanFragment, PlanFragment> oldToNewFragments) {
        this.plan.getAndUpdate(value -> this.rewritePlan((SubPlan)value, oldToNewFragments));
    }

    private SubPlan rewritePlan(SubPlan root, Map<PlanFragment, PlanFragment> oldToNewFragments) {
        ImmutableList.Builder children = ImmutableList.builder();
        for (SubPlan child : root.getChildren()) {
            children.add((Object)this.rewritePlan(child, oldToNewFragments));
        }
        if (oldToNewFragments.containsKey(root.getFragment())) {
            return new SubPlan(oldToNewFragments.get(root.getFragment()), (List<SubPlan>)children.build());
        }
        return new SubPlan(root.getFragment(), (List<SubPlan>)children.build());
    }

    private void addStateChangeListeners(SectionExecution sectionExecution) {
        for (StageExecutionAndScheduler stageExecutionAndScheduler : sectionExecution.getSectionStages()) {
            SqlStageExecution stageExecution = stageExecutionAndScheduler.getStageExecution();
            if (LegacySqlQueryScheduler.isRootFragment(stageExecution.getFragment())) {
                stageExecution.addStateChangeListener(state -> {
                    if (state == StageExecutionState.FINISHED) {
                        this.queryStateMachine.transitionToFinishing();
                    } else if (state == StageExecutionState.CANCELED) {
                        this.queryStateMachine.transitionToCanceled();
                    }
                });
            }
            stageExecution.addStateChangeListener(state -> {
                if (this.queryStateMachine.isDone()) {
                    return;
                }
                if (state == StageExecutionState.FAILED) {
                    this.queryStateMachine.transitionToFailed(stageExecution.getStageExecutionInfo().getFailureCause().get().toException());
                } else if (state == StageExecutionState.ABORTED) {
                    this.queryStateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query stage was aborted"));
                } else if (state == StageExecutionState.FINISHED) {
                    this.startScheduling();
                } else if (this.queryStateMachine.getQueryState() == QueryState.STARTING && stageExecution.hasTasks()) {
                    this.queryStateMachine.transitionToRunning();
                }
            });
            stageExecution.addFinalStageInfoListener(status -> this.queryStateMachine.updateQueryInfo(Optional.of(this.getStageInfo())));
        }
    }

    private StreamingSubPlan rewriteStreamingSubPlan(StreamingSubPlan root, Map<PlanFragment, PlanFragment> oldToNewFragment) {
        ImmutableList.Builder childrenPlans = ImmutableList.builder();
        for (StreamingSubPlan child : root.getChildren()) {
            childrenPlans.add((Object)this.rewriteStreamingSubPlan(child, oldToNewFragment));
        }
        if (oldToNewFragment.containsKey(root.getFragment())) {
            return new StreamingSubPlan(oldToNewFragment.get(root.getFragment()), (List<StreamingSubPlan>)childrenPlans.build());
        }
        return new StreamingSubPlan(root.getFragment(), (List<StreamingSubPlan>)childrenPlans.build());
    }

    private static boolean isRootFragment(PlanFragment fragment) {
        return fragment.getId().getId() == 0;
    }

    private boolean isReadyForExecution(StreamingPlanSection section) {
        SqlStageExecution stageExecution = this.getStageExecution(section.getPlan().getFragment().getId());
        if (stageExecution.getState() != StageExecutionState.PLANNED) {
            return false;
        }
        for (StreamingPlanSection child : section.getChildren()) {
            SqlStageExecution rootStageExecution = this.getStageExecution(child.getPlan().getFragment().getId());
            if (rootStageExecution.getState() == StageExecutionState.FINISHED) continue;
            return false;
        }
        return true;
    }

    private List<List<StageExecutionAndScheduler>> getStageExecutions(List<StreamingPlanSection> sections) {
        return (List)sections.stream().map(section -> (ImmutableList)Streams.stream((Iterable)Traverser.forTree(StreamingSubPlan::getChildren).depthFirstPreOrder((Object)section.getPlan())).collect(ImmutableList.toImmutableList())).map(plans -> (ImmutableList)plans.stream().map(StreamingSubPlan::getFragment).map(PlanFragment::getId).map(this::getStageExecutionInfo).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    private SqlStageExecution getStageExecution(PlanFragmentId planFragmentId) {
        return this.stageExecutions.get(this.getStageId(planFragmentId)).getStageExecution();
    }

    private StageExecutionAndScheduler getStageExecutionInfo(PlanFragmentId planFragmentId) {
        return this.stageExecutions.get(this.getStageId(planFragmentId));
    }

    private StageId getStageId(PlanFragmentId fragmentId) {
        return new StageId(this.queryStateMachine.getQueryId(), fragmentId.getId());
    }

    @Override
    public long getUserMemoryReservation() {
        return this.stageExecutions.values().stream().mapToLong(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getUserMemoryReservation()).sum();
    }

    @Override
    public long getTotalMemoryReservation() {
        return this.stageExecutions.values().stream().mapToLong(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getTotalMemoryReservation()).sum();
    }

    @Override
    public Duration getTotalCpuTime() {
        long millis = this.stageExecutions.values().stream().mapToLong(stage -> stage.getStageExecution().getTotalCpuTime().toMillis()).sum();
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public BasicStageExecutionStats getBasicStageStats() {
        List stageStats = (List)this.stageExecutions.values().stream().map(stageExecutionInfo -> stageExecutionInfo.getStageExecution().getBasicStageStats()).collect(ImmutableList.toImmutableList());
        return BasicStageExecutionStats.aggregateBasicStageStats(stageStats);
    }

    @Override
    public StageInfo getStageInfo() {
        Map stageInfos = (Map)this.stageExecutions.values().stream().map(StageExecutionAndScheduler::getStageExecution).collect(ImmutableMap.toImmutableMap(execution -> execution.getStageExecutionId().getStageId(), SqlStageExecution::getStageExecutionInfo));
        return this.buildStageInfo(this.plan.get(), stageInfos);
    }

    private StageInfo buildStageInfo(SubPlan subPlan, Map<StageId, StageExecutionInfo> stageExecutionInfos) {
        StageId stageId = this.getStageId(subPlan.getFragment().getId());
        StageExecutionInfo stageExecutionInfo = stageExecutionInfos.get(stageId);
        Preconditions.checkArgument((stageExecutionInfo != null ? 1 : 0) != 0, (String)"No stageExecutionInfo for %s", (Object)stageId);
        return new StageInfo(stageId, this.locationFactory.createStageLocation(stageId), Optional.of(subPlan.getFragment()), stageExecutionInfo, (List<StageExecutionInfo>)ImmutableList.of(), (List)subPlan.getChildren().stream().map(plan -> this.buildStageInfo((SubPlan)plan, stageExecutionInfos)).collect(ImmutableList.toImmutableList()), this.runtimeOptimizedStages.contains(stageId));
    }

    @Override
    public void cancelStage(StageId stageId) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            SqlStageExecution execution = this.stageExecutions.get(stageId).getStageExecution();
            SqlStageExecution stage = Objects.requireNonNull(execution, () -> String.format("Stage %s does not exist", stageId));
            stage.cancel();
        }
    }

    @Override
    public void abort() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.stageExecutions.values().forEach(stageExecutionInfo -> stageExecutionInfo.getStageExecution().abort());
        }
    }
}

