/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.spi.page.PageCompressor;
import com.facebook.presto.spi.page.PageDecompressor;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.spiller.SpillCipher;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public class PagesSerdeFactory {
    private final BlockEncodingSerde blockEncodingSerde;
    private final boolean compressionEnabled;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, boolean compressionEnabled) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionEnabled = compressionEnabled;
    }

    public PagesSerde createPagesSerde() {
        return this.createPagesSerdeInternal(Optional.empty());
    }

    public PagesSerde createPagesSerdeForSpill(Optional<SpillCipher> spillCipher) {
        return this.createPagesSerdeInternal(spillCipher);
    }

    private PagesSerde createPagesSerdeInternal(Optional<SpillCipher> spillCipher) {
        if (this.compressionEnabled) {
            return new PagesSerde(this.blockEncodingSerde, Optional.of(new PageCompressor(){
                Compressor compressor = new Lz4Compressor();

                public int maxCompressedLength(int uncompressedSize) {
                    return this.compressor.maxCompressedLength(uncompressedSize);
                }

                public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                    return this.compressor.compress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
                }

                public void compress(ByteBuffer input, ByteBuffer output) {
                    this.compressor.compress(input, output);
                }
            }), Optional.of(new PageDecompressor(){
                Decompressor decompressor = new Lz4Decompressor();

                public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                    return this.decompressor.decompress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
                }

                public void decompress(ByteBuffer input, ByteBuffer output) {
                    this.decompressor.decompress(input, output);
                }
            }), spillCipher);
        }
        return new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), spillCipher);
    }
}

