/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.common.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class PageSplitterUtil {
    private PageSplitterUtil() {
    }

    public static List<Page> splitPage(Page page, long maxPageSizeInBytes) {
        return PageSplitterUtil.splitPage(page, maxPageSizeInBytes, Long.MAX_VALUE);
    }

    private static List<Page> splitPage(Page page, long maxPageSizeInBytes, long previousPageSize) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"page is empty");
        Preconditions.checkArgument((maxPageSizeInBytes > 0L ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be > 0");
        if (page.getSizeInBytes() == previousPageSize || page.getSizeInBytes() <= maxPageSizeInBytes || page.getPositionCount() == 1) {
            return ImmutableList.of((Object)page);
        }
        ImmutableList.Builder outputPages = ImmutableList.builder();
        long previousSize = page.getSizeInBytes();
        int positionCount = page.getPositionCount();
        int half = positionCount / 2;
        Page leftHalf = page.getRegion(0, half);
        outputPages.addAll(PageSplitterUtil.splitPage(leftHalf, maxPageSizeInBytes, previousSize));
        Page rightHalf = page.getRegion(half, positionCount - half);
        outputPages.addAll(PageSplitterUtil.splitPage(rightHalf, maxPageSizeInBytes, previousSize));
        return outputPages.build();
    }
}

