/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final MemoryPoolId memoryPool;
    private final boolean scheduled;
    private final URI self;
    private final List<String> fieldNames;
    private final String query;
    private final QueryStats queryStats;
    private final Optional<String> setCatalog;
    private final Optional<String> setSchema;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Map<String, SelectedRole> setRoles;
    private final Map<String, String> addedPreparedStatements;
    private final Set<String> deallocatedPreparedStatements;
    private final Optional<TransactionId> startedTransactionId;
    private final boolean clearTransactionId;
    private final String updateType;
    private final Optional<StageInfo> outputStage;
    private final ExecutionFailureInfo failureInfo;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final List<PrestoWarning> warnings;
    private final Set<Input> inputs;
    private final Optional<Output> output;
    private final boolean completeInfo;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final Optional<QueryType> queryType;
    private final Optional<List<TaskId>> failedTasks;
    private final Optional<List<StageId>> runtimeOptimizedStages;

    @JsonCreator
    public QueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="memoryPool") MemoryPoolId memoryPool, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="query") String query, @JsonProperty(value="queryStats") QueryStats queryStats, @JsonProperty(value="setCatalog") Optional<String> setCatalog, @JsonProperty(value="setSchema") Optional<String> setSchema, @JsonProperty(value="setSessionProperties") Map<String, String> setSessionProperties, @JsonProperty(value="resetSessionProperties") Set<String> resetSessionProperties, @JsonProperty(value="setRoles") Map<String, SelectedRole> setRoles, @JsonProperty(value="addedPreparedStatements") Map<String, String> addedPreparedStatements, @JsonProperty(value="deallocatedPreparedStatements") Set<String> deallocatedPreparedStatements, @JsonProperty(value="startedTransactionId") Optional<TransactionId> startedTransactionId, @JsonProperty(value="clearTransactionId") boolean clearTransactionId, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="outputStage") Optional<StageInfo> outputStage, @JsonProperty(value="failureInfo") ExecutionFailureInfo failureInfo, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="warnings") List<PrestoWarning> warnings, @JsonProperty(value="inputs") Set<Input> inputs, @JsonProperty(value="output") Optional<Output> output, @JsonProperty(value="completeInfo") boolean completeInfo, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="queryType") Optional<QueryType> queryType, @JsonProperty(value="failedTasks") Optional<List<TaskId>> failedTasks, @JsonProperty(value="runtimeOptimizedStages") Optional<List<StageId>> runtimeOptimizedStages) {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(queryStats, "queryStats is null");
        Objects.requireNonNull(setCatalog, "setCatalog is null");
        Objects.requireNonNull(setSchema, "setSchema is null");
        Objects.requireNonNull(setSessionProperties, "setSessionProperties is null");
        Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null");
        Objects.requireNonNull(addedPreparedStatements, "addedPreparedStatemetns is null");
        Objects.requireNonNull(deallocatedPreparedStatements, "deallocatedPreparedStatements is null");
        Objects.requireNonNull(startedTransactionId, "startedTransactionId is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(outputStage, "outputStage is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(output, "output is null");
        Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        Objects.requireNonNull(warnings, "warnings is null");
        Objects.requireNonNull(queryType, "queryType is null");
        Objects.requireNonNull(failedTasks, "failedTasks is null");
        Objects.requireNonNull(runtimeOptimizedStages, "runtimeOptimizedStages is null");
        this.queryId = queryId;
        this.session = session;
        this.state = state;
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.scheduled = scheduled;
        this.self = self;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.query = query;
        this.queryStats = queryStats;
        this.setCatalog = setCatalog;
        this.setSchema = setSchema;
        this.setSessionProperties = ImmutableMap.copyOf(setSessionProperties);
        this.resetSessionProperties = ImmutableSet.copyOf(resetSessionProperties);
        this.setRoles = ImmutableMap.copyOf(setRoles);
        this.addedPreparedStatements = ImmutableMap.copyOf(addedPreparedStatements);
        this.deallocatedPreparedStatements = ImmutableSet.copyOf(deallocatedPreparedStatements);
        this.startedTransactionId = startedTransactionId;
        this.clearTransactionId = clearTransactionId;
        this.updateType = updateType;
        this.outputStage = outputStage;
        this.failureInfo = failureInfo;
        this.errorType = errorCode == null ? null : errorCode.getType();
        this.errorCode = errorCode;
        this.warnings = ImmutableList.copyOf(warnings);
        this.inputs = ImmutableSet.copyOf(inputs);
        this.output = output;
        this.completeInfo = completeInfo;
        this.resourceGroupId = resourceGroupId;
        this.queryType = queryType;
        this.failedTasks = failedTasks;
        this.runtimeOptimizedStages = runtimeOptimizedStages;
    }

    public static QueryInfo immediateFailureQueryInfo(Session session, String query, URI self, Optional<ResourceGroupId> resourceGroupId, ExecutionFailureInfo failureCause) {
        QueryInfo queryInfo = new QueryInfo(session.getQueryId(), session.toSessionRepresentation(), QueryState.FAILED, LocalMemoryManager.GENERAL_POOL, false, self, (List<String>)ImmutableList.of(), query, QueryStats.immediateFailureQueryStats(), Optional.empty(), Optional.empty(), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Map<String, SelectedRole>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), false, null, Optional.empty(), failureCause.getCause(), failureCause.getErrorCode(), (List<PrestoWarning>)ImmutableList.of(), (Set<Input>)ImmutableSet.of(), Optional.empty(), false, resourceGroupId, Optional.empty(), Optional.empty(), Optional.empty());
        return queryInfo;
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public MemoryPoolId getMemoryPool() {
        return this.memoryPool;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    @JsonProperty
    public Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    @JsonProperty
    public Optional<String> getSetSchema() {
        return this.setSchema;
    }

    @JsonProperty
    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    @JsonProperty
    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    @JsonProperty
    public Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    @JsonProperty
    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    @JsonProperty
    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    @JsonProperty
    public Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    @JsonProperty
    public boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<StageInfo> getOutputStage() {
        return this.outputStage;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public List<PrestoWarning> getWarnings() {
        return this.warnings;
    }

    @JsonProperty
    public boolean isFinalQueryInfo() {
        return this.state.isDone() && StageInfo.getAllStages(this.outputStage).stream().allMatch(StageInfo::isFinalStageInfo);
    }

    @JsonProperty
    public Set<Input> getInputs() {
        return this.inputs;
    }

    @JsonProperty
    public Optional<Output> getOutput() {
        return this.output;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public Optional<List<TaskId>> getFailedTasks() {
        return this.failedTasks;
    }

    @JsonProperty
    public Optional<List<StageId>> getRuntimeOptimizedStages() {
        return this.runtimeOptimizedStages;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).add("fieldNames", this.fieldNames).toString();
    }

    public boolean isCompleteInfo() {
        return this.completeInfo;
    }
}

