/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.presto.Session;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.DispatchQueryFactory;
import com.facebook.presto.dispatcher.LocalDispatchQuery;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.StatementUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class LocalDispatchQueryFactory
implements DispatchQueryFactory {
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final ListeningExecutorService executor;

    @Inject
    public LocalDispatchQueryFactory(QueryManager queryManager, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, QueryMonitor queryMonitor, LocationFactory locationFactory, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories, ClusterSizeMonitor clusterSizeMonitor, DispatchExecutor dispatchExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.executor = Objects.requireNonNull(dispatchExecutor, "executorService is null").getExecutor();
    }

    @Override
    public DispatchQuery createDispatchQuery(Session session, String query, QueryPreparer.PreparedQuery preparedQuery, String slug, ResourceGroupId resourceGroup, Optional<QueryType> queryType, WarningCollector warningCollector) {
        QueryStateMachine stateMachine = QueryStateMachine.begin(query, session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, queryType, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.transactionManager, this.accessControl, (Executor)this.executor, this.metadata, warningCollector);
        this.queryMonitor.queryCreatedEvent(stateMachine.getBasicQueryInfo(Optional.empty()));
        ListenableFuture queryExecutionFuture = this.executor.submit(() -> {
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(preparedQuery.getStatement().getClass());
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + preparedQuery.getStatement().getClass().getSimpleName());
            }
            return queryExecutionFactory.createQueryExecution(preparedQuery, stateMachine, slug, warningCollector, queryType);
        });
        return new LocalDispatchQuery(stateMachine, this.queryMonitor, (ListenableFuture<QueryExecution>)queryExecutionFuture, this.clusterSizeMonitor, (Executor)this.executor, this.queryManager::createQuery);
    }
}

