/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import java.util.Optional;

public class RowNumberStatsRule
extends SimpleStatsRule<RowNumberNode> {
    private static final Pattern<RowNumberNode> PATTERN = Patterns.rowNumber();

    public RowNumberStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<RowNumberNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> doCalculate(RowNumberNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        if (sourceStats.isOutputRowCountUnknown()) {
            return Optional.empty();
        }
        double sourceRowsCount = sourceStats.getOutputRowCount();
        double partitionCount = 1.0;
        for (VariableReferenceExpression groupByVariable : node.getPartitionBy()) {
            VariableStatsEstimate variableStatistics = sourceStats.getVariableStatistics(groupByVariable);
            boolean nullRow = variableStatistics.getNullsFraction() != 0.0;
            partitionCount *= variableStatistics.getDistinctValuesCount() + (double)nullRow;
        }
        if (Double.isNaN(partitionCount = Math.min(sourceRowsCount, partitionCount))) {
            return Optional.empty();
        }
        double rowsPerPartition = sourceRowsCount / partitionCount;
        if (node.getMaxRowCountPerPartition().isPresent()) {
            rowsPerPartition = Math.min(rowsPerPartition, (double)node.getMaxRowCountPerPartition().get().intValue());
        }
        double outputRowsCount = sourceRowsCount;
        if (node.getMaxRowCountPerPartition().isPresent()) {
            outputRowsCount = partitionCount * rowsPerPartition;
        }
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats).setOutputRowCount(outputRowsCount).addVariableStatistics(node.getRowNumberVariable(), VariableStatsEstimate.builder().setLowValue(1.0).setDistinctValuesCount(rowsPerPartition).setNullsFraction(0.0).setAverageRowSize(BigintType.BIGINT.getFixedSize()).build()).build());
    }
}

