/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VariableWidthType;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.util.MoreMath;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class PlanNodeStatsEstimate {
    private static final double DEFAULT_DATA_SIZE_PER_COLUMN = 50.0;
    private static final PlanNodeStatsEstimate UNKNOWN = new PlanNodeStatsEstimate(Double.NaN, (Map<VariableReferenceExpression, VariableStatsEstimate>)ImmutableMap.of());
    private final double outputRowCount;
    private final PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics;

    public static PlanNodeStatsEstimate unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public PlanNodeStatsEstimate(@JsonProperty(value="outputRowCount") double outputRowCount, @JsonProperty(value="variableStatistics") Map<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
        this(outputRowCount, (PMap<VariableReferenceExpression, VariableStatsEstimate>)HashTreePMap.from(Objects.requireNonNull(variableStatistics, "variableStatistics is null")));
    }

    private PlanNodeStatsEstimate(double outputRowCount, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
        Preconditions.checkArgument((Double.isNaN(outputRowCount) || outputRowCount >= 0.0 ? 1 : 0) != 0, (Object)"outputRowCount cannot be negative");
        this.outputRowCount = outputRowCount;
        this.variableStatistics = variableStatistics;
    }

    @JsonProperty
    public double getOutputRowCount() {
        return this.outputRowCount;
    }

    public double getOutputSizeInBytes(Collection<VariableReferenceExpression> outputVariables) {
        Objects.requireNonNull(outputVariables, "outputSymbols is null");
        return outputVariables.stream().mapToDouble(variable -> this.getOutputSizeForVariable(this.getVariableStatistics((VariableReferenceExpression)variable), variable.getType())).sum();
    }

    private double getOutputSizeForVariable(VariableStatsEstimate variableStatistics, Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        double averageRowSize = variableStatistics.getAverageRowSize();
        double nullsFraction = MoreMath.firstNonNaN(variableStatistics.getNullsFraction(), 0.0);
        double numberOfNonNullRows = this.outputRowCount * (1.0 - nullsFraction);
        if (Double.isNaN(averageRowSize)) {
            averageRowSize = type instanceof FixedWidthType ? (double)((FixedWidthType)type).getFixedSize() : 50.0;
        }
        double outputSize = numberOfNonNullRows * averageRowSize;
        outputSize += this.outputRowCount * 1.0;
        if (type instanceof VariableWidthType) {
            outputSize += this.outputRowCount * 4.0;
        }
        return outputSize;
    }

    public PlanNodeStatsEstimate mapOutputRowCount(Function<Double, Double> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).setOutputRowCount(mappingFunction.apply(this.outputRowCount)).build();
    }

    public PlanNodeStatsEstimate mapVariableColumnStatistics(VariableReferenceExpression variable, Function<VariableStatsEstimate, VariableStatsEstimate> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).addVariableStatistics(variable, mappingFunction.apply(this.getVariableStatistics(variable))).build();
    }

    public VariableStatsEstimate getVariableStatistics(VariableReferenceExpression variable) {
        return (VariableStatsEstimate)this.variableStatistics.getOrDefault((Object)variable, (Object)VariableStatsEstimate.unknown());
    }

    @JsonProperty
    public Map<VariableReferenceExpression, VariableStatsEstimate> getVariableStatistics() {
        return this.variableStatistics;
    }

    public Set<VariableReferenceExpression> getVariablesWithKnownStatistics() {
        return this.variableStatistics.keySet();
    }

    public boolean isOutputRowCountUnknown() {
        return Double.isNaN(this.outputRowCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outputRowCount", this.outputRowCount).add("variableStatistics", this.variableStatistics).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeStatsEstimate that = (PlanNodeStatsEstimate)o;
        return Double.compare(this.outputRowCount, that.outputRowCount) == 0 && Objects.equals(this.variableStatistics, that.variableStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.outputRowCount, this.variableStatistics);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(PlanNodeStatsEstimate other) {
        return new Builder(other.getOutputRowCount(), other.variableStatistics);
    }

    public static final class Builder {
        private double outputRowCount;
        private PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics;

        public Builder() {
            this(Double.NaN, (PMap<VariableReferenceExpression, VariableStatsEstimate>)HashTreePMap.empty());
        }

        private Builder(double outputRowCount, PMap<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
            this.outputRowCount = outputRowCount;
            this.variableStatistics = variableStatistics;
        }

        public Builder setOutputRowCount(double outputRowCount) {
            this.outputRowCount = outputRowCount;
            return this;
        }

        public Builder addVariableStatistics(VariableReferenceExpression variable, VariableStatsEstimate statistics) {
            this.variableStatistics = this.variableStatistics.plus((Object)variable, (Object)statistics);
            return this;
        }

        public Builder addVariableStatistics(Map<VariableReferenceExpression, VariableStatsEstimate> variableStatistics) {
            this.variableStatistics = this.variableStatistics.plusAll(variableStatistics);
            return this;
        }

        public Builder removeVariableStatistics(VariableReferenceExpression variable) {
            this.variableStatistics = this.variableStatistics.minus((Object)variable);
            return this;
        }

        public PlanNodeStatsEstimate build() {
            return new PlanNodeStatsEstimate(this.outputRowCount, this.variableStatistics);
        }
    }
}

