/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class MoreUninterruptibles {
    private MoreUninterruptibles() {
    }

    public static boolean tryLockUninterruptibly(Lock lock, long timeout, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    boolean bl = lock.tryLock(remainingNanos, TimeUnit.NANOSECONDS);
                    return bl;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

