/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SetOperationNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final FunctionManager functionManager;

    public UnaliasSymbolReferences(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(types, this.functionManager), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Map<String, String> mapping = new HashMap<String, String>();
        private final TypeProvider types;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;

        private Rewriter(TypeProvider types, FunctionManager functionManager) {
            this.types = types;
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionManager);
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<VariableReferenceExpression, VariableReferenceExpression> newGroupingMappings = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            for (List<VariableReferenceExpression> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (VariableReferenceExpression output : groupingSet) {
                    newGroupingMappings.putIfAbsent(this.canonicalize(output), this.canonicalize(node.getGroupingColumns().get(output)));
                    newGroupingSet.add((Object)this.canonicalize(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            return new GroupIdNode(node.getId(), source, (List<List<VariableReferenceExpression>>)newGroupingSets.build(), newGroupingMappings, this.canonicalizeAndDistinct(node.getAggregationArguments()), this.canonicalize(node.getGroupIdVariable()));
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ExplainAnalyzeNode(node.getId(), source, this.canonicalize(node.getOutputVariable()), node.isVerbose());
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new MarkDistinctNode(node.getId(), source, this.canonicalize(node.getMarkerVariable()), this.canonicalizeAndDistinct(node.getDistinctVariables()), this.canonicalize(node.getHashVariable()));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : node.getUnnestVariables().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), entry.getValue());
            }
            return new UnnestNode(node.getId(), source, this.canonicalizeAndDistinct(node.getReplicateVariables()), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)builder.build(), node.getOrdinalityVariable());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                VariableReferenceExpression variable = entry.getKey();
                CallExpression callExpression = entry.getValue().getFunctionCall();
                List<RowExpression> rewrittenArguments = this.canonicalizeCallExpression(callExpression);
                WindowNode.Frame canonicalFrame = this.canonicalize(entry.getValue().getFrame());
                functions.put((Object)this.canonicalize(variable), (Object)new WindowNode.Function(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), rewrittenArguments), canonicalFrame, entry.getValue().isIgnoreNulls()));
            }
            return new WindowNode(node.getId(), source, this.canonicalizeAndDistinct(node.getSpecification()), (Map<VariableReferenceExpression, WindowNode.Function>)functions.build(), this.canonicalize(node.getHashVariable()), this.canonicalize(node.getPrePartitionedInputs()), node.getPreSortedOrderPrefix());
        }

        private List<RowExpression> canonicalizeCallExpression(CallExpression callExpression) {
            return (List)callExpression.getArguments().stream().map(this::canonicalize).collect(ImmutableList.toImmutableList());
        }

        private WindowNode.Frame canonicalize(WindowNode.Frame frame) {
            return new WindowNode.Frame(frame.getType(), frame.getStartType(), this.canonicalize(frame.getStartValue()), frame.getEndType(), this.canonicalize(frame.getEndValue()), frame.getOriginalStartValue(), frame.getOriginalEndValue());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return node;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List sources = (List)node.getSources().stream().map(context::rewrite).collect(ImmutableList.toImmutableList());
            this.mapExchangeNodeSymbols(node);
            ArrayList<List<VariableReferenceExpression>> inputs = new ArrayList<List<VariableReferenceExpression>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputs.add(new ArrayList());
            }
            HashSet<VariableReferenceExpression> addedOutputs = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
                for (int i = 0; i < node.getInputs().size(); ++i) {
                    List<VariableReferenceExpression> input = node.getInputs().get(i);
                    ((List)inputs.get(i)).add(this.canonicalize(input.get(variableIndex)));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(node.getPartitioningScheme().getPartitioning().translateVariable(this::canonicalize), (List<VariableReferenceExpression>)outputs.build(), this.canonicalize(node.getPartitioningScheme().getHashColumn()), node.getPartitioningScheme().isReplicateNullsAndAny(), node.getPartitioningScheme().getBucketToPartition());
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme().map(this::canonicalizeAndDistinct);
            return new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, sources, inputs, node.isEnsureSourceOrdering(), orderingScheme);
        }

        private void mapExchangeNodeSymbols(ExchangeNode node) {
            if (node.getInputs().size() == 1) {
                this.mapExchangeNodeOutputToInputSymbols(node);
                return;
            }
            HashMap<List<VariableReferenceExpression>, VariableReferenceExpression> inputsToOutputs = new HashMap<List<VariableReferenceExpression>, VariableReferenceExpression>();
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                List<VariableReferenceExpression> canonicalInputs = this.canonicalizeExchangeNodeInputs(node, variableIndex);
                VariableReferenceExpression output = (VariableReferenceExpression)inputsToOutputs.get(canonicalInputs);
                if (output == null || canonicalOutput.equals((Object)output)) {
                    inputsToOutputs.put(canonicalInputs, canonicalOutput);
                    continue;
                }
                this.map(canonicalOutput, output);
            }
        }

        private void mapExchangeNodeOutputToInputSymbols(ExchangeNode node) {
            Preconditions.checkState((node.getInputs().size() == 1 ? 1 : 0) != 0);
            for (int variableIndex = 0; variableIndex < node.getOutputVariables().size(); ++variableIndex) {
                VariableReferenceExpression canonicalInput;
                VariableReferenceExpression canonicalOutput = this.canonicalize(node.getOutputVariables().get(variableIndex));
                if (canonicalOutput.equals((Object)(canonicalInput = this.canonicalize(node.getInputs().get(0).get(variableIndex))))) continue;
                this.map(canonicalOutput, canonicalInput);
            }
        }

        private List<VariableReferenceExpression> canonicalizeExchangeNodeInputs(ExchangeNode node, int symbolIndex) {
            return (List)node.getInputs().stream().map(input -> this.canonicalize((VariableReferenceExpression)input.get(symbolIndex))).collect(ImmutableList.toImmutableList());
        }

        @Override
        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), this.canonicalizeAndDistinct(node.getOutputVariables()), node.isEnsureSourceOrdering(), node.getOrderingScheme().map(this::canonicalizeAndDistinct), node.getExchangeType());
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite((PlanNode)node);
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DistinctLimitNode(node.getId(), context.rewrite(node.getSource()), node.getLimit(), node.isPartial(), this.canonicalizeAndDistinct(node.getDistinctVariables()), this.canonicalize(node.getHashVariable()));
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new SampleNode(node.getId(), context.rewrite(node.getSource()), node.getSampleRatio(), node.getSampleType());
        }

        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List canonicalizedRows = (List)node.getRows().stream().map(rowExpressions -> (ImmutableList)rowExpressions.stream().map(this::canonicalize).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            List<VariableReferenceExpression> canonicalizedOutputVariables = this.canonicalizeAndDistinct(node.getOutputVariables());
            Preconditions.checkState((node.getOutputVariables().size() == canonicalizedOutputVariables.size() ? 1 : 0) != 0, (Object)"Values output symbols were pruned");
            return new ValuesNode(node.getId(), canonicalizedOutputVariables, canonicalizedRows);
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DeleteNode(node.getId(), context.rewrite(node.getSource()), this.canonicalize(node.getRowId()), node.getOutputVariables());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalize(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), this.canonicalize(node.getHashVariable()));
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new TopNRowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getSpecification()), this.canonicalize(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashVariable()));
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ProjectNode(node.getId(), source, this.canonicalize(node.getAssignments()));
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform(node.getOutputVariables(), this::canonicalize);
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new EnforceSingleRowNode(node.getId(), source);
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new AssignUniqueId(node.getId(), source, node.getIdVariable());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List canonicalCorrelation = Lists.transform(node.getCorrelation(), this::canonicalize);
            Assignments assignments = this.canonicalize(node.getSubqueryAssignments());
            ApplyNodeUtil.verifySubquerySupported(assignments);
            return new ApplyNode(node.getId(), source, subquery, assignments, canonicalCorrelation, node.getOriginSubqueryError());
        }

        @Override
        public PlanNode visitLateralJoin(LateralJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List<VariableReferenceExpression> canonicalCorrelation = this.canonicalizeAndDistinct(node.getCorrelation());
            return new LateralJoinNode(node.getId(), source, subquery, canonicalCorrelation, node.getType(), node.getOriginSubqueryError());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source, node.getId());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new SortNode(node.getId(), source, this.canonicalizeAndDistinct(node.getOrderingScheme()), node.isPartial());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            List<JoinNode.EquiJoinClause> canonicalCriteria = this.canonicalizeJoinCriteria(node.getCriteria());
            Optional<RowExpression> canonicalFilter = node.getFilter().map(this::canonicalize);
            Optional<VariableReferenceExpression> canonicalLeftHashVariable = this.canonicalize(node.getLeftHashVariable());
            Optional<VariableReferenceExpression> canonicalRightHashVariable = this.canonicalize(node.getRightHashVariable());
            if (node.getType().equals((Object)JoinNode.Type.INNER)) {
                canonicalCriteria.stream().filter(clause -> clause.getLeft().getType().equals(clause.getRight().getType())).filter(clause -> node.getOutputVariables().contains(clause.getLeft())).forEach(clause -> this.map(clause.getRight(), clause.getLeft()));
            }
            return new JoinNode(node.getId(), node.getType(), left, right, canonicalCriteria, this.canonicalizeAndDistinct(node.getOutputVariables()), canonicalFilter, canonicalLeftHashVariable, canonicalRightHashVariable, node.getDistributionType());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            PlanNode filteringSource = context.rewrite(node.getFilteringSource());
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinVariable()), this.canonicalize(node.getFilteringSourceJoinVariable()), this.canonicalize(node.getSemiJoinOutput()), this.canonicalize(node.getSourceHashVariable()), this.canonicalize(node.getFilteringSourceHashVariable()), node.getDistributionType());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            return new SpatialJoinNode(node.getId(), node.getType(), left, right, this.canonicalizeAndDistinct(node.getOutputVariables()), this.canonicalize(node.getFilter()), this.canonicalize(node.getLeftPartitionVariable()), this.canonicalize(node.getRightPartitionVariable()), node.getKdbTree());
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), this.canonicalize(node.getLookupVariables()), node.getOutputVariables(), node.getAssignments(), node.getCurrentConstraint());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode probeSource = context.rewrite(node.getProbeSource());
            PlanNode indexSource = context.rewrite(node.getIndexSource());
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()), this.canonicalize(node.getProbeHashVariable()), this.canonicalize(node.getIndexHashVariable()));
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new UnionNode(node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IntersectNode(node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new ExceptNode(node.getId(), (List)Rewriter.rewriteSources((SetOperationNode)node, context).build(), this.canonicalizeSetOperationOutputVariables(node.getOutputVariables()), this.canonicalizeSetOperationVariableMap(node.getVariableMapping()));
        }

        private static ImmutableList.Builder<PlanNode> rewriteSources(SetOperationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)context.rewrite(source));
            }
            return rewrittenSources;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitTableWriteMerge(TableWriterMergeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            SymbolMapper mapper = new SymbolMapper(this.mapping, this.types);
            return mapper.map(node, source);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        private void map(VariableReferenceExpression variable, VariableReferenceExpression canonical) {
            Preconditions.checkArgument((!variable.equals((Object)canonical) ? 1 : 0) != 0, (String)"Can't map variable to itself: %s", (Object)variable);
            this.mapping.put(variable.getName(), canonical.getName());
        }

        private Assignments canonicalize(Assignments oldAssignments) {
            HashMap computedExpressions = new HashMap();
            Assignments.Builder assignments = Assignments.builder();
            for (Map.Entry entry : oldAssignments.getMap().entrySet()) {
                VariableReferenceExpression variable;
                RowExpression expression = this.canonicalize((RowExpression)entry.getValue());
                if (expression instanceof VariableReferenceExpression) {
                    variable = (VariableReferenceExpression)expression;
                    if (!variable.getName().equals(((VariableReferenceExpression)entry.getKey()).getName())) {
                        this.map((VariableReferenceExpression)entry.getKey(), variable);
                    }
                } else if (OriginalExpressionUtils.isExpression(expression) && OriginalExpressionUtils.castToExpression(expression) instanceof SymbolReference) {
                    variable = new VariableReferenceExpression(Symbol.from(OriginalExpressionUtils.castToExpression(expression)).getName(), this.types.get(OriginalExpressionUtils.castToExpression(expression)));
                    if (!variable.getName().equals(((VariableReferenceExpression)entry.getKey()).getName())) {
                        this.map((VariableReferenceExpression)entry.getKey(), variable);
                    }
                } else if (!Rewriter.isNull(expression) && this.isDeterministic(expression)) {
                    VariableReferenceExpression computedVariable = (VariableReferenceExpression)computedExpressions.get(expression);
                    if (computedVariable == null) {
                        computedExpressions.put(expression, entry.getKey());
                    } else {
                        this.map((VariableReferenceExpression)entry.getKey(), computedVariable);
                    }
                }
                VariableReferenceExpression canonical = this.canonicalize((VariableReferenceExpression)entry.getKey());
                assignments.put(canonical, expression);
            }
            return assignments.build();
        }

        private boolean isDeterministic(RowExpression expression) {
            if (OriginalExpressionUtils.isExpression(expression)) {
                return ExpressionDeterminismEvaluator.isDeterministic(OriginalExpressionUtils.castToExpression(expression));
            }
            return this.determinismEvaluator.isDeterministic(expression);
        }

        private static boolean isNull(RowExpression expression) {
            if (OriginalExpressionUtils.isExpression(expression)) {
                return OriginalExpressionUtils.castToExpression(expression) instanceof NullLiteral;
            }
            return Expressions.isNull(expression);
        }

        private Symbol canonicalize(Symbol symbol) {
            String canonical = symbol.getName();
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return new Symbol(canonical);
        }

        private VariableReferenceExpression canonicalize(VariableReferenceExpression variable) {
            String canonical = variable.getName();
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return new VariableReferenceExpression(canonical, this.types.get((Expression)new SymbolReference(canonical)));
        }

        private Optional<VariableReferenceExpression> canonicalize(Optional<VariableReferenceExpression> variable) {
            if (variable.isPresent()) {
                return Optional.of(this.canonicalize(variable.get()));
            }
            return Optional.empty();
        }

        private RowExpression canonicalize(RowExpression value) {
            if (OriginalExpressionUtils.isExpression(value)) {
                return OriginalExpressionUtils.castToRowExpression(this.canonicalize(OriginalExpressionUtils.castToExpression(value)));
            }
            return RowExpressionVariableInliner.inlineVariables(this::canonicalize, value);
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = this.canonicalize(Symbol.from((Expression)node));
                    return canonical.toSymbolReference();
                }
            }, (Expression)value);
        }

        private List<VariableReferenceExpression> canonicalizeAndDistinct(List<VariableReferenceExpression> outputs) {
            HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (VariableReferenceExpression variable : outputs) {
                VariableReferenceExpression canonical = this.canonicalize(variable);
                if (!added.add(canonical)) continue;
                builder.add((Object)canonical);
            }
            return builder.build();
        }

        private WindowNode.Specification canonicalizeAndDistinct(WindowNode.Specification specification) {
            return new WindowNode.Specification(this.canonicalizeAndDistinct(specification.getPartitionBy()), specification.getOrderingScheme().map(this::canonicalizeAndDistinct));
        }

        private OrderingScheme canonicalizeAndDistinct(OrderingScheme orderingScheme) {
            HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
            ImmutableList.Builder variables = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (VariableReferenceExpression variable2 : orderingScheme.getOrderByVariables()) {
                VariableReferenceExpression canonical = this.canonicalize(variable2);
                if (!added.add(canonical)) continue;
                variables.add((Object)canonical);
                orderings.put((Object)canonical, (Object)orderingScheme.getOrdering(variable2));
            }
            ImmutableMap orderingsMap = orderings.build();
            return new OrderingScheme((List)variables.build().stream().map(variable -> new Ordering(variable, (SortOrder)orderingsMap.get(variable))).collect(ImmutableList.toImmutableList()));
        }

        private Set<VariableReferenceExpression> canonicalize(Set<VariableReferenceExpression> variables) {
            return (Set)variables.stream().map(this::canonicalize).collect(ImmutableSet.toImmutableSet());
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private Map<VariableReferenceExpression, List<VariableReferenceExpression>> canonicalizeSetOperationVariableMap(Map<VariableReferenceExpression, List<VariableReferenceExpression>> setOperationVariableMap) {
            LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>> result = new LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>>();
            HashSet<VariableReferenceExpression> addVariables = new HashSet<VariableReferenceExpression>();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : setOperationVariableMap.entrySet()) {
                VariableReferenceExpression canonicalOutputVariable = this.canonicalize(entry.getKey());
                if (!addVariables.add(canonicalOutputVariable)) continue;
                result.put(canonicalOutputVariable, (List<VariableReferenceExpression>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)entry.getValue(), this::canonicalize)));
            }
            return result;
        }

        private List<VariableReferenceExpression> canonicalizeSetOperationOutputVariables(List<VariableReferenceExpression> setOperationOutputVariables) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (VariableReferenceExpression variable : setOperationOutputVariables) {
                builder.add((Object)this.canonicalize(variable));
            }
            return builder.build();
        }
    }
}

