/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ExpressionVariableInliner;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.NoOpVariableResolver;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.ExpressionEquivalence;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PredicatePushDown
implements PlanOptimizer {
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;
    private final EffectivePredicateExtractor effectivePredicateExtractor;
    private final SqlParser sqlParser;

    public PredicatePushDown(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        this.effectivePredicateExtractor = new EffectivePredicateExtractor(new ExpressionDomainTranslator(this.literalEncoder));
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(variableAllocator, idAllocator, this.metadata, this.literalEncoder, this.effectivePredicateExtractor, this.sqlParser, session, types), plan, BooleanLiteral.TRUE_LITERAL);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Expression> {
        private final PlanVariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final LiteralEncoder literalEncoder;
        private final EffectivePredicateExtractor effectivePredicateExtractor;
        private final SqlParser sqlParser;
        private final Session session;
        private final TypeProvider types;
        private final ExpressionEquivalence expressionEquivalence;

        private Rewriter(PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, LiteralEncoder literalEncoder, EffectivePredicateExtractor effectivePredicateExtractor, SqlParser sqlParser, Session session, TypeProvider types) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
            this.effectivePredicateExtractor = Objects.requireNonNull(effectivePredicateExtractor, "effectivePredicateExtractor is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.expressionEquivalence = new ExpressionEquivalence(metadata, sqlParser);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, (Expression)BooleanLiteral.TRUE_LITERAL);
            if (!context.get().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, OriginalExpressionUtils.castToRowExpression(context.get()));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                HashMap<VariableReferenceExpression, SymbolReference> outputsToInputs = new HashMap<VariableReferenceExpression, SymbolReference>();
                for (int index = 0; index < node.getInputs().get(i).size(); ++index) {
                    outputsToInputs.put(node.getOutputVariables().get(index), new SymbolReference(node.getInputs().get(i).get(index).getName()));
                }
                Expression sourcePredicate = ExpressionVariableInliner.inlineVariables(outputsToInputs, context.get(), this.types);
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new ExchangeNode(node.getId(), node.getType(), node.getScope(), node.getPartitioningScheme(), (List<PlanNode>)builder.build(), node.getInputs(), node.isEnsureSourceOrdering(), node.getOrderingScheme());
            }
            return node;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Predicate<Expression> isSupported = conjunct -> {
                if (!ExpressionDeterminismEvaluator.isDeterministic(conjunct)) return false;
                if (!VariablesExtractor.extractUnique(conjunct, this.types).stream().allMatch(node.getPartitionBy()::contains)) return false;
                return true;
            };
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(isSupported));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false))));
            }
            return rewrittenNode;
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set deterministicVariables = node.getAssignments().entrySet().stream().filter(entry -> ExpressionDeterminismEvaluator.isDeterministic(OriginalExpressionUtils.castToExpression((RowExpression)entry.getValue()))).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<Expression> deterministic = conjunct -> deterministicVariables.containsAll(VariablesExtractor.extractUnique(conjunct, this.types));
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            List<Expression> deterministicConjuncts = conjuncts.get(true);
            Map<Boolean, List<Expression>> inlineConjuncts = deterministicConjuncts.stream().collect(Collectors.partitioningBy(expression -> this.isInliningCandidate((Expression)expression, node)));
            List<Expression> inlinedDeterministicConjuncts = inlineConjuncts.get(true).stream().map(entry -> ExpressionVariableInliner.inlineVariables(Maps.transformValues((Map)node.getAssignments().getMap(), OriginalExpressionUtils::castToExpression), entry, this.types)).collect(Collectors.toList());
            PlanNode rewrittenNode = context.defaultRewrite((PlanNode)node, ExpressionUtils.combineConjuncts(inlinedDeterministicConjuncts));
            List<Expression> nonInliningConjuncts = inlineConjuncts.get(false);
            nonInliningConjuncts.addAll((Collection<Expression>)conjuncts.get(false));
            if (!nonInliningConjuncts.isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts(nonInliningConjuncts)));
            }
            return rewrittenNode;
        }

        private boolean isInliningCandidate(Expression expression, ProjectNode node) {
            Verify.verify((boolean)AstUtils.preOrder((Node)expression).noneMatch(TryExpression.class::isInstance));
            ImmutableSet childOutputSet = ImmutableSet.copyOf((Collection)node.getOutputVariables());
            Map dependencies = VariablesExtractor.extractAll(expression, this.types).stream().filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return dependencies.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 1L || OriginalExpressionUtils.castToExpression(node.getAssignments().get((VariableReferenceExpression)entry.getKey())) instanceof Literal);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Map<VariableReferenceExpression, SymbolReference> commonGroupingVariableMapping = node.getGroupingColumns().entrySet().stream().filter(entry -> node.getCommonGroupingColumns().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> new SymbolReference(((VariableReferenceExpression)entry.getValue()).getName())));
            Predicate<Expression> pushdownEligiblePredicate = conjunct -> VariablesExtractor.extractUnique(conjunct, this.types).stream().allMatch(commonGroupingVariableMapping.keySet()::contains);
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(pushdownEligiblePredicate));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionVariableInliner.inlineVariables(commonGroupingVariableMapping, ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)), this.types));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false))));
            }
            return rewrittenNode;
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            ImmutableSet pushDownableVariables = ImmutableSet.copyOf((Collection)node.getDistinctVariables());
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(arg_0 -> this.lambda$visitMarkDistinct$9((Set)pushDownableVariables, arg_0)));
            PlanNode rewrittenNode = context.defaultRewrite((PlanNode)node, ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false))));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionVariableInliner.inlineVariables(Maps.transformValues((Map)node.sourceVariableMap(i), variable -> new SymbolReference(variable.getName())), context.get(), this.types);
                PlanNode source = (PlanNode)node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List)builder.build(), node.getOutputVariables(), node.getVariableMapping());
            }
            return node;
        }

        @Deprecated
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenPlan = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(OriginalExpressionUtils.castToExpression(node.getPredicate()), context.get()));
            if (!(rewrittenPlan instanceof FilterNode)) {
                return rewrittenPlan;
            }
            FilterNode rewrittenFilterNode = (FilterNode)rewrittenPlan;
            if (!this.areExpressionsEquivalent(OriginalExpressionUtils.castToExpression(rewrittenFilterNode.getPredicate()), OriginalExpressionUtils.castToExpression(node.getPredicate())) || node.getSource() != rewrittenFilterNode.getSource()) {
                return rewrittenPlan;
            }
            return node;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean filtersEquivalent;
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            BooleanLiteral rightPredicate;
            BooleanLiteral leftPredicate;
            Expression inheritedPredicate = context.get();
            node = this.tryNormalizeToOuterToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(node.getLeft(), this.types);
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(node.getRight(), this.types);
            Expression joinPredicate = Rewriter.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputVariables());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = rightOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case FULL: {
                    leftPredicate = BooleanLiteral.TRUE_LITERAL;
                    rightPredicate = BooleanLiteral.TRUE_LITERAL;
                    postJoinPredicate = inheritedPredicate;
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            if (newJoinPredicate.equals((Object)BooleanLiteral.FALSE_LITERAL)) {
                newJoinPredicate = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("1"));
            }
            PlanNode leftSource = context.rewrite(node.getLeft(), (Expression)leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), (Expression)rightPredicate);
            JoinNode output = node;
            Assignments.Builder leftProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getLeft().getOutputVariables()));
            Assignments.Builder rightProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getRight().getOutputVariables()));
            ArrayList<JoinNode.EquiJoinClause> equiJoinClauses = new ArrayList<JoinNode.EquiJoinClause>();
            ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(newJoinPredicate)) {
                if (this.joinEqualityExpression(node.getLeft().getOutputVariables()).test(conjunct)) {
                    ComparisonExpression equality = (ComparisonExpression)conjunct;
                    boolean alignedComparison = Iterables.all(VariablesExtractor.extractUnique(equality.getLeft(), this.types), (com.google.common.base.Predicate)Predicates.in((Collection)node.getLeft().getOutputVariables()));
                    Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                    Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                    VariableReferenceExpression leftVariable = this.variableForExpression(leftExpression);
                    if (!node.getLeft().getOutputVariables().contains(leftVariable)) {
                        leftProjections.put(leftVariable, OriginalExpressionUtils.castToRowExpression(leftExpression));
                    }
                    VariableReferenceExpression rightVariable = this.variableForExpression(rightExpression);
                    if (!node.getRight().getOutputVariables().contains(rightVariable)) {
                        rightProjections.put(rightVariable, OriginalExpressionUtils.castToRowExpression(rightExpression));
                    }
                    equiJoinClauses.add(new JoinNode.EquiJoinClause(leftVariable, rightVariable));
                    continue;
                }
                joinFilterBuilder.add((Object)conjunct);
            }
            Optional<Object> newJoinFilter = Optional.of(ExpressionUtils.combineConjuncts((Collection<Expression>)joinFilterBuilder.build()));
            if (newJoinFilter.get() == BooleanLiteral.TRUE_LITERAL) {
                newJoinFilter = Optional.empty();
            }
            if (node.getType() == JoinNode.Type.INNER && newJoinFilter.isPresent() && equiJoinClauses.isEmpty()) {
                postJoinPredicate = ExpressionUtils.combineConjuncts(postJoinPredicate, (Expression)newJoinFilter.get());
                newJoinFilter = Optional.empty();
            }
            boolean bl = filtersEquivalent = newJoinFilter.isPresent() == node.getFilter().isPresent() && (!newJoinFilter.isPresent() || this.areExpressionsEquivalent((Expression)newJoinFilter.get(), OriginalExpressionUtils.castToExpression(node.getFilter().get())));
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !filtersEquivalent || !ImmutableSet.copyOf(equiJoinClauses).equals((Object)ImmutableSet.copyOf(node.getCriteria()))) {
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                Optional<JoinNode.DistributionType> distributionType = node.getDistributionType();
                if (node.getDistributionType().isPresent()) {
                    if (node.getType().mustPartition()) {
                        distributionType = Optional.of(JoinNode.DistributionType.PARTITIONED);
                    }
                    if (node.getType().mustReplicate(equiJoinClauses)) {
                        distributionType = Optional.of(JoinNode.DistributionType.REPLICATED);
                    }
                }
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, equiJoinClauses, (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftSource.getOutputVariables()).addAll((Iterable)rightSource.getOutputVariables()).build(), newJoinFilter.map(OriginalExpressionUtils::castToRowExpression), node.getLeftHashVariable(), node.getRightHashVariable(), distributionType);
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(postJoinPredicate));
            }
            if (!node.getOutputVariables().equals(output.getOutputVariables())) {
                output = new ProjectNode(this.idAllocator.getNextId(), (PlanNode)output, AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getOutputVariables()));
            }
            return output;
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.get();
            if (node.getType() == SpatialJoinNode.Type.LEFT && this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate)) {
                node = new SpatialJoinNode(node.getId(), SpatialJoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getOutputVariables(), node.getFilter(), node.getLeftPartitionVariable(), node.getRightPartitionVariable(), node.getKdbTree());
            }
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(node.getLeft(), this.types);
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(node.getRight(), this.types);
            Expression joinPredicate = OriginalExpressionUtils.castToExpression(node.getFilter());
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputVariables());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Verify.verify((!newJoinPredicate.equals((Object)BooleanLiteral.FALSE_LITERAL) ? 1 : 0) != 0, (String)"Spatial join predicate is missing", (Object[])new Object[0]);
            PlanNode leftSource = context.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), rightPredicate);
            SpatialJoinNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !this.areExpressionsEquivalent(newJoinPredicate, joinPredicate)) {
                Assignments.Builder leftProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getLeft().getOutputVariables()));
                Assignments.Builder rightProjections = Assignments.builder().putAll(AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getRight().getOutputVariables()));
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = new SpatialJoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getOutputVariables(), OriginalExpressionUtils.castToRowExpression(newJoinPredicate), node.getLeftPartitionVariable(), node.getRightPartitionVariable(), node.getKdbTree());
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(postJoinPredicate));
            }
            return output;
        }

        private VariableReferenceExpression variableForExpression(Expression expression) {
            if (expression instanceof SymbolReference) {
                return new VariableReferenceExpression(((SymbolReference)expression).getName(), this.extractType(expression));
            }
            return this.variableAllocator.newVariable(expression, this.extractType(expression));
        }

        private OuterJoinPushDownResult processLimitedOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<VariableReferenceExpression> outerVariables) {
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(outerEffectivePredicate, this.types), (com.google.common.base.Predicate)Predicates.in(outerVariables)), (Object)"outerEffectivePredicate must only contain variables from outerVariables");
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(innerEffectivePredicate, this.types), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables))), (Object)"innerEffectivePredicate must not contain variables from outerVariables");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            postJoinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(innerEffectivePredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic)));
            joinPredicate = ExpressionUtils.filterDeterministicConjuncts(joinPredicate);
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            EqualityInference outerInference = EqualityInference.createEqualityInference(inheritedPredicate, outerEffectivePredicate);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(outerVariables), this.types);
            Expression outerOnlyInheritedEqualities = ExpressionUtils.combineConjuncts(equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression outerRewritten = outerInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(outerVariables), this.types);
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(outerRewritten, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)), this.types);
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(outerEffectivePredicate)) {
                Expression rewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)), this.types);
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)), this.types);
                if (innerRewritten != null) {
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                joinConjuncts.add((Object)conjunct);
            }
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)), this.types).getScopeEqualities());
            EqualityInference.EqualityPartition joinEqualityPartition = EqualityInference.createEqualityInference(joinPredicate).generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerVariables)), this.types);
            innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
            joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
            return new OuterJoinPushDownResult(ExpressionUtils.combineConjuncts((Collection<Expression>)outerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)innerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<VariableReferenceExpression> leftVariables) {
            Expression rewritten;
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(leftEffectivePredicate, this.types), (com.google.common.base.Predicate)Predicates.in(leftVariables)), (Object)"leftEffectivePredicate must only contain variables from leftVariables");
            Preconditions.checkArgument((boolean)Iterables.all(VariablesExtractor.extractUnique(rightEffectivePredicate, this.types), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables))), (Object)"rightEffectivePredicate must not contain variables from leftVariables");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(inheritedPredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic)));
            joinPredicate = ExpressionUtils.filterDeterministicConjuncts(joinPredicate);
            leftEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(leftEffectivePredicate);
            rightEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(rightEffectivePredicate);
            EqualityInference allInference = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutLeftInferred = EqualityInference.createEqualityInference(inheritedPredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutRightInferred = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables), this.types);
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)), this.types)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(rightEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables), this.types);
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(leftEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)), this.types);
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression rightRewritten;
                Expression leftRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables), this.types);
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)), this.types)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(leftVariables), this.types).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftVariables)), this.types).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in(leftVariables)).apply(arg_0)), this.types).getScopeStraddlingEqualities());
            return new InnerJoinPushDownResult(ExpressionUtils.combineConjuncts((Collection<Expression>)leftPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)rightPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private static Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)JoinNodeUtils.toExpression(equiJoinClause));
            }
            joinNode.getFilter().map(OriginalExpressionUtils::castToExpression).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return ExpressionUtils.combineConjuncts((Collection<Expression>)builder.build());
        }

        private Type extractType(Expression expression) {
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, expression, Collections.emptyList(), WarningCollector.NOOP);
            return expressionTypes.get(NodeRef.of((Node)expression));
        }

        private JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.FULL).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object)((Object)node.getType()));
            if (node.getType() == JoinNode.Type.INNER) {
                return node;
            }
            if (node.getType() == JoinNode.Type.FULL) {
                boolean canConvertToLeftJoin = this.canConvertOuterToInner(node.getLeft().getOutputVariables(), inheritedPredicate);
                boolean canConvertToRightJoin = this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate);
                if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                    return node;
                }
                if (canConvertToLeftJoin && canConvertToRightJoin) {
                    return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
                }
                return new JoinNode(node.getId(), canConvertToLeftJoin ? JoinNode.Type.LEFT : JoinNode.Type.RIGHT, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
            }
            if (node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputVariables(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputVariables(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
        }

        private boolean canConvertOuterToInner(List<VariableReferenceExpression> innerVariablesForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerVariables = ImmutableSet.copyOf(innerVariablesForOuterJoin);
            for (Expression conjunct : ExpressionUtils.extractConjuncts(inheritedPredicate)) {
                Object response;
                if (!ExpressionDeterminismEvaluator.isDeterministic(conjunct) || (response = this.nullInputEvaluator((Collection<VariableReferenceExpression>)innerVariables, conjunct)) != null && !(response instanceof NullLiteral) && !Boolean.FALSE.equals(response)) continue;
                return true;
            }
            return false;
        }

        private Expression simplifyExpression(Expression expression) {
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, expression, Collections.emptyList(), WarningCollector.NOOP);
            ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes);
            return this.literalEncoder.toExpression(optimizer.optimize(NoOpVariableResolver.INSTANCE), expressionTypes.get(NodeRef.of((Node)expression)));
        }

        private boolean areExpressionsEquivalent(Expression leftExpression, Expression rightExpression) {
            return this.expressionEquivalence.areExpressionsEquivalent(this.session, leftExpression, rightExpression, this.types);
        }

        private Object nullInputEvaluator(Collection<VariableReferenceExpression> nullVariables, Expression expression) {
            Set nullVariableNames = (Set)nullVariables.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet());
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, expression, Collections.emptyList(), WarningCollector.NOOP);
            return ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes).optimize(variable -> nullVariableNames.contains(variable.getName()) ? null : new Symbol(variable.getName()).toSymbolReference());
        }

        private Predicate<Expression> joinEqualityExpression(Collection<VariableReferenceExpression> leftVariables) {
            return expression -> {
                ComparisonExpression comparison;
                if (ExpressionDeterminismEvaluator.isDeterministic(expression) && expression instanceof ComparisonExpression && (comparison = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    Set<VariableReferenceExpression> variables1 = VariablesExtractor.extractUnique(comparison.getLeft(), this.types);
                    Set<VariableReferenceExpression> variables2 = VariablesExtractor.extractUnique(comparison.getRight(), this.types);
                    if (variables1.isEmpty() || variables2.isEmpty()) {
                        return false;
                    }
                    return Iterables.all(variables1, (com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)) && Iterables.all(variables2, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftVariables))) || Iterables.all(variables2, (com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)) && Iterables.all(variables1, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftVariables)));
                }
                return false;
            };
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            if (!ExpressionUtils.extractConjuncts(inheritedPredicate).contains(new SymbolReference(node.getSemiJoinOutput().getName()))) {
                return this.visitNonFilteringSemiJoin(node, context);
            }
            return this.visitFilteringSemiJoin(node, context);
        }

        private PlanNode visitNonFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            PlanNode rewrittenFilteringSource = context.defaultRewrite(node.getFilteringSource(), (Expression)BooleanLiteral.TRUE_LITERAL);
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = inheritedInference.rewriteExpressionAllowNonDeterministic(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)node.getSource().getOutputVariables()), this.types);
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in((Collection)node.getSource().getOutputVariables())).apply(arg_0)), this.types);
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(sourceConjuncts));
            SemiJoinNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts(postJoinConjuncts)));
            }
            return output;
        }

        private PlanNode visitFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression rewritten;
            Expression rewrittenConjunct;
            Expression inheritedPredicate = context.get();
            Expression deterministicInheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(inheritedPredicate);
            Expression sourceEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(node.getSource(), this.types));
            Expression filteringSourceEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.effectivePredicateExtractor.extract(node.getFilteringSource(), this.types));
            ComparisonExpression joinExpression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference(node.getSourceJoinVariable().getName()), (Expression)new SymbolReference(node.getFilteringSourceJoinVariable().getName()));
            List sourceVariables = node.getSource().getOutputVariables();
            List filteringSourceVariables = node.getFilteringSource().getOutputVariables();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            EqualityInference allInference = EqualityInference.createEqualityInference(new Expression[]{deterministicInheritedPredicate, sourceEffectivePredicate, filteringSourceEffectivePredicate, joinExpression});
            EqualityInference allInferenceWithoutSourceInferred = EqualityInference.createEqualityInference(new Expression[]{deterministicInheritedPredicate, filteringSourceEffectivePredicate, joinExpression});
            EqualityInference allInferenceWithoutFilteringSourceInferred = EqualityInference.createEqualityInference(new Expression[]{deterministicInheritedPredicate, sourceEffectivePredicate, joinExpression});
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                rewrittenConjunct = allInference.rewriteExpressionAllowNonDeterministic(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables), this.types);
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(deterministicInheritedPredicate)) {
                rewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables), this.types);
                if (rewrittenConjunct == null) continue;
                filteringSourceConjuncts.add(rewrittenConjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(filteringSourceEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables), this.types);
                if (rewritten == null) continue;
                sourceConjuncts.add(rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(sourceEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables), this.types);
                if (rewritten == null) continue;
                filteringSourceConjuncts.add(rewritten);
            }
            sourceConjuncts.addAll(allInferenceWithoutSourceInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)sourceVariables), this.types).getScopeEqualities());
            filteringSourceConjuncts.addAll(allInferenceWithoutFilteringSourceInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)filteringSourceVariables), this.types).getScopeEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), ExpressionUtils.combineConjuncts(filteringSourceConjuncts));
            SemiJoinNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts(postJoinConjuncts)));
            }
            return output;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            if (node.hasEmptyGroupingSet()) {
                return this.visitPlan((PlanNode)node, context);
            }
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            List groupingKeyVariables = node.getGroupingKeys();
            postAggregationConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                if (node.getGroupIdVariable().isPresent() && VariablesExtractor.extractUnique(conjunct, this.types).contains(node.getGroupIdVariable().get())) {
                    postAggregationConjuncts.add(conjunct);
                    continue;
                }
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in((Collection)groupingKeyVariables), this.types);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in((Collection)groupingKeyVariables)).apply(arg_0)), this.types);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            AggregationNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getAggregations(), node.getGroupingSets(), (List)ImmutableList.of(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts(postAggregationConjuncts)));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postUnnestConjuncts = new ArrayList<Expression>();
            postUnnestConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(ExpressionDeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<VariableReferenceExpression>)Predicates.in(node.getReplicateVariables()), this.types);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postUnnestConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<VariableReferenceExpression>)((com.google.common.base.Predicate)arg_0 -> ((com.google.common.base.Predicate)Predicates.in(node.getReplicateVariables())).apply(arg_0)), this.types);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            UnnestNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateVariables(), node.getUnnestVariables(), node.getOrdinalityVariable());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), (PlanNode)output, OriginalExpressionUtils.castToRowExpression(ExpressionUtils.combineConjuncts(postUnnestConjuncts)));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression predicate = this.simplifyExpression(context.get());
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)predicate)) {
                return new FilterNode(this.idAllocator.getNextId(), (PlanNode)node, OriginalExpressionUtils.castToRowExpression(predicate));
            }
            return node;
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set<VariableReferenceExpression> predicateVariables = VariablesExtractor.extractUnique(context.get(), this.types);
            Preconditions.checkState((!predicateVariables.contains(node.getIdVariable()) ? 1 : 0) != 0, (Object)"UniqueId in predicate is not yet supported");
            return context.defaultRewrite(node, context.get());
        }

        private /* synthetic */ boolean lambda$visitMarkDistinct$9(Set pushDownableVariables, Expression conjunct) {
            return pushDownableVariables.containsAll(VariablesExtractor.extractUnique(conjunct, this.types));
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            public Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }
    }
}

