/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.optimizations.ScalarAggregationToJoinRewriter;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.util.MorePredicates;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarAggregationToJoin
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.nonEmpty(Patterns.LateralJoin.correlation()));
    private final FunctionManager functionManager;

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    public TransformCorrelatedScalarAggregationToJoin(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = lateralJoinNode.getSubquery();
        if (!QueryCardinalityUtil.isScalar(subquery, context.getLookup())) {
            return Rule.Result.empty();
        }
        Optional<AggregationNode> aggregation = TransformCorrelatedScalarAggregationToJoin.findAggregation(subquery, context.getLookup());
        if (!aggregation.isPresent() || !aggregation.get().getGroupingKeys().isEmpty()) {
            return Rule.Result.empty();
        }
        ScalarAggregationToJoinRewriter rewriter = new ScalarAggregationToJoinRewriter(this.functionManager, context.getVariableAllocator(), context.getIdAllocator(), context.getLookup());
        PlanNode rewrittenNode = rewriter.rewriteScalarAggregation(lateralJoinNode, aggregation.get());
        if (rewrittenNode instanceof LateralJoinNode) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewrittenNode);
    }

    private static Optional<AggregationNode> findAggregation(PlanNode rootNode, Lookup lookup) {
        return PlanNodeSearcher.searchFrom(rootNode, lookup).where(AggregationNode.class::isInstance).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class, EnforceSingleRowNode.class)).findFirst();
    }
}

